/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wunda_blau.search.actions;

import Sirius.server.middleware.impls.domainserver.DomainServerImpl;
import Sirius.server.middleware.interfaces.domainserver.MetaService;
import Sirius.server.middleware.interfaces.domainserver.MetaServiceStore;
import Sirius.server.newuser.User;
import Sirius.server.sql.DBConnection;
import Sirius.server.sql.SQLTools;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.geom.util.AffineTransformation;
import com.vividsolutions.jts.io.WKTReader;
import de.cismet.cids.custom.utils.ServerStadtbilderConf;
import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.cids.server.actions.UserAwareServerAction;
import de.cismet.commons.security.handler.SimpleHttpAccessHandler;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import de.cismet.tools.transformations.PointCoordinatePair;
import de.cismet.tools.transformations.TransformationTools;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.log4j.Logger;

public class SchraegluftbilderForGeomSearchAction
implements UserAwareServerAction,
MetaServiceStore,
ConnectionContextStore {
    private static final Logger LOG = Logger.getLogger(SchraegluftbilderForGeomSearchAction.class);
    public static final String TASK_NAME = "SchraegluftbilderForGeomSearch";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    public static final String QUERY_TEMPLATE = "SELECT DISTINCT ON (extract(year from sb_stadtbildserie.aufnahmedatum), sb_blickrichtung.schluessel)    sb_stadtbildserie.id AS id,    extract(year from sb_stadtbildserie.aufnahmedatum) AS year,    sb_blickrichtung.schluessel AS direction,    sb_stadtbild.bildnummer AS number,    st_distance(st_centroid(geom.geo_field), searchPoint.geo_field) AS distance,    geom.geo_field AS geometry FROM sb_stadtbildserie    LEFT JOIN geom ON sb_stadtbildserie.geom = geom.id    LEFT JOIN sb_blickrichtung ON sb_stadtbildserie.blickrichtung = sb_blickrichtung.id    LEFT JOIN sb_serie_bild_array ON sb_serie_bild_array.sb_stadtbildserie_reference = sb_stadtbildserie.id    LEFT JOIN sb_stadtbild ON sb_serie_bild_array.stadtbild = sb_stadtbild.id    , (SELECT st_geomfromtext(?, ?) AS geo_field) AS searchPoint WHERE    sb_stadtbildserie.bildtyp = 3    AND sb_blickrichtung.schluessel = ANY(?)    AND extract(year FROM sb_stadtbildserie.aufnahmedatum) = ANY(?)    AND st_contains(geom.geo_field, searchPoint.geo_field) ORDER BY    extract(year FROM sb_stadtbildserie.aufnahmedatum) desc,    sb_blickrichtung.schluessel,    st_distance(st_centroid(geom.geo_field), searchPoint.geo_field)";
    private static final int SRID = 25832;
    public static String PARAM_DIRECTION = "DIRECTION";
    public static String PARAM_YEAR = "YEAR";
    private MetaService metaService;
    private ConnectionContext connectionContext;
    private User user;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public Object execute(Object body, ServerActionParameter ... saps) {
        Geometry searchGeometry;
        if (body instanceof String || body instanceof byte[]) {
            int wktSrid;
            String wktString = body instanceof String ? (String)body : new String((byte[])body);
            int skIndex = wktString.indexOf(59);
            if (skIndex > 0) {
                String sridKV = wktString.substring(0, skIndex);
                int eqIndex = sridKV.indexOf(61);
                if (eqIndex > 0) {
                    wktSrid = Integer.parseInt(sridKV.substring(eqIndex + 1));
                    String string = wktString.substring(skIndex + 1);
                } else {
                    String string = wktString;
                    wktSrid = 25832;
                }
            } else {
                String string = wktString;
                wktSrid = 25832;
            }
            try {
                void var6_23;
                if (wktSrid < 0) {
                    searchGeometry = new WKTReader().read((String)var6_23);
                    searchGeometry.setSRID(wktSrid);
                }
                GeometryFactory geomFactory = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), wktSrid);
                searchGeometry = new WKTReader(geomFactory).read((String)var6_23);
                searchGeometry.setSRID(wktSrid);
            }
            catch (Exception ex) {
                LOG.error((Object)"could not parse or transform WKT String", (Throwable)ex);
                throw new IllegalArgumentException(ex);
            }
        } else if (body instanceof Geometry) {
            searchGeometry = (Geometry)body;
        } else {
            throw new IllegalArgumentException("no search geometry given");
        }
        Geometry offsetSearchGeometry = searchGeometry;
        ArrayList<String> directions = new ArrayList<String>();
        if (saps != null) {
            for (ServerActionParameter sap : saps) {
                if (!PARAM_DIRECTION.equals(sap.getKey())) continue;
                directions.add(Direction.valueOf((String)sap.getValue()).toString());
            }
        }
        if (directions.isEmpty()) {
            directions.add(Direction.NORTH.toString());
            directions.add(Direction.EAST.toString());
            directions.add(Direction.SOUTH.toString());
            directions.add(Direction.WEST.toString());
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (saps != null) {
            for (ServerActionParameter sap : saps) {
                if (!PARAM_YEAR.equals(sap.getKey())) continue;
                arrayList.add((Integer)sap.getValue());
            }
        }
        if (arrayList.isEmpty()) {
            arrayList.add(2018);
        }
        ArrayList<Info> infos = new ArrayList<Info>();
        try {
            Connection connection = DomainServerImpl.getServerInstance().getConnectionPool().getConnection();
            try {
                PreparedStatement preparedStatement = connection.prepareStatement(QUERY_TEMPLATE);
                preparedStatement.setString(1, offsetSearchGeometry.toText());
                preparedStatement.setInt(2, offsetSearchGeometry.getSRID());
                preparedStatement.setArray(3, connection.createArrayOf("text", directions.toArray()));
                preparedStatement.setArray(4, connection.createArrayOf("integer", arrayList.toArray()));
                ResultSet resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    int id = resultSet.getInt(1);
                    int year = resultSet.getInt(2);
                    String direction = resultSet.getString(3);
                    String name = resultSet.getString(4);
                    double distance = resultSet.getDouble(5);
                    Geometry geometry = SQLTools.getGeometryFromResultSetObject((Object)resultSet.getObject(6));
                    URL[] urls = ServerStadtbilderConf.getInstance().getHighresPictureUrls(name, 3, year, direction);
                    URL imgUrl = null;
                    for (URL url : urls) {
                        if (!new SimpleHttpAccessHandler().checkIfURLaccessible(url)) continue;
                        imgUrl = url;
                    }
                    Coordinate center = geometry.getCentroid().getCoordinate();
                    Coordinate[] coordinates = new Coordinate[4];
                    for (Coordinate coordinate : Arrays.copyOf(geometry.getCoordinates(), 4)) {
                        if (coordinate.x < center.x && coordinate.y < center.y) {
                            coordinates[0] = coordinate;
                            continue;
                        }
                        if (coordinate.x > center.x && coordinate.y < center.y) {
                            coordinates[1] = coordinate;
                            continue;
                        }
                        if (coordinate.x > center.x && coordinate.y > center.y) {
                            coordinates[2] = coordinate;
                            continue;
                        }
                        if (!(coordinate.x < center.x) || !(coordinate.y > center.y)) continue;
                        coordinates[3] = coordinate;
                    }
                    Rectangle rect = new Rectangle(0, 0, 1, 1);
                    PointCoordinatePair[] pairs = new PointCoordinatePair[]{new PointCoordinatePair(new Point((int)rect.getMinX(), (int)rect.getMinY()), coordinates[0]), new PointCoordinatePair(new Point((int)rect.getMaxX(), (int)rect.getMinY()), coordinates[1]), new PointCoordinatePair(new Point((int)rect.getMaxX(), (int)rect.getMaxY()), coordinates[2]), new PointCoordinatePair(new Point((int)rect.getMinX(), (int)rect.getMaxY()), coordinates[3])};
                    AffineTransformation transformation = TransformationTools.calculateAvgTransformation((PointCoordinatePair[])pairs);
                    Geometry transformedSearchGeometry = transformation.getInverse().transform(offsetSearchGeometry);
                    Point2D.Double point = Direction.NORTH.toString().equals(direction) ? new Point2D.Double(transformedSearchGeometry.getCoordinate().x, 1.0 - transformedSearchGeometry.getCoordinate().y) : (Direction.WEST.toString().equals(direction) ? new Point2D.Double(transformedSearchGeometry.getCoordinate().y, transformedSearchGeometry.getCoordinate().x) : (Direction.SOUTH.toString().equals(direction) ? new Point2D.Double(1.0 - transformedSearchGeometry.getCoordinate().x, transformedSearchGeometry.getCoordinate().y) : (Direction.EAST.toString().equals(direction) ? new Point2D.Double(1.0 - transformedSearchGeometry.getCoordinate().y, 1.0 - transformedSearchGeometry.getCoordinate().x) : null)));
                    Info info = new Info(imgUrl, direction, year, point);
                    infos.add(info);
                }
            }
            catch (Throwable throwable) {
                DBConnection.closeConnections((Connection[])new Connection[]{connection});
                throw throwable;
            }
            DBConnection.closeConnections((Connection[])new Connection[]{connection});
            String json = OBJECT_MAPPER.writeValueAsString(infos);
            LOG.fatal((Object)json);
            return json;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public String getTaskName() {
        return TASK_NAME;
    }

    public void setMetaService(MetaService metaService) {
        this.metaService = metaService;
    }

    public MetaService getMetaService() {
        return this.metaService;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    static class Info {
        private final URL url;
        private final String direction;
        private final Integer year;
        private final Point2D.Double point;

        public URL getUrl() {
            return this.url;
        }

        public String getDirection() {
            return this.direction;
        }

        public Integer getYear() {
            return this.year;
        }

        public Point2D.Double getPoint() {
            return this.point;
        }

        public Info(URL url, String direction, Integer year, Point2D.Double point) {
            this.url = url;
            this.direction = direction;
            this.year = year;
            this.point = point;
        }
    }

    public static enum Direction {
        NORTH,
        EAST,
        SOUTH,
        WEST;

    }
}

