/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wunda_blau.search.actions;

import de.cismet.cids.custom.utils.ServerStadtbilderConf;
import de.cismet.cids.custom.wunda_blau.search.actions.ImageAnnotator;
import de.cismet.cids.server.actions.ServerAction;
import de.cismet.cids.server.actions.ServerActionHelper;
import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.commons.security.handler.SimpleHttpAccessHandler;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import org.apache.log4j.Logger;

public class TifferAction
implements ServerAction {
    private static final Logger LOG = Logger.getLogger(TifferAction.class);
    public static final String ACTION_NAME = "tifferAction";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(Object body, ServerActionParameter ... params) {
        ImageAnnotator a;
        HashMap parameterMap = this.createHashMap(params);
        String txt = ServerStadtbilderConf.getInstance().getTifferAnnotation();
        String bildnummer = (String)parameterMap.get(ParameterType.BILDNUMMER.toString());
        Integer bildtypId = (Integer)parameterMap.get(ParameterType.BILDTYP_ID.toString());
        String blickrichtung = (String)parameterMap.get(ParameterType.BLICKRICHTUNG.toString());
        Integer jahr = (Integer)parameterMap.get(ParameterType.JAHR.toString());
        if (bildnummer == null) {
            return null;
        }
        String format = (String)parameterMap.get(ParameterType.FORMAT.toString());
        String scale = (String)parameterMap.get(ParameterType.SCALE.toString());
        String subdir = (String)parameterMap.get(ParameterType.SUBDIR.toString());
        if (subdir == null) {
            subdir = "";
        }
        txt = txt.replace("{imageNumber}", bildnummer);
        txt = txt.replace("(c)", "\u00a9");
        format = format != null ? (format.equalsIgnoreCase("jpg") ? "JPG" : (format.equalsIgnoreCase("jpeg") ? "JPEG" : (format.equalsIgnoreCase("bmp") ? "BMP" : (format.equalsIgnoreCase("png") ? "PNG" : (format.equalsIgnoreCase("tif") ? "TIF" : "TIFF"))))) : "TIFF";
        double scaleFactor = 1.0;
        try {
            if (!(scale == null || scale.equals("0.0") || scale.equals("0") || scale.equals(".0"))) {
                scaleFactor = Double.parseDouble(scale);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"scale Format", (Throwable)e);
        }
        try {
            URL imgUrl = null;
            for (URL url : ServerStadtbilderConf.getInstance().getHighresPictureUrls(bildnummer, bildtypId, jahr, blickrichtung)) {
                if (!new SimpleHttpAccessHandler().checkIfURLaccessible(url)) continue;
                imgUrl = url;
            }
            a = new ImageAnnotator(imgUrl, txt);
        }
        catch (MalformedURLException ex) {
            LOG.error((Object)"MalformedURLException while annotating the image.", (Throwable)ex);
            return null;
        }
        catch (IOException ex) {
            LOG.error((Object)"IOException while annotating the image.", (Throwable)ex);
            return null;
        }
        catch (Exception ex) {
            LOG.error((Object)"Some other exception while annotating the image.", (Throwable)ex);
            return null;
        }
        BufferedImage bi = a.getAnnotatedImage();
        Image image = null;
        if (scaleFactor != 1.0) {
            image = bi.getScaledInstance((int)((double)bi.getWidth() * scaleFactor), (int)((double)bi.getHeight() * scaleFactor), 2);
        }
        if (image != null) {
            bi = new BufferedImage(image.getWidth(null), image.getHeight(null), bi.getType());
            bi.getGraphics().drawImage(image, 0, 0, null);
        }
        ByteArrayOutputStream out = null;
        try {
            out = new ByteArrayOutputStream();
            TifferAction.writeImage(bi, format, out);
            Object object = ServerActionHelper.asyncByteArrayHelper((Object)out.toByteArray(), (String)("tiffer." + format));
            return object;
        }
        catch (IOException ex) {
            LOG.error((Object)"Error while creating the ByteArrayOutputStream", (Throwable)ex);
            Object var19_25 = null;
            return var19_25;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ex) {
                    LOG.error((Object)ex.getMessage(), (Throwable)ex);
                }
            }
        }
    }

    public static void writeImage(RenderedImage image, String format, Object output) throws IOException {
        Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName(format);
        ImageWriter writer = iter.next();
        ImageWriteParam iwp = writer.getDefaultWriteParam();
        iwp.setCompressionMode(2);
        iwp.setCompressionQuality(1.0f);
        ImageOutputStream ios = ImageIO.createImageOutputStream(output);
        writer.setOutput(ios);
        writer.write(null, new IIOImage(image, null, null), iwp);
        writer.dispose();
    }

    private HashMap createHashMap(ServerActionParameter ... params) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (ServerActionParameter param : params) {
            map.put(param.getKey(), param.getValue());
        }
        return map;
    }

    public String getTaskName() {
        return ACTION_NAME;
    }

    public static enum ParameterType {
        BILDNUMMER,
        BILDTYP_ID,
        BLICKRICHTUNG,
        JAHR,
        FORMAT,
        SCALE,
        SUBDIR;

    }
}

