/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wunda_blau.search.actions;

import Sirius.server.MetaClassCache;
import Sirius.server.middleware.interfaces.domainserver.MetaService;
import Sirius.server.middleware.interfaces.domainserver.MetaServiceStore;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import Sirius.server.newuser.User;
import de.cismet.cids.custom.utils.alkis.VermessungPictureFinder;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.cids.server.actions.UserAwareServerAction;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import java.util.HashMap;
import java.util.Map;

public class VermessungPictureServerAction
implements UserAwareServerAction,
MetaServiceStore,
ConnectionContextStore {
    public static String TASK_NAME = "VermessungPicture";
    private User user;
    private MetaService metaService;
    private final Map<Integer, CidsBean> gemarkungMap = new HashMap<Integer, CidsBean>();
    private ConnectionContext connectionContext = ConnectionContext.createDummy();

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public void setMetaService(MetaService metaService) {
        this.metaService = metaService;
    }

    public MetaService getMetaService() {
        return this.metaService;
    }

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    public Object execute(Object body, ServerActionParameter ... params) {
        VermessungPictureFinder finder = new VermessungPictureFinder(this.getUser(), this.getMetaService(), this.getConnectionContext());
        Body request = body instanceof String ? Body.valueOf((String)body) : (body instanceof Body ? (Body)((Object)body) : null);
        String schluessel = null;
        Integer gemarkung = null;
        CidsBean gemarkungBean = null;
        String flur = null;
        String blatt = null;
        Integer steuerbezirk = null;
        String bezeichner = null;
        Boolean historisch = null;
        String link = null;
        String version = null;
        Integer kmquadrat = null;
        String ordner = null;
        Integer nummer = null;
        if (params != null) {
            for (ServerActionParameter sap : params) {
                if (sap.getKey().equals(Param.SCHLUESSEL.toString())) {
                    schluessel = (String)sap.getValue();
                    continue;
                }
                if (sap.getKey().equals(Param.GEMARKUNG.toString())) {
                    gemarkung = (Integer)sap.getValue();
                    if (this.gemarkungMap.containsKey(gemarkung)) {
                        gemarkungBean = this.gemarkungMap.get(gemarkung);
                        continue;
                    }
                    try {
                        MetaClass mc = MetaClassCache.getInstance().getMetaClass("WUNDA_BLAU", "vermessung_gemarkung");
                        MetaObject mo = this.getMetaService().getMetaObject(this.getUser(), gemarkung.intValue(), mc.getId(), this.getConnectionContext());
                        gemarkungBean = mo.getBean();
                        this.gemarkungMap.put(gemarkung, gemarkungBean);
                    }
                    catch (Exception exception) {}
                    continue;
                }
                if (sap.getKey().equals(Param.FLUR.toString())) {
                    flur = (String)sap.getValue();
                    continue;
                }
                if (sap.getKey().equals(Param.BLATT.toString())) {
                    blatt = (String)sap.getValue();
                    continue;
                }
                if (sap.getKey().equals(Param.STEUERBEZIRK.toString())) {
                    steuerbezirk = (Integer)sap.getValue();
                    continue;
                }
                if (sap.getKey().equals(Param.BEZEICHNER.toString())) {
                    bezeichner = (String)sap.getValue();
                    continue;
                }
                if (sap.getKey().equals(Param.HISTORISCH.toString())) {
                    historisch = (Boolean)sap.getValue();
                    continue;
                }
                if (sap.getKey().equals(Param.LINK.toString())) {
                    link = (String)sap.getValue();
                    continue;
                }
                if (sap.getKey().equals(Param.VERSION.toString())) {
                    version = (String)sap.getValue();
                    continue;
                }
                if (sap.getKey().equals(Param.KMQUADRAT.toString())) {
                    kmquadrat = (Integer)sap.getValue();
                    continue;
                }
                if (sap.getKey().equals(Param.ORDNER.toString())) {
                    ordner = (String)sap.getValue();
                    continue;
                }
                if (!sap.getKey().equals(Param.NUMMER.toString())) continue;
                nummer = (Integer)sap.getValue();
            }
        }
        if (request != null) {
            switch (request) {
                case FIND_VERMESSUNGSRISS: {
                    return finder.findVermessungsrissPicture(schluessel, gemarkung, flur, blatt);
                }
                case GET_VERMESSUNGSRISS_FILENAME: {
                    return finder.getVermessungsrissFilename(schluessel, gemarkung, flur, blatt);
                }
                case GET_VERMESSUNGSRISS_LINK_FILENAME: {
                    return finder.getVermessungsrissLinkFilename(link);
                }
                case FIND_GRENZNIEDERSCHRIFT: {
                    return finder.findGrenzniederschriftPicture(schluessel, gemarkung, flur, blatt);
                }
                case GET_GRENZNIEDERSCHRIFT_FILENAME: {
                    return finder.getGrenzniederschriftFilename(schluessel, gemarkung, flur, blatt);
                }
                case GET_GRENZNIEDERSCHRIFT_LINK_FILENAME: {
                    return finder.getGrenzniederschriftLinkFilename(link);
                }
                case FIND_BUCHWERK: {
                    return finder.findBuchwerkPicture(schluessel, gemarkungBean, steuerbezirk, bezeichner, historisch);
                }
                case GET_BUCHWERK_FILENAME: {
                    return finder.getBuchwerkFilename(schluessel, gemarkungBean, steuerbezirk, bezeichner, historisch);
                }
                case FIND_GEWANNE: {
                    boolean liste = gemarkungBean != null;
                    return finder.findGewannenPicture(gemarkungBean, kmquadrat, liste);
                }
                case GET_GEWANNE_FILENAME: {
                    boolean liste = gemarkungBean != null;
                    return finder.getGewannenFilename(gemarkungBean, kmquadrat, liste);
                }
                case FIND_INSELKARTE: {
                    return finder.findInselkartePicture(schluessel, gemarkungBean, flur, blatt, version);
                }
                case GET_INSELKARTE_FILENAME: {
                    return finder.getInselkarteFilename(schluessel, gemarkungBean, flur, blatt, version);
                }
                case FIND_GEBAEUDEBESCHREIBUNG: {
                    return finder.findGebaeudebeschreibungPicture(ordner, nummer);
                }
                case GET_GEBAEUDEBESCHREIBUNG_FILENAME: {
                    return finder.getGebaeudebeschreibungFilename(ordner, nummer);
                }
            }
        }
        return null;
    }

    public String getTaskName() {
        return TASK_NAME;
    }

    public static enum Param {
        SCHLUESSEL,
        GEMARKUNG,
        FLUR,
        BLATT,
        STEUERBEZIRK,
        BEZEICHNER,
        HISTORISCH,
        LINK,
        VERSION,
        KMQUADRAT,
        ORDNER,
        NUMMER;

    }

    public static enum Body {
        FIND_GRENZNIEDERSCHRIFT,
        GET_GRENZNIEDERSCHRIFT_FILENAME,
        GET_GRENZNIEDERSCHRIFT_LINK_FILENAME,
        FIND_VERMESSUNGSRISS,
        GET_VERMESSUNGSRISS_FILENAME,
        GET_VERMESSUNGSRISS_LINK_FILENAME,
        FIND_BUCHWERK,
        GET_BUCHWERK_FILENAME,
        FIND_INSELKARTE,
        GET_INSELKARTE_FILENAME,
        FIND_GEWANNE,
        GET_GEWANNE_FILENAME,
        FIND_GEBAEUDEBESCHREIBUNG,
        GET_GEBAEUDEBESCHREIBUNG_FILENAME;

    }
}

