/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wunda_blau.search.actions;

import Sirius.server.newuser.User;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.cismet.cids.custom.utils.GeneralUtils;
import de.cismet.cids.custom.utils.VkMailConfigJson;
import de.cismet.cids.custom.utils.WundaBlauServerResources;
import de.cismet.cids.server.actions.ServerAction;
import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.cids.server.actions.UserAwareServerAction;
import de.cismet.cids.utils.serverresources.ServerResourcesLoader;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import java.io.UnsupportedEncodingException;
import org.apache.log4j.Logger;

public class VkSendMailServerAction
implements ServerAction,
ConnectionContextStore,
UserAwareServerAction {
    private static final Logger LOG = Logger.getLogger(VkSendMailServerAction.class);
    public static final String TASK_NAME = "vkSendMail";
    private ConnectionContext connectionContext = ConnectionContext.createDummy();
    private User user;

    public VkSendMailServerAction() {
    }

    private VkSendMailServerAction(User user, ConnectionContext connectionContext) {
        this.user = user;
        this.connectionContext = connectionContext;
    }

    public Object execute(Object o, ServerActionParameter ... params) {
        block12: {
            try {
                String absender = null;
                String mail_adress = null;
                String betreff = null;
                String content = null;
                String encoding = null;
                String sendEmailEncoding = "utf-8";
                if (params == null) break block12;
                for (ServerActionParameter sap : params) {
                    if (sap.getKey().equals(Parameter.ABSENDER.toString())) {
                        absender = (String)sap.getValue();
                        continue;
                    }
                    if (sap.getKey().equals(Parameter.MAIL_ADRESS.toString())) {
                        mail_adress = (String)sap.getValue();
                        continue;
                    }
                    if (sap.getKey().equals(Parameter.BETREFF.toString())) {
                        betreff = (String)sap.getValue();
                        continue;
                    }
                    if (sap.getKey().equals(Parameter.CONTENT.toString())) {
                        content = (String)sap.getValue();
                        continue;
                    }
                    if (!sap.getKey().equals(Parameter.ENCODING.toString())) continue;
                    encoding = (String)sap.getValue();
                }
                if (encoding != null) {
                    try {
                        if (betreff != null) {
                            betreff = new String(betreff.getBytes(encoding), "utf-8");
                        }
                        if (content != null) {
                            content = new String(content.getBytes(encoding), "utf-8");
                        }
                    }
                    catch (UnsupportedEncodingException e) {
                        LOG.error((Object)("Unsupported encoding used: " + encoding + " and " + "utf-8"), (Throwable)e);
                    }
                }
                VkMailConfigJson mailConfig = (VkMailConfigJson)new ObjectMapper().readValue(ServerResourcesLoader.getInstance().loadText(WundaBlauServerResources.VK_MAIL_CONFIGURATION.getValue()), VkMailConfigJson.class);
                String cmdTemplate = mailConfig.getCmdTemplate();
                return GeneralUtils.sendMail(cmdTemplate, absender, mail_adress, betreff, content);
            }
            catch (Exception ex) {
                LOG.error((Object)ex, (Throwable)ex);
                return ex;
            }
        }
        return null;
    }

    public String getTaskName() {
        return TASK_NAME;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public void initWithConnectionContext(ConnectionContext cc) {
        this.connectionContext = cc;
    }

    public User getUser() {
        return this.user;
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    public static enum Parameter {
        ABSENDER,
        MAIL_ADRESS,
        BETREFF,
        CONTENT,
        ENCODING;

    }
}

