/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wunda_blau.search.server;

import Sirius.server.middleware.types.AbstractAttributeRepresentationFormater;
import Sirius.server.middleware.types.LightweightMetaObject;
import Sirius.server.middleware.types.MetaObjectNode;
import Sirius.server.middleware.types.StringPatternFormater;
import de.cismet.cids.server.search.AbstractCidsServerSearch;
import de.cismet.cids.server.search.MetaObjectNodeServerSearch;
import de.cismet.cids.server.search.SearchException;
import de.cismet.cidsx.server.api.types.SearchInfo;
import de.cismet.cidsx.server.search.RestApiCidsServerSearch;
import de.cismet.cidsx.server.search.builtin.legacy.LightweightMetaObjectsSearch;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

public abstract class AbstractMonToLwmoSearch
extends AbstractCidsServerSearch
implements RestApiCidsServerSearch,
LightweightMetaObjectsSearch,
ConnectionContextStore {
    private final SearchInfo searchInfo;
    private final String tableName;
    private final String domain;
    private String representationPattern = "%s";
    private String[] representationFields = new String[]{"name"};
    private ConnectionContext connectionContext = ConnectionContext.createDummy();

    protected AbstractMonToLwmoSearch(SearchInfo searchInfo, String tableName, String domain) {
        this.searchInfo = searchInfo;
        this.tableName = tableName;
        this.domain = domain;
    }

    public abstract MetaObjectNodeServerSearch getMonSearch();

    public Collection performServerSearch() throws SearchException {
        MetaObjectNodeServerSearch monSearch = this.getMonSearch();
        if (monSearch == null) {
            throw new SearchException("monSearch has to be set");
        }
        monSearch.setUser(this.getUser());
        monSearch.setActiveLocalServers(this.getActiveLocalServers());
        if (monSearch instanceof ConnectionContextStore) {
            ((ConnectionContextStore)monSearch).initWithConnectionContext(this.getConnectionContext());
        }
        ArrayList<LightweightMetaObject> lwmos = new ArrayList<LightweightMetaObject>();
        for (MetaObjectNode mon : monSearch.performServerSearch()) {
            HashMap<String, String> attributeMap = new HashMap<String, String>();
            attributeMap.put("name", mon.getName());
            LightweightMetaObject lwmo = new LightweightMetaObject(mon.getClassId(), mon.getObjectId(), mon.getDomain(), this.getUser(), attributeMap, (AbstractAttributeRepresentationFormater)new StringPatternFormater(this.getRepresentationPattern(), this.getRepresentationFields()));
            lwmos.add(lwmo);
        }
        return lwmos;
    }

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
    }

    public SearchInfo getSearchInfo() {
        return this.searchInfo;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getRepresentationPattern() {
        return this.representationPattern;
    }

    public void setRepresentationPattern(String representationPattern) {
        this.representationPattern = representationPattern;
    }

    public String[] getRepresentationFields() {
        return this.representationFields;
    }

    public void setRepresentationFields(String[] representationFields) {
        this.representationFields = representationFields;
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }
}

