/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wunda_blau.search.server;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import de.cismet.cids.server.search.AbstractCidsServerSearch;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeSet;

public class AlboFlaecheLandesRegNrSearch
extends AbstractCidsServerSearch
implements ConnectionContextStore {
    private static final String QUERY_AREA = "SELECT landreg from baublock where st_intersects(geom, '%1$s'::geometry) order by st_area(st_intersection(geom, '%1$s'::geometry)) desc limit 1";
    private static final String QUERY_LFD_NR = "select lpad(right(geodaten_id, 3)::text, 4, '0') from albo_flaeche where ('0' || left(geodaten_id, 5)) = '%1s'";
    private final String geometryAsText;
    private String landesregistriernummer = null;
    private ConnectionContext connectionContext = ConnectionContext.createDummy();

    public AlboFlaecheLandesRegNrSearch(String geometryAsText) {
        this.geometryAsText = geometryAsText;
    }

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
    }

    public Collection performServerSearch() {
        MetaService ms = (MetaService)this.getActiveLocalServers().get("WUNDA_BLAU");
        if (!(ms == null || this.geometryAsText != null && this.geometryAsText.equals("null"))) {
            try {
                ArrayList landReg = ms.performCustomSearch(String.format(QUERY_AREA, this.geometryAsText), this.getConnectionContext());
                if (landReg != null && landReg.size() > 0 && landReg.get(0) != null && ((ArrayList)landReg.get(0)).size() > 0 && ((ArrayList)landReg.get(0)).get(0) != null) {
                    this.landesregistriernummer = String.valueOf(((ArrayList)landReg.get(0)).get(0));
                }
                if (this.landesregistriernummer != null) {
                    int i;
                    ArrayList nr = ms.performCustomSearch(String.format(QUERY_LFD_NR, this.landesregistriernummer), this.getConnectionContext());
                    int maxNumber = -1;
                    TreeSet<Integer> noSet = new TreeSet<Integer>();
                    if (nr != null && nr.size() > 0) {
                        for (i = 0; i < nr.size(); ++i) {
                            if (nr.get(i) == null || nr.size() <= 0) continue;
                            try {
                                int noToCheck = Integer.parseInt(String.valueOf(((ArrayList)nr.get(i)).get(0)));
                                noSet.add(noToCheck);
                                if (maxNumber >= noToCheck) continue;
                                maxNumber = noToCheck;
                                continue;
                            }
                            catch (NumberFormatException noToCheck) {
                                // empty catch block
                            }
                        }
                    }
                    ++maxNumber;
                    for (i = 0; i < 999; ++i) {
                        if (noSet.contains(i)) continue;
                        maxNumber = i;
                        break;
                    }
                    ArrayList resultList = new ArrayList();
                    ArrayList<String> numberList = new ArrayList<String>();
                    numberList.add(this.landesregistriernummer);
                    numberList.add(String.format("%04d", maxNumber));
                    resultList.add(numberList);
                    return resultList;
                }
                return null;
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return null;
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }
}

