/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wunda_blau.search.server;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import Sirius.server.middleware.types.MetaObjectNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.custom.wunda_blau.search.server.SearchProperties;
import de.cismet.cids.server.search.AbstractCidsServerSearch;
import de.cismet.cids.server.search.MetaObjectNodeServerSearch;
import de.cismet.cismap.commons.jtsgeometryfactories.PostGisGeometryFactory;
import de.cismet.connectioncontext.ConnectionContext;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;

public class BaumGebietAnsprechpartnerSearch
extends AbstractCidsServerSearch
implements MetaObjectNodeServerSearch {
    private static final transient Logger LOG = Logger.getLogger(BaumGebietAnsprechpartnerSearch.class);
    public static final String TABLE_NAME = "baum_ansprechpartner";
    public static final String TABLE_MELDUNG = "baum_meldung";
    public static final String TABLE_GEBIET = "baum_gebiet";
    public static final String TABLE_MELDUNG_AP = "baum_meldung_ansprechpartner";
    public static final String TABLE_ORTSTERMIN_AP = "baum_ortstermin_ansprechpartner";
    public static final String TABLE_ORTSTERMIN = "baum_ortstermin";
    public static final String FIELD__ID = "id";
    public static final String FIELD__NAME = "name";
    public static final String FIELD__MAIL = "mail";
    public static final String FIELD__STRASSE = "strasse";
    public static final String FIELD__ORT = "ort";
    public static final String FIELD__BEMERKUNG = "bemerkung";
    public static final String FIELD__FK_AP = "fk_ansprechpartner";
    public static final String FIELD__FK_GEBIET = "fk_gebiet";
    public static final String FIELD__FK_MELDUNG = "fk_meldung";
    public static final String FIELD__ARR_AP = "arr_ansprechpartner";
    public static final String FIELD__REFERENCE_M = "baum_meldung_reference";
    public static final String FIELD__REFERENCE_OT = "baum_ortstermin_reference";
    public static final String FIELD__AZ = "aktenzeichen";
    public static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final String INTERSECTS_BUFFER = SearchProperties.getInstance().getIntersectsBuffer();
    private static final String QUERY_TEMPLATE = "WITH APs AS ( SELECT DISTINCT g.id, g.aktenzeichen, a.name, a.bemerkung, a.mail, a.ort, a.strasse FROM baum_meldung_ansprechpartner ma LEFT JOIN baum_meldung m ON m.arr_ansprechpartner =  ma.baum_meldung_reference LEFT JOIN baum_gebiet g ON g.id =  m.fk_gebiet LEFT JOIN baum_ansprechpartner a ON a.id = ma.fk_ansprechpartner UNION SELECT DISTINCT g.id, g.aktenzeichen, a.name, a.bemerkung, a.mail, a.ort, a.strasse FROM baum_ortstermin_ansprechpartner oa LEFT JOIN baum_ortstermin o ON o.arr_ansprechpartner =  o.fk_meldung LEFT JOIN baum_meldung m ON m.id =  oa.baum_ortstermin_reference LEFT JOIN baum_gebiet g ON g.id =  m.fk_gebiet LEFT JOIN baum_ansprechpartner a ON a.id = oa.fk_ansprechpartner)  SELECT DISTINCT   (SELECT c.id FROM cs_class c WHERE table_name ILIKE 'baum_gebiet') AS class_id, id, aktenzeichen FROM APs ";
    private ConnectionContext connectionContext = ConnectionContext.createDummy();
    private String ansprechpartnerName;
    private String ansprechpartnerStrasse;
    private String ansprechpartnerMail;
    private String ansprechpartnerBemerkung;
    private String ansprechpartnerOrt;
    private Geometry geom = null;

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
    }

    public Collection<MetaObjectNode> performServerSearch() {
        try {
            ArrayList<String> leftJoins = new ArrayList<String>();
            ArrayList<String> wheres = new ArrayList<String>();
            if (this.getAnsprechpartnerName() != null && !this.getAnsprechpartnerName().trim().equals("")) {
                wheres.add(String.format("name ILIKE '%%%s%%'", this.getAnsprechpartnerName()));
            }
            if (this.getAnsprechpartnerOrt() != null && !this.getAnsprechpartnerOrt().trim().equals("")) {
                wheres.add(String.format("ort ILIKE '%%%s%%'", this.getAnsprechpartnerOrt()));
            }
            if (this.getAnsprechpartnerBemerkung() != null && !this.getAnsprechpartnerBemerkung().trim().equals("")) {
                wheres.add(String.format("bemerkung ILIKE '%%%s%%'", this.getAnsprechpartnerBemerkung()));
            }
            if (this.getAnsprechpartnerMail() != null && !this.getAnsprechpartnerMail().trim().equals("")) {
                wheres.add(String.format("mail ILIKE '%%%s%%'", this.getAnsprechpartnerMail()));
            }
            if (this.getAnsprechpartnerStrasse() != null && !this.getAnsprechpartnerStrasse().trim().equals("")) {
                wheres.add(String.format("strasse ILIKE '%%%s%%'", this.getAnsprechpartnerStrasse()));
            }
            if (this.geom != null) {
                String geomString = PostGisGeometryFactory.getPostGisCompliantDbString((Geometry)this.geom);
                wheres.add("(geom.geo_field && st_GeometryFromText('" + geomString + "') AND st_intersects(st_buffer(geo_field, " + INTERSECTS_BUFFER + "),st_GeometryFromText('" + geomString + "')))");
                leftJoins.add("geom ON g.fk_geom = geom.id");
            }
            String leftJoin = !leftJoins.isEmpty() ? String.format("LEFT JOIN %s", String.join((CharSequence)" LEFT JOIN ", leftJoins)) : "";
            String where = !wheres.isEmpty() ? String.format("WHERE %s", String.join((CharSequence)" AND ", wheres)) : "";
            String query = String.format("%s %s %s", QUERY_TEMPLATE, leftJoin, where);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)query);
            }
            MetaService ms = (MetaService)this.getActiveLocalServers().get("WUNDA_BLAU");
            ArrayList<MetaObjectNode> mons = new ArrayList<MetaObjectNode>();
            ArrayList resultList = ms.performCustomSearch(query, this.getConnectionContext());
            for (ArrayList al : resultList) {
                int cid = (Integer)al.get(0);
                int oid = (Integer)al.get(1);
                String name = String.valueOf(al.get(2));
                MetaObjectNode mon = new MetaObjectNode("WUNDA_BLAU", oid, cid, name, null, null);
                mons.add(mon);
            }
            return mons;
        }
        catch (RemoteException ex) {
            LOG.error((Object)"error while searching for ansprechpartner in baum_gebiet", (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    public void setAnsprechpartnerName(String ansprechpartnerName) {
        this.ansprechpartnerName = ansprechpartnerName;
    }

    public String getAnsprechpartnerName() {
        return this.ansprechpartnerName;
    }

    public void setAnsprechpartnerStrasse(String ansprechpartnerStrasse) {
        this.ansprechpartnerStrasse = ansprechpartnerStrasse;
    }

    public String getAnsprechpartnerStrasse() {
        return this.ansprechpartnerStrasse;
    }

    public void setAnsprechpartnerMail(String ansprechpartnerMail) {
        this.ansprechpartnerMail = ansprechpartnerMail;
    }

    public String getAnsprechpartnerMail() {
        return this.ansprechpartnerMail;
    }

    public void setAnsprechpartnerBemerkung(String ansprechpartnerBemerkung) {
        this.ansprechpartnerBemerkung = ansprechpartnerBemerkung;
    }

    public String getAnsprechpartnerBemerkung() {
        return this.ansprechpartnerBemerkung;
    }

    public void setAnsprechpartnerOrt(String ansprechpartnerOrt) {
        this.ansprechpartnerOrt = ansprechpartnerOrt;
    }

    public String getAnsprechpartnerOrt() {
        return this.ansprechpartnerOrt;
    }

    public void setGeom(Geometry geom) {
        this.geom = geom;
    }

    public Geometry getGeom() {
        return this.geom;
    }
}

