/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wunda_blau.search.server;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import Sirius.server.middleware.types.MetaObjectNode;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import de.cismet.cids.custom.wunda_blau.search.server.SearchProperties;
import de.cismet.cids.server.search.AbstractCidsServerSearch;
import de.cismet.cids.server.search.MetaObjectNodeServerSearch;
import de.cismet.cismap.commons.jtsgeometryfactories.PostGisGeometryFactory;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import java.rmi.RemoteException;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;

public class CidsLandParcelSearchStatement
extends AbstractCidsServerSearch
implements MetaObjectNodeServerSearch,
ConnectionContextStore {
    private static final transient Logger LOG = Logger.getLogger(CidsLandParcelSearchStatement.class);
    private static final String INTERSECTS_BUFFER = SearchProperties.getInstance().getIntersectsBuffer();
    private boolean searchActualParcel;
    private boolean searchHistoricalParcel;
    private Date historicalFrom;
    private Date historicalTo;
    private Geometry geometry;
    private ConnectionContext connectionContext = ConnectionContext.createDummy();

    public CidsLandParcelSearchStatement(boolean actualParcel, Geometry geometry) {
        this(actualParcel, false, null, null, geometry);
    }

    public CidsLandParcelSearchStatement(boolean actualParcel, boolean historicalParcel, Date historicalFrom, Date historicalTo, Geometry geometry) {
        this.searchActualParcel = actualParcel;
        this.searchHistoricalParcel = historicalParcel;
        this.historicalFrom = historicalFrom;
        this.historicalTo = historicalTo;
        this.geometry = geometry;
    }

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
    }

    public Collection<MetaObjectNode> performServerSearch() {
        try {
            if (!(this.searchActualParcel || this.searchHistoricalParcel)) {
                return new ArrayList<MetaObjectNode>();
            }
            if (this.searchHistoricalParcel && (this.historicalFrom == null || this.historicalTo == null)) {
                return new ArrayList<MetaObjectNode>();
            }
            String query = "select distinct (select id from cs_class where table_name ilike 'flurstueck') as class_id, fl.id as object_id, fl.alkis_id from flurstueck fl ";
            boolean hasWhereClause = false;
            if (this.searchActualParcel || this.searchHistoricalParcel) {
                hasWhereClause = true;
                query = query + " where ( ";
                if (this.searchActualParcel) {
                    query = query + "fl.historisch is null";
                }
                if (this.searchActualParcel && this.searchHistoricalParcel) {
                    query = query + " or ";
                }
                if (this.searchHistoricalParcel) {
                    query = query + "(fl.historisch between '" + this.historicalFrom + "' and '" + this.historicalTo + "')";
                }
                query = query + " )";
            }
            if (this.geometry != null) {
                String geostring = PostGisGeometryFactory.getPostGisCompliantDbString((Geometry)this.geometry);
                if (this.geometry instanceof Polygon || this.geometry instanceof MultiPolygon) {
                    query = hasWhereClause ? query + " and " : query + " where ";
                    hasWhereClause = true;
                    query = query + " umschreibendes_rechteck &&\nst_buffer(\nst_GeometryFromText('" + geostring + "')\n, " + INTERSECTS_BUFFER + ")\nand st_intersects(umschreibendes_rechteck,st_buffer(st_GeometryFromText('" + geostring + "'), " + INTERSECTS_BUFFER + "))";
                } else {
                    query = hasWhereClause ? query + " and " : query + " where ";
                    hasWhereClause = true;
                    query = query + " umschreibendes_rechteck &&\nst_buffer(\nst_GeometryFromText('" + geostring + "')\n, " + INTERSECTS_BUFFER + ")\nand st_intersects(umschreibendes_rechteck, st_GeometryFromText('" + geostring + "'))";
                }
            }
            ArrayList<MetaObjectNode> result = new ArrayList<MetaObjectNode>();
            MetaService ms = (MetaService)this.getActiveLocalServers().get("WUNDA_BLAU");
            ArrayList searchResult = ms.performCustomSearch(query, this.getConnectionContext());
            for (ArrayList al : searchResult) {
                int cid = (Integer)al.get(0);
                int oid = (Integer)al.get(1);
                String nodename = (String)al.get(2);
                MetaObjectNode mon = new MetaObjectNode("WUNDA_BLAU", oid, cid, nodename, null, null);
                result.add(mon);
            }
            return result;
        }
        catch (RemoteException ex) {
            LOG.error((Object)"Problem", (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }
}

