/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wunda_blau.search.server;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import Sirius.server.middleware.types.MetaObjectNode;
import de.cismet.cids.custom.utils.formsolutions.FormSolutionsProperties;
import de.cismet.cids.server.search.AbstractCidsServerSearch;
import de.cismet.cids.server.search.MetaObjectNodeServerSearch;
import de.cismet.connectioncontext.ConnectionContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class FormSolutionsBestellungSearch
extends AbstractCidsServerSearch
implements MetaObjectNodeServerSearch {
    private static final transient Logger LOG = Logger.getLogger(FormSolutionsBestellungSearch.class);
    private String berechtigungspruefungSchluessel;
    private String transidHash;
    private String cacheId;
    private Boolean duplicate = Boolean.FALSE;
    private ConnectionContext connectionContext = ConnectionContext.createDummy();

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
    }

    public Collection<MetaObjectNode> performServerSearch() {
        try {
            ArrayList<MetaObjectNode> result = new ArrayList<MetaObjectNode>();
            HashMap<String, Object> filter = new HashMap<String, Object>();
            if (this.getDuplicate() != null) {
                filter.put("fs_bestellung.duplicate", this.getDuplicate());
            }
            if (this.getBerechtigungspruefungSchluessel() != null) {
                filter.put("berechtigungspruefung.schluessel", this.getBerechtigungspruefungSchluessel());
            }
            if (this.getTransidHash() != null) {
                filter.put(String.format("md5('%s'||fs_bestellung.transid)", FormSolutionsProperties.getInstance().getTransidHashpepper()), this.getTransidHash());
            }
            if (this.getCacheId() != null) {
                filter.put("fs_bestellung_cacheid.cache_id", this.getCacheId());
            }
            ArrayList<String> filterStrings = new ArrayList<String>();
            for (Map.Entry entry : filter.entrySet()) {
                if (entry.getValue() instanceof String) {
                    filterStrings.add(String.format("%s ILIKE '%s'", entry.getKey(), entry.getValue()));
                    continue;
                }
                if (entry.getValue() instanceof Boolean) {
                    filterStrings.add(String.format("%s IS %s", entry.getKey(), (Boolean)entry.getValue() != false ? "TRUE" : "NOT TRUE"));
                    continue;
                }
                if (entry.getValue() != null) continue;
                filterStrings.add(String.format("%s IS NULL", entry.getKey()));
            }
            String query = "SELECT (SELECT c.id FROM cs_class c WHERE table_name ilike 'fs_bestellung') AS class_id, fs_bestellung.id, max(fs_bestellung.transid) AS name FROM fs_bestellung LEFT JOIN berechtigungspruefung ON fs_bestellung.berechtigungspruefung = berechtigungspruefung.id LEFT JOIN fs_bestellung_cacheid ON fs_bestellung_cacheid.fk_bestellung = fs_bestellung.id WHERE " + (filterStrings.isEmpty() ? "TRUE" : String.join((CharSequence)" AND ", filterStrings)) + " GROUP BY (fs_bestellung.id);";
            MetaService ms = (MetaService)this.getActiveLocalServers().get("WUNDA_BLAU");
            ArrayList resultList = ms.performCustomSearch(query, this.getConnectionContext());
            for (ArrayList al : resultList) {
                int cid = (Integer)al.get(0);
                int oid = (Integer)al.get(1);
                String name = (String)al.get(2);
                MetaObjectNode mon = new MetaObjectNode("WUNDA_BLAU", oid, cid, name, null, null);
                result.add(mon);
            }
            return result;
        }
        catch (Exception ex) {
            LOG.error((Object)"error while searching for messungen", (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    public void setBerechtigungspruefungSchluessel(String berechtigungspruefungSchluessel) {
        this.berechtigungspruefungSchluessel = berechtigungspruefungSchluessel;
    }

    public String getBerechtigungspruefungSchluessel() {
        return this.berechtigungspruefungSchluessel;
    }

    public void setTransidHash(String transidHash) {
        this.transidHash = transidHash;
    }

    public String getTransidHash() {
        return this.transidHash;
    }

    public void setCacheId(String cacheId) {
        this.cacheId = cacheId;
    }

    public String getCacheId() {
        return this.cacheId;
    }

    public void setDuplicate(Boolean duplicate) {
        this.duplicate = duplicate;
    }

    public Boolean getDuplicate() {
        return this.duplicate;
    }
}

