/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wunda_blau.search.server;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import de.cismet.cids.server.search.AbstractCidsServerSearch;
import de.cismet.cids.server.search.SearchException;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.log4j.Logger;

public class GemeindeByGeometrySearch
extends AbstractCidsServerSearch
implements ConnectionContextStore {
    private static final Logger LOG = Logger.getLogger(GemeindeByGeometrySearch.class);
    private static final String DOMAIN = "WUNDA_BLAU";
    private static final String QUERY_GEMEINDE = "select distinct g.name from flurstueck f join gemarkung g on (g.gemarkungsnummer = f.gemarkungs_nr) where st_intersects(umschreibendes_rechteck,  st_setSrid('%s'::geometry, 25832))";
    private String geom;
    private ConnectionContext connectionContext = ConnectionContext.createDummy();

    public GemeindeByGeometrySearch(String geom) {
        this.geom = geom;
    }

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
    }

    public Collection performServerSearch() throws SearchException {
        try {
            MetaService metaService = (MetaService)this.getActiveLocalServers().get(DOMAIN);
            if (metaService != null) {
                ArrayList gemeindeList = metaService.performCustomSearch(String.format(QUERY_GEMEINDE, this.geom), this.getConnectionContext());
                String gemeindeCs = null;
                if (gemeindeList != null && gemeindeList.size() > 0) {
                    for (ArrayList resultPart : gemeindeList) {
                        if (gemeindeCs != null) {
                            gemeindeCs = gemeindeCs + ", ";
                            gemeindeCs = gemeindeCs + resultPart.get(0);
                            continue;
                        }
                        gemeindeCs = (String)resultPart.get(0);
                    }
                    return Arrays.asList(gemeindeCs);
                }
            } else {
                LOG.error((Object)"active local server not found");
            }
            return null;
        }
        catch (Exception ex) {
            throw new SearchException("error while loading verfahren objects", (Throwable)ex);
        }
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }
}

