/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wunda_blau.search.server;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import de.cismet.cids.server.search.AbstractCidsServerSearch;
import de.cismet.cids.server.search.SearchException;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import java.util.ArrayList;
import java.util.Collection;

public class PfPotenzialflaecheNextSchluesselServerSearch
extends AbstractCidsServerSearch
implements ConnectionContextStore {
    private static final String QUERY_TEMPLATE = "SELECT sub.middle, count(*)::integer AS count FROM (     SELECT substring(nummer, '[0-9]-([0-9]{4})-[0-9]+')::integer AS middle     FROM pf_potenzialflaeche ) AS sub WHERE %s GROUP BY sub.middle ORDER BY sub.middle DESC;";
    private ConnectionContext connectionContext = ConnectionContext.createDummy();
    private final Integer middle;

    public PfPotenzialflaecheNextSchluesselServerSearch(Integer middle) {
        this.middle = middle;
    }

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
    }

    public Collection performServerSearch() throws SearchException {
        MetaService ms = (MetaService)this.getActiveLocalServers().get("WUNDA_BLAU");
        if (ms != null) {
            try {
                String whereMiddle = this.middle != null ? String.format("sub.middle = %d", this.middle) : "sub.middle IS NOT NULL";
                String query = String.format(QUERY_TEMPLATE, whereMiddle);
                ArrayList lists = ms.performCustomSearch(query, this.getConnectionContext());
                return (Collection)lists.iterator().next();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }
}

