/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wunda_blau.search.server;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import Sirius.server.middleware.types.MetaClass;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.server.search.AbstractCidsServerSearch;
import de.cismet.cids.server.search.SearchException;
import de.cismet.cidsx.base.types.Type;
import de.cismet.cidsx.server.api.types.SearchInfo;
import de.cismet.cidsx.server.api.types.SearchParameterInfo;
import de.cismet.cidsx.server.search.RestApiCidsServerSearch;
import de.cismet.cidsx.server.search.builtin.legacy.LightweightMetaObjectsSearch;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.log4j.Logger;

public class StrAdrGeplanteAdresseStrasseSearch
extends AbstractCidsServerSearch
implements RestApiCidsServerSearch,
LightweightMetaObjectsSearch,
ConnectionContextStore {
    private static final Logger LOG = Logger.getLogger(StrAdrGeplanteAdresseStrasseSearch.class);
    private static final String TABLE__STRASSE = "str_adr_strasse";
    private static final String TABLE__SCHLUESSEL = "str_adr_strasse_schluessel";
    public static final String TOSTRING_TEMPLATE = "%1$s (%2$s)";
    private ConnectionContext connectionContext = ConnectionContext.createDummy();
    private final SearchInfo searchInfo = new SearchInfo(((Object)((Object)this)).getClass().getName(), ((Object)((Object)this)).getClass().getSimpleName(), "Builtin Legacy Search to delegate the operation getLightweightMetaObjectsByQuery to the cids Pure REST Search API.", Arrays.asList(new SearchParameterInfo[]{new MySearchParameterInfo("idStrasse", Type.INTEGER), new MySearchParameterInfo("representationPattern", Type.STRING, true), new MySearchParameterInfo("representationFields", Type.STRING, true)}), (SearchParameterInfo)new MySearchParameterInfo("return", Type.ENTITY_REFERENCE, true));
    private Integer idStrasse;
    private String representationPattern;
    private String[] representationFields;

    public StrAdrGeplanteAdresseStrasseSearch() {
    }

    public StrAdrGeplanteAdresseStrasseSearch(String representationPattern, String[] representationFields) {
        this();
        this.setRepresentationPattern(representationPattern);
        this.setRepresentationFields(representationFields);
    }

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    public Collection performServerSearch() throws SearchException {
        Integer idStrasse = this.getIdStrasse();
        MetaService metaService = (MetaService)this.getActiveLocalServers().get("WUNDA_BLAU");
        if (metaService == null) {
            String message = "Lightweight Meta Objects By Query Search could not connect ot MetaService @domain 'WUNDA_BLAU'";
            LOG.error((Object)"Lightweight Meta Objects By Query Search could not connect ot MetaService @domain 'WUNDA_BLAU'");
            throw new SearchException("Lightweight Meta Objects By Query Search could not connect ot MetaService @domain 'WUNDA_BLAU'");
        }
        ArrayList<String> selectFields = new ArrayList<String>();
        String name = String.format("s.name", new Object[0]);
        selectFields.add("s.id AS strasse_id");
        selectFields.add("k.schluessel AS schluessel");
        selectFields.add("s.name || ' (' || k.schluessel || ')' AS anzeige");
        ArrayList<String> leftjoins = new ArrayList<String>();
        leftjoins.add("str_adr_strasse_schluessel AS k ON k.id = s.schluessel");
        ArrayList<String> conditions = new ArrayList<String>();
        conditions.add(String.format("k.name::int < 4000", new Object[0]));
        conditions.add(String.format("s.entnenndat IS NULL", new Object[0]));
        String query = "SELECT (SELECT c.id FROM cs_class c WHERE table_name ILIKE 'str_adr_strasse') AS class_id, s.id, s.name, " + String.join((CharSequence)", ", selectFields) + " FROM " + TABLE__STRASSE + " AS s" + (leftjoins.isEmpty() ? "" : " LEFT JOIN " + String.join((CharSequence)" , ", leftjoins)) + (conditions.isEmpty() ? "" : " WHERE " + String.join((CharSequence)" AND ", conditions)) + " ORDER BY s.name ";
        try {
            MetaClass mc = CidsBean.getMetaClassFromTableName((String)"WUNDA_BLAU", (String)TABLE__STRASSE, (ConnectionContext)this.getConnectionContext());
            if (this.getRepresentationPattern() != null) {
                return Arrays.asList(metaService.getLightweightMetaObjectsByQuery(mc.getID(), this.getUser(), query, this.getRepresentationFields(), this.getRepresentationPattern(), this.getConnectionContext()));
            }
            return Arrays.asList(metaService.getLightweightMetaObjectsByQuery(mc.getID(), this.getUser(), query, this.getRepresentationFields(), this.getConnectionContext()));
        }
        catch (Exception ex) {
            throw new SearchException("error while loading lwmos", (Throwable)ex);
        }
    }

    public SearchInfo getSearchInfo() {
        return this.searchInfo;
    }

    public Integer getIdStrasse() {
        return this.idStrasse;
    }

    public void setIdStrasse(Integer idStrasse) {
        this.idStrasse = idStrasse;
    }

    public String getRepresentationPattern() {
        return this.representationPattern;
    }

    public void setRepresentationPattern(String representationPattern) {
        this.representationPattern = representationPattern;
    }

    public String[] getRepresentationFields() {
        return this.representationFields;
    }

    public void setRepresentationFields(String[] representationFields) {
        this.representationFields = representationFields;
    }

    private class MySearchParameterInfo
    extends SearchParameterInfo {
        private MySearchParameterInfo(String key, Type type) {
            this(key, type, (Boolean)null);
        }

        private MySearchParameterInfo(String key, Type type, Boolean array) {
            super.setKey(key);
            super.setType(type);
            if (array != null) {
                super.setArray(array.booleanValue());
            }
        }
    }
}

