/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wunda_blau.search.server;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import de.cismet.cids.server.search.AbstractCidsServerSearch;
import de.cismet.cids.server.search.SearchException;
import de.cismet.cidsx.base.types.Type;
import de.cismet.cidsx.server.api.types.SearchInfo;
import de.cismet.cidsx.server.api.types.SearchParameterInfo;
import de.cismet.cidsx.server.search.RestApiCidsServerSearch;
import de.cismet.cidsx.server.search.builtin.legacy.LightweightMetaObjectsSearch;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.log4j.Logger;

public class UserMailSearch
extends AbstractCidsServerSearch
implements RestApiCidsServerSearch,
LightweightMetaObjectsSearch,
ConnectionContextStore {
    private static final Logger LOG = Logger.getLogger(UserMailSearch.class);
    private final String table = "cs_info";
    private String representationPattern = "%s";
    private String[] representationFields = new String[]{"key"};
    private ConnectionContext connectionContext = ConnectionContext.createDummy();
    private final SearchInfo searchInfo;
    private Collection<String> where = new ArrayList<String>();

    public UserMailSearch() {
        this.searchInfo = new SearchInfo(((Object)((Object)this)).getClass().getName(), ((Object)((Object)this)).getClass().getSimpleName(), "Builtin Legacy Search to delegate the operation getLightweightMetaObjectsByQuery to the cids Pure REST Search API.", Arrays.asList(new SearchParameterInfo[]{new MySearchParameterInfo("id", Type.INTEGER), new MySearchParameterInfo("representationPattern", Type.STRING, true), new MySearchParameterInfo("representationFields", Type.STRING, true)}), (SearchParameterInfo)new MySearchParameterInfo("return", Type.ENTITY_REFERENCE, true));
    }

    public UserMailSearch(String username) {
        this();
        ArrayList<String> conditions = new ArrayList<String>();
        conditions.add(String.format(" key like '%s'", username));
        this.setWhere(conditions);
    }

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    public Collection performServerSearch() throws SearchException {
        MetaService metaService = (MetaService)this.getActiveLocalServers().get("WUNDA_BLAU");
        if (metaService == null) {
            String message = "Lightweight Meta Objects By Query Search could not connect ot MetaService @domain 'WUNDA_BLAU'";
            LOG.error((Object)"Lightweight Meta Objects By Query Search could not connect ot MetaService @domain 'WUNDA_BLAU'");
            throw new SearchException("Lightweight Meta Objects By Query Search could not connect ot MetaService @domain 'WUNDA_BLAU'");
        }
        ArrayList<String> fields = new ArrayList<String>();
        if (this.representationFields != null) {
            fields.addAll(Arrays.asList(this.representationFields));
        }
        String query = "SELECT json->>'email' as mail " + (fields.isEmpty() ? "" : ", " + String.join((CharSequence)", ", fields)) + " FROM " + "cs_info" + (this.where.isEmpty() ? "" : " WHERE " + String.join((CharSequence)" AND ", this.where));
        try {
            ArrayList resultList = metaService.performCustomSearch(query, this.getConnectionContext());
            return resultList;
        }
        catch (RemoteException ex) {
            throw new SearchException("error while loading lwmos", (Throwable)ex);
        }
    }

    public String[] getRepresentationFields() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setRepresentationFields(String[] strings) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getRepresentationPattern() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setRepresentationPattern(String string) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public SearchInfo getSearchInfo() {
        return this.searchInfo;
    }

    public Collection<String> getWhere() {
        return this.where;
    }

    public void setWhere(Collection<String> where) {
        this.where = where;
    }

    private class MySearchParameterInfo
    extends SearchParameterInfo {
        private MySearchParameterInfo(String key, Type type) {
            this(key, type, (Boolean)null);
        }

        private MySearchParameterInfo(String key, Type type, Boolean array) {
            super.setKey(key);
            super.setType(type);
            if (array != null) {
                super.setArray(array.booleanValue());
            }
        }
    }
}

