/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wunda_blau.search.server;

import Sirius.server.middleware.interfaces.domainserver.MetaService;
import Sirius.server.middleware.types.MetaObjectNode;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.custom.wunda_blau.search.server.SearchProperties;
import de.cismet.cids.server.search.AbstractCidsServerSearch;
import de.cismet.cids.server.search.MetaObjectNodeServerSearch;
import de.cismet.cidsx.base.types.Type;
import de.cismet.cidsx.server.api.types.SearchInfo;
import de.cismet.cidsx.server.api.types.SearchParameterInfo;
import de.cismet.cidsx.server.search.RestApiCidsServerSearch;
import de.cismet.cismap.commons.jtsgeometryfactories.PostGisGeometryFactory;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import org.apache.log4j.Logger;

public class VzkatSchilderSearch
extends AbstractCidsServerSearch
implements RestApiCidsServerSearch,
MetaObjectNodeServerSearch,
ConnectionContextStore {
    private static final transient Logger LOG = Logger.getLogger(VzkatSchilderSearch.class);
    private static final String INTERSECTS_BUFFER = SearchProperties.getInstance().getIntersectsBuffer();
    private SearchMode searchMode;
    private SearchFor searchFor = SearchFor.SCHILD;
    private Integer standortId = null;
    private Integer zeichenId = null;
    private Date activeDate = null;
    private Geometry geom = null;
    private final SearchInfo searchInfo;
    private ConnectionContext connectionContext = ConnectionContext.createDummy();

    public VzkatSchilderSearch() {
        this.searchInfo = new SearchInfo(((Object)((Object)this)).getClass().getName(), ((Object)((Object)this)).getClass().getSimpleName(), "Builtin Legacy Search to delegate the operation VzkatSchilderSearch to the cids Pure REST Search API.", Arrays.asList(new SearchParameterInfo[]{new MySearchParameterInfo("standortId", Type.INTEGER)}), (SearchParameterInfo)new MySearchParameterInfo("return", Type.ENTITY_REFERENCE, true));
    }

    public SearchInfo getSearchInfo() {
        return this.searchInfo;
    }

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
    }

    public Collection<MetaObjectNode> performServerSearch() {
        try {
            ArrayList<MetaObjectNode> result = new ArrayList<MetaObjectNode>();
            ArrayList<String> wheres = new ArrayList<String>();
            ArrayList<String> leftJoins = new ArrayList<String>();
            leftJoins.add("vzkat_richtung ON vzkat_richtung.id = vzkat_schild.fk_richtung");
            leftJoins.add("vzkat_standort ON vzkat_standort.id = vzkat_schild.fk_standort");
            if (this.standortId != null) {
                wheres.add("vzkat_schild.fk_standort = " + this.standortId + "");
            }
            if (this.zeichenId != null) {
                wheres.add("vzkat_zeichen.id = " + this.zeichenId + "");
                leftJoins.add("vzkat_zeichen ON vzkat_zeichen.id = vzkat_schild.fk_zeichen");
            }
            if (this.geom != null) {
                String geomString = PostGisGeometryFactory.getPostGisCompliantDbString((Geometry)this.geom);
                wheres.add("(geom.geo_field && st_GeometryFromText('" + geomString + "') AND st_intersects(st_buffer(geo_field, " + INTERSECTS_BUFFER + "),st_GeometryFromText('" + geomString + "')))");
                leftJoins.add("geom ON vzkat_standort.fk_geom = geom.id");
            }
            if (this.activeDate == null) {
                this.activeDate = new Date();
            }
            wheres.add(String.format("  (vzkat_schild.gueltig_von IS NULL OR '%1$s'::date >= gueltig_von::date ) AND (vzkat_schild.gueltig_bis IS NULL OR '%1$s'::date <= gueltig_bis::date )", this.activeDate.toString()));
            String where = !wheres.isEmpty() ? String.format(" WHERE (%s)", String.join((CharSequence)") AND (", wheres)) : ")";
            String leftJoin = !leftJoins.isEmpty() ? String.format(" LEFT JOIN %s", String.join((CharSequence)" LEFT JOIN ", leftJoins)) : "";
            String fields = SearchFor.STANDORT.equals((Object)this.searchFor) ? "(SELECT id FROM cs_class WHERE table_name ILIKE 'vzkat_standort') AS class_id, vzkat_schild.fk_standort AS object_id, vzkat_standort.import_id::text AS object_name" : "(SELECT id FROM cs_class WHERE table_name ILIKE 'vzkat_schild') AS class_id, vzkat_schild.id AS object_id, 'Standort ' || vzkat_standort.import_id::text || ', ' || vzkat_richtung.schluessel || ' ' || vzkat_schild.reihenfolge AS object_name";
            String query = String.format("SELECT %s FROM vzkat_schild %s %s", fields, leftJoin, where);
            if (query != null) {
                MetaService ms = (MetaService)this.getActiveLocalServers().get("WUNDA_BLAU");
                ArrayList resultList = ms.performCustomSearch(query, this.getConnectionContext());
                for (ArrayList al : resultList) {
                    int cid = (Integer)al.get(0);
                    int oid = (Integer)al.get(1);
                    String name = (String)al.get(2);
                    MetaObjectNode mon = new MetaObjectNode("WUNDA_BLAU", oid, cid, name, null, null);
                    result.add(mon);
                }
            }
            return result;
        }
        catch (Exception ex) {
            LOG.error((Object)"error while searching for vzkat_schild", (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    public void setSearchMode(SearchMode searchMode) {
        this.searchMode = searchMode;
    }

    public void setSearchFor(SearchFor searchFor) {
        this.searchFor = searchFor;
    }

    public void setStandortId(Integer standortId) {
        this.standortId = standortId;
    }

    public void setZeichenId(Integer zeichenId) {
        this.zeichenId = zeichenId;
    }

    public void setActiveDate(Date activeDate) {
        this.activeDate = activeDate;
    }

    public void setGeom(Geometry geom) {
        this.geom = geom;
    }

    public void setConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
    }

    public SearchMode getSearchMode() {
        return this.searchMode;
    }

    public SearchFor getSearchFor() {
        return this.searchFor;
    }

    public Integer getStandortId() {
        return this.standortId;
    }

    public Integer getZeichenId() {
        return this.zeichenId;
    }

    public Date getActiveDate() {
        return this.activeDate;
    }

    public Geometry getGeom() {
        return this.geom;
    }

    private class MySearchParameterInfo
    extends SearchParameterInfo {
        private MySearchParameterInfo(String key, Type type) {
            this(key, type, (Boolean)null);
        }

        private MySearchParameterInfo(String key, Type type, Boolean array) {
            super.setKey(key);
            super.setType(type);
            if (array != null) {
                super.setArray(array.booleanValue());
            }
        }
    }

    public static enum SearchFor {
        SCHILD,
        STANDORT;

    }

    public static enum SearchMode {
        AND,
        OR;

    }
}

