/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wunda_blau.startuphooks;

import Sirius.server.middleware.impls.domainserver.DomainServerImpl;
import Sirius.server.middleware.interfaces.domainserver.MetaService;
import Sirius.server.middleware.types.MetaObject;
import Sirius.server.middleware.types.MetaObjectNode;
import de.cismet.cids.custom.utils.formsolutions.FormSolutionsBestellungHandler;
import de.cismet.cids.custom.utils.formsolutions.FormSolutionsProperties;
import de.cismet.cids.custom.wunda_blau.startuphooks.AbstractWundaBlauStartupHook;
import java.util.Arrays;
import org.apache.log4j.Logger;

public class FormSolutionBestellungStartupHook
extends AbstractWundaBlauStartupHook {
    private static final transient Logger LOG = Logger.getLogger(FormSolutionBestellungStartupHook.class);

    public void domainServerStarted() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    if (!FormSolutionsProperties.getInstance().isSkipUnfinnishedAtStartup()) {
                        DomainServerImpl metaService = FormSolutionBestellungStartupHook.this.waitForMetaService();
                        FormSolutionsBestellungHandler handler = new FormSolutionsBestellungHandler(true, (MetaService)metaService, FormSolutionBestellungStartupHook.this.getConnectionContext());
                        MetaObject[] mos = handler.getUnfinishedBestellungen();
                        if (mos != null) {
                            for (MetaObject mo : mos) {
                                try {
                                    FormSolutionBestellungStartupHook.this.redoBestellung(mo, handler);
                                }
                                catch (Exception ex) {
                                    LOG.error((Object)("error while retrying FS_bestellung " + mo), (Throwable)ex);
                                }
                            }
                        }
                        FormSolutionBestellungStartupHook.this.requestOpenBestellungen(handler);
                    }
                }
                catch (Exception ex) {
                    LOG.error((Object)"error while executing FormSolutionBestellungStartupHook", (Throwable)ex);
                }
            }
        }).start();
    }

    private void redoBestellung(MetaObject mo, FormSolutionsBestellungHandler handler) {
        MetaObjectNode mon = new MetaObjectNode(mo.getDomain(), mo.getId(), mo.getClassID());
        handler.execute(40, false, false, Arrays.asList(mon));
    }

    private void requestOpenBestellungen(FormSolutionsBestellungHandler handler) throws Exception {
        handler.fetchEndExecuteAllOpen();
    }

    @Override
    public String getDomain() {
        return "WUNDA_BLAU";
    }
}

