/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wunda_blau.trigger;

import Sirius.server.localserver.DBServer;
import Sirius.server.newuser.User;
import Sirius.server.sql.DBConnection;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.trigger.AbstractDBAwareCidsTrigger;
import de.cismet.cids.trigger.CidsTrigger;
import de.cismet.cids.trigger.CidsTriggerKey;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class PfSchluesseltabelleTrigger
extends AbstractDBAwareCidsTrigger {
    private static final transient Logger LOG = Logger.getLogger(PfSchluesseltabelleTrigger.class);
    private static final String DOMAIN = "WUNDA_BLAU";
    private static final String TABLE = "pf_schluesseltabelle";
    private static final String ORDER_BY_FIELD = "order_by";
    private static final String TABLE_NAME_FIELD = "table_name";
    private static final String UPDATE_ORDER_QUERY_TEMPLATE = "UPDATE %1$s AS outter SET %2$s = sub.row_number FROM (SELECT id, row_number() over(ORDER BY %2$s, id != %3$d) AS row_number FROM %1$s) AS sub WHERE sub.id = outter.id;";
    private static final String SELECT_TABLENAMES_QUERY_TEMPLATE = "SELECT %2$s FROM %1$s";
    private final Collection<String> triggeringTableNames = new HashSet<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDbServer(DBServer dbServer) {
        super.setDbServer(dbServer);
        Statement stmt = null;
        try {
            stmt = dbServer.getConnectionPool().getConnection().createStatement();
            String query = String.format(SELECT_TABLENAMES_QUERY_TEMPLATE, TABLE, TABLE_NAME_FIELD);
            ResultSet resultSet = stmt.executeQuery(query);
            while (resultSet.next()) {
                this.getTriggeringTableNames().add(resultSet.getObject(TABLE_NAME_FIELD).toString());
            }
        }
        catch (Throwable ex) {
            try {
                LOG.error((Object)ex, ex);
            }
            catch (Throwable throwable) {
                DBConnection.closeStatements((Statement[])new Statement[]{stmt});
                throw throwable;
            }
            DBConnection.closeStatements((Statement[])new Statement[]{stmt});
        }
        DBConnection.closeStatements((Statement[])new Statement[]{stmt});
    }

    public final Collection<String> getTriggeringTableNames() {
        return this.triggeringTableNames;
    }

    private String identifyRelevantTableName(CidsBean cidsBean) {
        if (cidsBean != null && cidsBean.getMetaObject() != null && cidsBean.getMetaObject().getMetaClass() != null && this.getTriggeringTableNames().contains(cidsBean.getMetaObject().getMetaClass().getTableName())) {
            return cidsBean.getMetaObject().getMetaClass().getTableName();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeQuery(CidsBean cidsBean) {
        String tableName = this.identifyRelevantTableName(cidsBean);
        if (tableName != null) {
            String query = String.format(UPDATE_ORDER_QUERY_TEMPLATE, tableName, ORDER_BY_FIELD, cidsBean.getMetaObject().getId());
            Statement stmt = null;
            try {
                stmt = this.getDbServer().getConnectionPool().getConnection().createStatement();
                stmt.executeUpdate(query);
            }
            catch (Exception ex) {
                try {
                    LOG.error((Object)ex, (Throwable)ex);
                }
                catch (Throwable throwable) {
                    DBConnection.closeStatements((Statement[])new Statement[]{stmt});
                    throw throwable;
                }
                DBConnection.closeStatements((Statement[])new Statement[]{stmt});
            }
            DBConnection.closeStatements((Statement[])new Statement[]{stmt});
        }
    }

    public void afterInsert(CidsBean cidsBean, User user) {
    }

    public void afterDelete(CidsBean cidsBean, User user) {
    }

    public void afterUpdate(CidsBean cidsBean, User user) {
    }

    public void beforeInsert(CidsBean cidsBean, User user) {
    }

    public void beforeUpdate(CidsBean cidsBean, User user) {
    }

    public void beforeDelete(CidsBean cidsBean, User user) {
    }

    public void afterCommittedInsert(CidsBean cidsBean, User user) {
        this.storeQuery(cidsBean);
    }

    public void afterCommittedUpdate(CidsBean cidsBean, User user) {
        this.storeQuery(cidsBean);
    }

    public void afterCommittedDelete(CidsBean cidsBean, User user) {
        this.storeQuery(cidsBean);
    }

    public CidsTriggerKey getTriggerKey() {
        return new CidsTriggerKey(DOMAIN, "ALLOFTHEM");
    }

    public int compareTo(CidsTrigger cidsTrigger) {
        return 0;
    }
}

