/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
package Sirius.navigator.search;

import Sirius.navigator.types.treenode.ObjectTreeNode;
import Sirius.navigator.ui.ComponentRegistry;

import Sirius.server.middleware.types.MetaObjectNode;

import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

import java.awt.Dimension;

import java.util.ArrayList;
import java.util.List;

import javax.swing.JLabel;

import de.cismet.commons.gui.protocol.AbstractProtocolStepPanel;

import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextProvider;

/**
 * DOCUMENT ME!
 *
 * @author   jruiz
 * @version  $Revision$, $Date$
 */
public class CidsServerSearchProtocolStepPanel extends AbstractProtocolStepPanel<CidsServerSearchProtocolStep>
        implements ConnectionContextProvider {

    //~ Instance fields --------------------------------------------------------

// private static final Map<String, ImageIcon> ICON_MAP = new HashMap<String, ImageIcon>();

    private final ConnectionContext connectionContext;
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JScrollPane jScrollPane2;
    private org.jdesktop.swingx.JXHyperlink jXHyperlink1;
    private org.jdesktop.swingx.JXHyperlink jXHyperlink2;
    private org.jdesktop.swingx.JXHyperlink jXHyperlink3;
    private Sirius.navigator.search.CidsServerSearchProtocolStepResultsTree protocolResultsTree1;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * konstruktor ohne parameter wird für gui designer gebraucht, wenn dieses panel in ein anderes benutzt werden soll.
     */
    public CidsServerSearchProtocolStepPanel() {
        this(new CidsServerSearchProtocolStepImpl(null, new ArrayList<MetaObjectNode>()),
            ConnectionContext.createDeprecated());
    }

    /**
     * Creates new form CidsSearchProtocolStepPanel.
     *
     * @param  cidsSearchProtocolStep  DOCUMENT ME!
     * @param  connectionContext       DOCUMENT ME!
     */
    public CidsServerSearchProtocolStepPanel(final CidsServerSearchProtocolStep cidsSearchProtocolStep,
            final ConnectionContext connectionContext) {
        super(cidsSearchProtocolStep);
        this.connectionContext = connectionContext;

        initComponents();

        jXHyperlink2.setVisible(cidsSearchProtocolStep.isReExecuteSearchEnabled());
        protocolResultsTree1.setResultNodes(cidsSearchProtocolStep.getSearchResultNodes().toArray(
                new MetaObjectNode[0]));

        if (!protocolResultsTree1.getResultNodes().isEmpty()) {
            final int maxSize = 10;

            final JLabel dummy = (JLabel)protocolResultsTree1.getCellRenderer()
                        .getTreeCellRendererComponent(
                                protocolResultsTree1,
                                new ObjectTreeNode(
                                    (MetaObjectNode)protocolResultsTree1.getResultNodes().get(0),
                                    getConnectionContext()),
                                false,
                                false,
                                false,
                                0,
                                false);
            final int height;

            if (protocolResultsTree1.getResultNodes().size() > maxSize) {
                height = 4 + (dummy.getPreferredSize().height * maxSize);
            } else {
                height = 4 + (dummy.getPreferredSize().height * protocolResultsTree1.getResultNodes().size());
            }

            jScrollPane2.setPreferredSize(new Dimension((int)jScrollPane2.getPreferredSize().getWidth(), height));
        }

        setSearchResultsPanelVisible(false);
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    private List<MetaObjectNode> getSearchResultNodesList() {
        if (getProtocolStep() != null) {
            final List<MetaObjectNode> searchObjectNodes = ((CidsServerSearchProtocolStep)getProtocolStep())
                        .getSearchResultNodes();
            if (searchObjectNodes != null) {
                return searchObjectNodes;
            }
        }
        return new ArrayList<MetaObjectNode>();
    }

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jXHyperlink1 = new org.jdesktop.swingx.JXHyperlink();
        jPanel1 = new javax.swing.JPanel();
        jPanel2 = new javax.swing.JPanel();
        jScrollPane2 = new javax.swing.JScrollPane();
        try {
            protocolResultsTree1 = new Sirius.navigator.search.CidsServerSearchProtocolStepResultsTree(
                    getConnectionContext());
            jXHyperlink3 = new org.jdesktop.swingx.JXHyperlink();
            jXHyperlink2 = new org.jdesktop.swingx.JXHyperlink();

            setLayout(new java.awt.GridBagLayout());

            org.openide.awt.Mnemonics.setLocalizedText(
                jXHyperlink1,
                org.openide.util.NbBundle.getMessage(
                    CidsServerSearchProtocolStepPanel.class,
                    "CidsServerSearchProtocolStepPanel.jXHyperlink1.text_hide_multi")); // NOI18N
            jXHyperlink1.addActionListener(new java.awt.event.ActionListener() {

                    @Override
                    public void actionPerformed(final java.awt.event.ActionEvent evt) {
                        jXHyperlink1ActionPerformed(evt);
                    }
                });
            gridBagConstraints = new java.awt.GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
            gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
            add(jXHyperlink1, gridBagConstraints);

            jPanel1.setLayout(new java.awt.GridBagLayout());
            gridBagConstraints = new java.awt.GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
            gridBagConstraints.weightx = 1.0;
            add(jPanel1, gridBagConstraints);

            jPanel2.setLayout(new java.awt.GridBagLayout());
        } catch (java.lang.Exception e1) {
            e1.printStackTrace();
        }
        jScrollPane2.setViewportView(protocolResultsTree1);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel2.add(jScrollPane2, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(
            jXHyperlink3,
            org.openide.util.NbBundle.getMessage(
                CidsServerSearchProtocolStepPanel.class,
                "CidsServerSearchProtocolStepPanel.jXHyperlink3.text")); // NOI18N
        jXHyperlink3.setHorizontalAlignment(javax.swing.SwingConstants.TRAILING);
        jXHyperlink3.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    jXHyperlink3ActionPerformed(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 0, 0);
        jPanel2.add(jXHyperlink3, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 0, 0);
        add(jPanel2, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(
            jXHyperlink2,
            org.openide.util.NbBundle.getMessage(
                CidsServerSearchProtocolStepPanel.class,
                "CidsServerSearchProtocolStepPanel.jXHyperlink2.text")); // NOI18N
        jXHyperlink2.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    jXHyperlink2ActionPerformed(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_END;
        add(jXHyperlink2, gridBagConstraints);
    } // </editor-fold>//GEN-END:initComponents

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void jXHyperlink1ActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_jXHyperlink1ActionPerformed
        toggleSearchResultsPanelVisibility();
    }                                                                                //GEN-LAST:event_jXHyperlink1ActionPerformed

    /**
     * DOCUMENT ME!
     */
    private void toggleSearchResultsPanelVisibility() {
        setSearchResultsPanelVisible(!jPanel2.isVisible());
    }

    /**
     * DOCUMENT ME!
     *
     * @param  visible  DOCUMENT ME!
     */
    private void setSearchResultsPanelVisible(final boolean visible) {
        jPanel2.setVisible(visible);

        final int size;
        if (getProtocolStep() != null) {
            if ((getProtocolStep().getSearchResultNodes() == null)
                        || getProtocolStep().getSearchResultNodes().isEmpty()) {
                size = 0;
            } else {
                size = getProtocolStep().getSearchResultNodes().size();
            }

            jXHyperlink1.setEnabled(size > 0);

            if (size == 0) {
                Mnemonics.setLocalizedText(
                    jXHyperlink1,
                    NbBundle.getMessage(
                        CidsServerSearchProtocolStepPanel.class,
                        "CidsServerSearchProtocolStepPanel.jXHyperlink1.text_empty"));
            } else {
                if (visible) {
                    if (size > 1) {
                        Mnemonics.setLocalizedText(
                            jXHyperlink1,
                            NbBundle.getMessage(
                                CidsServerSearchProtocolStepPanel.class,
                                "CidsServerSearchProtocolStepPanel.jXHyperlink1.text_hide_multi",
                                String.valueOf(size)));
                    } else {
                        Mnemonics.setLocalizedText(
                            jXHyperlink1,
                            NbBundle.getMessage(
                                CidsServerSearchProtocolStepPanel.class,
                                "CidsServerSearchProtocolStepPanel.jXHyperlink1.text_hide_single",
                                String.valueOf(size)));
                    }
                } else {
                    if (size > 1) {
                        Mnemonics.setLocalizedText(
                            jXHyperlink1,
                            NbBundle.getMessage(
                                CidsServerSearchProtocolStepPanel.class,
                                "CidsServerSearchProtocolStepPanel.jXHyperlink1.text_show_multi",
                                String.valueOf(size)));
                    } else {
                        Mnemonics.setLocalizedText(
                            jXHyperlink1,
                            NbBundle.getMessage(
                                CidsServerSearchProtocolStepPanel.class,
                                "CidsServerSearchProtocolStepPanel.jXHyperlink1.text_show_single",
                                String.valueOf(size)));
                    }
                }
            }
        }

        revalidate();
    }

    /**
     * DOCUMENT ME!
     */
    private void loadSearchResultsIntoTree() {
        final List<MetaObjectNode> mons = getSearchResultNodesList();
        ComponentRegistry.getRegistry().getSearchResultsTree().setResultNodes(mons.toArray(new MetaObjectNode[0]));
    }

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void jXHyperlink2ActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_jXHyperlink2ActionPerformed
        ((CidsServerSearchProtocolStep)getProtocolStep()).reExecuteSearch();
    }                                                                                //GEN-LAST:event_jXHyperlink2ActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void jXHyperlink3ActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_jXHyperlink3ActionPerformed
        loadSearchResultsIntoTree();
    }                                                                                //GEN-LAST:event_jXHyperlink3ActionPerformed

    @Override
    public ConnectionContext getConnectionContext() {
        return connectionContext;
    }
}
