/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
/*
 * DescriptionPaneTest.java
 *
 * Created on 20.05.2011, 14:18:33
 */
package Sirius.navigator.ui;

import org.apache.log4j.BasicConfigurator;

import java.awt.BorderLayout;
import java.awt.event.KeyEvent;

import java.io.File;

import javax.swing.JFileChooser;

/**
 * DOCUMENT ME!
 *
 * @author   jweintraut
 * @version  $Revision$, $Date$
 */
public class DescriptionPaneTest extends javax.swing.JFrame {

    //~ Instance fields --------------------------------------------------------

    private DescriptionPane pnlDescription;
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton btnGo;
    private javax.swing.JButton btnOpenFile;
    private javax.swing.JPanel pnlControls;
    private javax.swing.JTextField txtUrl;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates new form DescriptionPaneTest.
     */
    public DescriptionPaneTest() {
        initComponents();

        pnlDescription = new DescriptionPaneFS();
        add(pnlDescription, BorderLayout.CENTER);
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * DOCUMENT ME!
     */
    private void displayUrl() {
        final String url = txtUrl.getText();
        if ((url == null) || (url.trim().length() <= 0)) {
            return;
        }

        pnlDescription.setPageFromURI(url);
        pnlDescription.showHTML();
    }

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        pnlControls = new javax.swing.JPanel();
        btnOpenFile = new javax.swing.JButton();
        txtUrl = new javax.swing.JTextField();
        btnGo = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setMinimumSize(new java.awt.Dimension(640, 480));

        pnlControls.setLayout(new javax.swing.BoxLayout(pnlControls, javax.swing.BoxLayout.LINE_AXIS));

        btnOpenFile.setText(org.openide.util.NbBundle.getMessage(
                DescriptionPaneTest.class,
                "DescriptionPaneTest.btnOpenFile.text")); // NOI18N
        btnOpenFile.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    btnOpenFileActionPerformed(evt);
                }
            });
        pnlControls.add(btnOpenFile);

        txtUrl.setText(org.openide.util.NbBundle.getMessage(
                DescriptionPaneTest.class,
                "DescriptionPaneTest.txtUrl.text")); // NOI18N
        txtUrl.addKeyListener(new java.awt.event.KeyAdapter() {

                @Override
                public void keyReleased(final java.awt.event.KeyEvent evt) {
                    txtUrlKeyReleased(evt);
                }
            });
        pnlControls.add(txtUrl);

        btnGo.setText(org.openide.util.NbBundle.getMessage(
                DescriptionPaneTest.class,
                "DescriptionPaneTest.btnGo.text")); // NOI18N
        btnGo.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    btnGoActionPerformed(evt);
                }
            });
        pnlControls.add(btnGo);

        getContentPane().add(pnlControls, java.awt.BorderLayout.PAGE_START);

        pack();
    } // </editor-fold>//GEN-END:initComponents

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void txtUrlKeyReleased(final java.awt.event.KeyEvent evt) { //GEN-FIRST:event_txtUrlKeyReleased
        if ((evt != null) && (evt.getKeyCode() == KeyEvent.VK_ENTER)) {
            displayUrl();
        }
    }                                                                   //GEN-LAST:event_txtUrlKeyReleased

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void btnGoActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_btnGoActionPerformed
        displayUrl();
    }                                                                         //GEN-LAST:event_btnGoActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void btnOpenFileActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_btnOpenFileActionPerformed
        final JFileChooser fileChooser = new JFileChooser();
        final int fileChosen = fileChooser.showOpenDialog(this);

        if (fileChosen == JFileChooser.APPROVE_OPTION) {
            final File fileToOpen = fileChooser.getSelectedFile();
            txtUrl.setText("file:///" + fileToOpen.getAbsolutePath());
            displayUrl();
        }
    } //GEN-LAST:event_btnOpenFileActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  args  the command line arguments
     */
    public static void main(final String[] args) {
        BasicConfigurator.configure();

        java.awt.EventQueue.invokeLater(new Runnable() {

                @Override
                public void run() {
                    new DescriptionPaneTest().setVisible(true);
                }
            });
    }
}
