/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
/*
 * DefalutComplexEditor.java
 *
 * Created on 22. August 2004, 18:54
 */
package Sirius.navigator.ui.attributes.editor;

import org.apache.log4j.Logger;

import java.awt.Component;
import java.awt.GridBagConstraints;

import java.util.Iterator;
import java.util.Map;

import javax.swing.JLabel;

/**
 * Standardimplementierung eines komplexen Editors.
 *
 * @author   Pascal
 * @version  $Revision$, $Date$
 */
public class DefaultComplexEditor extends AbstractComplexEditor {

    // Variables declaration - do not modify//GEN-BEGIN:variables
    protected javax.swing.JButton cancelButton;
    protected javax.swing.JPanel editorPanel;
    protected javax.swing.JButton stopButton;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates new form DefalutComplexEditor.
     */
    public DefaultComplexEditor() {
        this.logger = Logger.getLogger(this.getClass());

        this.editorActivationDelegate = new ComplexEditorActivationDelegate();
        this.editorUIDelegate = new ComplexEditorUIDelegate();
        this.editorHandler = new ComplexEditorHandler();
        this.editorLocator = new DefaultEditorLocator();
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        editorPanel = new javax.swing.JPanel();
        final javax.swing.JPanel controlPanel = new javax.swing.JPanel();
        stopButton = new javax.swing.JButton();
        cancelButton = new javax.swing.JButton();

        setBorder(javax.swing.BorderFactory.createEmptyBorder(1, 1, 1, 1));
        setLayout(new java.awt.BorderLayout(1, 1));

        editorPanel.setBorder(javax.swing.BorderFactory.createEmptyBorder(10, 10, 10, 10));
        editorPanel.setLayout(new java.awt.GridBagLayout());
        add(editorPanel, java.awt.BorderLayout.CENTER);

        controlPanel.setLayout(new java.awt.GridLayout(1, 2, 0, 1));

        stopButton.setText(org.openide.util.NbBundle.getMessage(
                DefaultComplexEditor.class,
                "DefaultComplexEditor.stopButton.text")); // NOI18N
        stopButton.setActionCommand("stopEditing");       // NOI18N
        stopButton.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    stopEditing(evt);
                }
            });
        controlPanel.add(stopButton);

        cancelButton.setText(org.openide.util.NbBundle.getMessage(
                DefaultComplexEditor.class,
                "DefaultComplexEditor.cancelButton.text")); // NOI18N
        cancelButton.setActionCommand("cancelEditing");     // NOI18N
        cancelButton.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    cancelEditing(evt);
                }
            });
        controlPanel.add(cancelButton);

        add(controlPanel, java.awt.BorderLayout.SOUTH);
    } // </editor-fold>//GEN-END:initComponents

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void stopEditing(final java.awt.event.ActionEvent evt) //GEN-FIRST:event_stopEditing
    {                                                              //GEN-HEADEREND:event_stopEditing
        this.stopEditing();
    }                                                              //GEN-LAST:event_stopEditing

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void cancelEditing(final java.awt.event.ActionEvent evt) //GEN-FIRST:event_cancelEditing
    {                                                                //GEN-HEADEREND:event_cancelEditing
        this.cancelEditing();
    }                                                                //GEN-LAST:event_cancelEditing

    // UI Methoden -------------------------------------------------------------

    @Override
    protected void initUI() {
        if (!this.init) {
            this.initComponents();
            this.init = true;
        } else if (logger.isDebugEnabled()) {
            logger.debug("initUI(" + this + "): ui already initialized"); // NOI18N
        }

        // das f\u00FCllt die editor map ....
        super.initUI();

        // alles neu:
        this.editorPanel.removeAll();

        final GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = -1;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        gridBagConstraints.weighty = 0.0;

        if (this.getValue() != null) {
            if (java.util.List.class.isAssignableFrom(this.getValue().getClass())) {
                if (logger.isDebugEnabled()) {
                    logger.debug("initUI(" + this + "): generating default ui for java.util.List"); // NOI18N
                }

                int i = 0;
                final Iterator iterator = ((java.util.List)this.getValue()).iterator();
                while (iterator.hasNext()) {
                    this.addEditorUI(new Integer(i), iterator.next(), gridBagConstraints);
                    i++;
                }
            } else if (java.util.Map.class.isAssignableFrom(this.getValue().getClass())) {
                if (logger.isDebugEnabled()) {
                    logger.debug("initUI(" + this + "): generating default ui for java.util.Map"); // NOI18N
                }

                final Iterator iterator = ((Map)this.getValue()).keySet().iterator();
                while (iterator.hasNext()) {
                    final Object key = iterator.next();
                    this.addEditorUI(key, ((Map)this.getValue()).get(key), gridBagConstraints);
                }
            } else {
                logger.error("getEditor(): " + this.getValue().getClass().getName()
                            + " is not supported by this editor locator"); // NOI18N
            }
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @param  id                  DOCUMENT ME!
     * @param  value               DOCUMENT ME!
     * @param  gridBagConstraints  DOCUMENT ME!
     */
    protected void addEditorUI(final Object id, final Object value, final GridBagConstraints gridBagConstraints) {
        Component editorComponent = null;

        if (this.getChildEditors().containsKey(id)) {
            final Object editor = this.getChildEditors().get(id);
            if (ComplexEditor.class.isAssignableFrom(editor.getClass())) {
                if (logger.isDebugEnabled()) {
                    logger.debug("addEditorUI(" + this + "): creating complex editor with complex parent editor"); // NOI18N
                }
                final DefaultSimpleEditor simpleEditor = new DefaultSimpleEditor();

                simpleEditor.setProperty(SimpleEditor.PROPERTY_COMLPEX_EDTIOR, editor.getClass());
                simpleEditor.setProperty(SimpleEditor.PROPERTY_READ_ONLY, new Boolean(true));

                if (this.getChildEditors().put(id, simpleEditor) != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("addEditorUI(" + this + "): creating simple editor with complex child editor"); // NOI18N
                    }
                    editorComponent = simpleEditor.getEditorComponent(this, (ComplexEditor)editor, id, value);
                    ((SimpleEditor)simpleEditor).addEditorListener(this.editorHandler);
                } else {
                    logger.error("addEditorUI(" + this + "): synchronization error: editor '" + id
                                + "'not in editor map!");                                                            // NOI18N
                    editorComponent = new JLabel(org.openide.util.NbBundle.getMessage(
                                DefaultComplexEditor.class,
                                "DefaultComplexEditor.addEditorUI.editorComponent.internalErrorText",
                                new Object[] { this }));                                                             // NOI18N
                }
            } else if (SimpleEditor.class.isAssignableFrom(editor.getClass())) {
                if (logger.isDebugEnabled()) {
                    logger.debug("addEditorUI(" + this + "): creating simple editor");                               // NOI18N
                }
                final Object complexEditorClass = ((SimpleEditor)editor).getProperty(
                        SimpleEditor.PROPERTY_COMLPEX_EDTIOR);

                if (complexEditorClass != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("addEditorUI(" + this + "): creating complex editor with simple parent editor"); // NOI18N
                    }

                    try {
                        final ComplexEditor complexEditor = (ComplexEditor)((Class)complexEditorClass).newInstance();

                        editorComponent = ((SimpleEditor)editor).getEditorComponent(this, complexEditor, id, value);
                    } catch (Throwable t) {
                        logger.error("addEditorUI(" + this + "): could not register complex editor for simple editor",
                            t); // NOI18N
                        editorComponent = ((SimpleEditor)editor).getEditorComponent(this, id, value);
                    }
                } else {
                    if (logger.isDebugEnabled()) {
                        logger.debug("addEditorUI(" + this + "): creating simple editor without complex child editor"); // NOI18N
                    }
                    editorComponent = ((SimpleEditor)editor).getEditorComponent(this, id, value);
                }

                ((SimpleEditor)editor).addEditorListener(this.editorHandler);
            } else {
                logger.error("addEditorUI(" + this + "): unknown editor type'" + editor.getClass() + "'"); // NOI18N
                editorComponent = new JLabel(org.openide.util.NbBundle.getMessage(
                            DefaultComplexEditor.class,
                            "DefaultComplexEditor.addEditorUI.editorComponent.wrongEditorTypeText",
                            new Object[] { this }));                                                       // NOI18N
            }
        } else {
            logger.error("addEditorUI(" + this + "): no editor found for object '" + id + "'");            // NOI18N
            editorComponent = new JLabel(org.openide.util.NbBundle.getMessage(
                        DefaultComplexEditor.class,
                        "DefaultComplexEditor.addEditorUI.editorComponent.EditorNotFoundText",
                        new Object[] { this }));                                                           // NOI18N
        }

        gridBagConstraints.gridy++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.NONE;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.weightx = 0.5;
        this.editorPanel.add(new JLabel(id.toString()), gridBagConstraints);

        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 0.5;
        this.editorPanel.add(editorComponent, gridBagConstraints);
    }

    // AbstractComplexEditor Methoden -------------------------------------------

    @Override
    public java.lang.Object getValue(final java.lang.Object key) {
        if (logger.isDebugEnabled()) {
            logger.debug("setting new value for '" + key + "'");                                                        // NOI18N
        }
        if (this.getValue() != null) {
            if (java.util.List.class.isAssignableFrom(this.getValue().getClass())) {
                if (Integer.class.isAssignableFrom(key.getClass())) {
                    final int i = ((Integer)key).intValue();
                    if (i < ((java.util.List)this.getValue()).size()) {
                        return ((java.util.List)this.getValue()).get(i);
                    } else {
                        logger.warn("getValue(" + this + "): key index out of bounds '" + i + " ("
                                    + ((java.util.List)this.getValue()).size() + ")");                                  // NOI18N
                    }
                } else {
                    logger.warn("getValue(" + this + "): wrong key type '" + key.getClass() + "', 'Integer' expected"); // NOI18N
                }
            } else if (java.util.Map.class.isAssignableFrom(this.getValue().getClass())) {
                if (((Map)this.getValue()).containsKey(key)) {
                    return ((Map)this.getValue()).get(key);
                } else {
                    logger.warn("getValue(" + this + "): key not found '" + key + "'");                                 // NOI18N
                }
            } else {
                logger.error("getValue(" + this + "): unexpected call to getValue(): wrong type");                      // NOI18N
            }
        } else {
            logger.error("getValue(" + this + "): unexpected call to getValue(): this.value is null");                  // NOI18N
        }

        return null;
    }

    @Override
    public void setValue(final java.lang.Object key, final java.lang.Object value) {
        if (logger.isDebugEnabled()) {
            logger.debug("setValue(" + this + "): setting new value '" + key + "': " + value); // NOI18N
        }

        if (this.getValue() != null) {
            if (java.util.List.class.isAssignableFrom(this.getValue().getClass())) {
                if (Integer.class.isAssignableFrom(key.getClass())) {
                    final int i = ((Integer)key).intValue();
                    if (logger.isDebugEnabled()) {
                        logger.debug("setValue(" + this + "): setting list value: " + i); // NOI18N
                    }

                    if (i < ((java.util.List)this.getValue()).size()) {
                        ((java.util.List)this.getValue()).set(i, value);
                    } else if (logger.isDebugEnabled()) {
                        logger.warn("setValue(" + this + "): key index out of bounds '" + i + " ("
                                    + ((java.util.List)this.getValue()).size() + ")"); // NOI18N
                    }
                } else if (logger.isDebugEnabled()) {
                    logger.warn("setValue(" + this + "): wrong key type '" + key.getClass() + "', 'Integer' expected"); // NOI18N
                }
            } else if (java.util.Map.class.isAssignableFrom(this.getValue().getClass())) {
                if (((Map)this.getValue()).containsKey(key)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("setValue(" + this + "): setting map value: " + key); // NOI18N
                    }
                    ((Map)this.getValue()).put(key, value);
                } else {
                    logger.warn("setValue(" + this + "): key not found '" + key + "'"); // NOI18N
                }
            } else {
                logger.error("setValue(" + this + "): unexpected call to getValue(): wrong type"); // NOI18N
            }
        } else {
            logger.error("setValue(" + this + "): unexpected call to setValue(): this.value is null"); // NOI18N
        }
    }

    /**
     * XXX method not supported.
     *
     * @param  key    DOCUMENT ME!
     * @param  value  DOCUMENT ME!
     */
    @Override
    public void addValue(final java.lang.Object key, final java.lang.Object value) {
        logger.error("addValue() method not supported"); // NOI18N
    }

    /**
     * XXX method not supported.
     *
     * @param   key  DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    @Override
    public java.lang.Object removeValue(final java.lang.Object key) {
        logger.error("removeValue() method not supported"); // NOI18N
        return null;
    }

    @Override
    public boolean isEditable(final java.util.EventObject anEvent) {
        return !((Boolean)this.getProperty(PROPERTY_READ_ONLY)).booleanValue();
    }
}
