/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
/*
 * DefaultSimpleEditor.java
 *
 * Created on 19. August 2004, 15:28
 */
package Sirius.navigator.ui.attributes.editor;

import org.apache.log4j.Logger;

import java.awt.*;
import java.awt.event.*;

import javax.swing.*;
import javax.swing.event.*;

/**
 * Standardimplementierung eines einfachen Editors (JTextField).
 *
 * @author   Pascal
 * @version  $Revision$, $Date$
 */
public class DefaultSimpleEditor extends AbstractSimpleEditor // javax.swing.JPanel
{

    // Variables declaration - do not modify//GEN-BEGIN:variables
    protected javax.swing.JButton complexEditorButton;
    protected javax.swing.JTextField simpleValueField;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates new form DefaultSimpleEditor.
     */
    public DefaultSimpleEditor() {
        this.logger = Logger.getLogger(this.getClass());

        this.editorActivationDelegate = new SimpleEditorActivationDelegate();
        this.editorUIDelegate = new SimpleEditorUIDelegate();
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        simpleValueField = new javax.swing.JTextField();
        complexEditorButton = new javax.swing.JButton();

        setLayout(new java.awt.GridBagLayout());

        simpleValueField.setColumns(12);
        simpleValueField.setDragEnabled(true);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        add(simpleValueField, gridBagConstraints);

        complexEditorButton.setText(org.openide.util.NbBundle.getMessage(
                DefaultSimpleEditor.class,
                "DefaultSimpleEditor.complexEditorButton.text")); // NOI18N
        complexEditorButton.setActionCommand(AbstractSimpleEditor.SimpleEditorActivationDelegate.SHOW_UI_COMMAND);
        complexEditorButton.setEnabled(false);
        complexEditorButton.setMargin(new java.awt.Insets(1, 1, 1, 1));
        complexEditorButton.setMaximumSize(new java.awt.Dimension(0, 0));
        complexEditorButton.setMinimumSize(new java.awt.Dimension(15, 20));
        complexEditorButton.setPreferredSize(new java.awt.Dimension(15, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        add(complexEditorButton, gridBagConstraints);
    }                                                             // </editor-fold>//GEN-END:initComponents

    /**
     * Der [...]-Button interessiert uns nur, wenn ein komplexer child editor verf\u00FCgbar ist ...
     *
     * @param   parentContainer     DOCUMENT ME!
     * @param   complexChildEditor  DOCUMENT ME!
     * @param   id                  DOCUMENT ME!
     * @param   value               DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    @Override
    public Component getEditorComponent(final BasicContainer parentContainer,
            final ComplexEditor complexChildEditor,
            final Object id,
            final Object value) {
        final Component editorComponent = super.getEditorComponent(parentContainer, complexChildEditor, id, value);

        if (this.complexEditorButton != null) {
            this.complexEditorButton.setEnabled(complexChildEditor != null);
        }

        return editorComponent;
    }

    @Override
    protected void initUI() {
        if (!this.init) {
            this.initComponents();

            // Beim Dr\u00FCcken auf den [...]-Button sollte sich der komplexe Editor \u00F6ffnen
            // (oder auch nicht ...);
            this.complexEditorButton.addActionListener(this.editorActivationDelegate);

            final ValueChangeListener valueChangeListener = new ValueChangeListener();
            this.simpleValueField.addFocusListener(valueChangeListener);
            this.simpleValueField.addActionListener(valueChangeListener);
            // this.simpleValueField.getDocument().addDocumentListener(valueChangeListener);

            this.complexEditorButton.setPreferredSize(new Dimension(
                    this.simpleValueField.getPreferredSize().height,
                    this.complexEditorButton.getPreferredSize().width));

            this.init = true;
        } else if (logger.isDebugEnabled()) {
            logger.debug("initUI(" + this.getId() + "): ui already initialized"); // NOI18N
        }

        this.simpleValueField.setEditable(!this.readOnly);
        this.simpleValueField.setEnabled(!this.readOnly);
        this.setValueChanged(false);
    }

    /**
     * Editierbar, wenn das Feld oder Button enabled sind.
     *
     * @param   anEvent  DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    @Override
    public boolean isEditable(final java.util.EventObject anEvent) {
        return this.simpleValueField.isEnabled()
                    | ((this.complexEditorButton != null) && this.complexEditorButton.isEnabled()); // NOI18N
    }

    @Override
    protected Object getComponentValue() {
        /*if(this.getValue() != null)
         * { this.valueChanged |= this.getValue().equals(this.simpleValueField.getText()); } else { this.valueChanged =
         * true;}*/

        return this.simpleValueField.getText();
    }

    @Override
    protected void setComponentValue(final Object value) {
        if (value != null) {
            this.simpleValueField.setText(value.toString());
        } else {
            this.simpleValueField.setText(null);
        }
    }

    //~ Inner Classes ----------------------------------------------------------

    /**
     * Speichert den Wert des Editors, wenn das Textfeld den Focus verliert oder ENTER gedr\u00FCckt wird.
     *
     * @version  $Revision$, $Date$
     */
    protected class ValueChangeListener implements FocusListener, ActionListener {

        //~ Instance fields ----------------------------------------------------

        private String oldValue = null;

        //~ Methods ------------------------------------------------------------

        @Override
        public void focusGained(final FocusEvent e) {
            if (!e.isTemporary()) {
                this.oldValue = DefaultSimpleEditor.this.simpleValueField.getText();
            }
        }

        @Override
        public void focusLost(final FocusEvent e) {
            if (!e.isTemporary()) {
                this.actionPerformed();
            }
        }

        @Override
        public void actionPerformed(final ActionEvent e) {
            this.actionPerformed();
        }

        /**
         * DOCUMENT ME!
         */
        protected void actionPerformed() {
            DefaultSimpleEditor.this.setValueChanged(DefaultSimpleEditor.this.isValueChanged() | this.isChanged());
            if (DefaultSimpleEditor.this.isValueChanged()) {
                DefaultSimpleEditor.this.stopEditing();
            }
        }

        /**
         * DOCUMENT ME!
         *
         * @return  DOCUMENT ME!
         */
        protected boolean isChanged() {
            if (this.oldValue != null) {
                return !this.oldValue.equals(DefaultSimpleEditor.this.simpleValueField.getText());
            } else {
                return true;
            }
        }
    }
}
