/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
/*
 * DefaultSimpleMetaAttributeEditor.java
 *
 * Created on 26. August 2004, 15:49
 */
package Sirius.navigator.ui.attributes.editor.metaobject;

import Sirius.navigator.resource.ResourceManager;
import Sirius.navigator.types.treenode.*;
import Sirius.navigator.ui.attributes.*;
import Sirius.navigator.ui.attributes.editor.*;
import Sirius.navigator.ui.dnd.MetaTransferable;

import Sirius.server.localserver.attribute.Attribute;
import Sirius.server.middleware.types.*;

import org.apache.log4j.Logger;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.datatransfer.*;
import java.awt.dnd.*;

import javax.swing.JOptionPane;

import de.cismet.cids.tools.fromstring.StringCreateable;

import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextProvider;

/**
 * Ein einfacher Standard Editor f\u00FCr komplexe Meta Attribute.
 *
 * <p>Unterst\u00FCtzt Drag & Drop von ObjectTreeNodes und String, falls das Meta Attribut dies unterst\u00FCtzt.</p>
 *
 * @author   Pascal
 * @version  $Revision$, $Date$
 */
public class DefaultSimpleComplexMetaAttributeEditor extends AbstractSimpleMetaAttributeEditor
        implements ConnectionContextProvider {

    //~ Static fields/initializers ---------------------------------------------

    private static final ResourceManager RESOURCE = ResourceManager.getManager();

    //~ Instance fields --------------------------------------------------------

    /** Gibt an, ob dieses komplexe Object als String ver\u00E4ndert wurde. */
    // protected boolean isStringEdited = false;
    // protected ValueChangeListener valueChangeListener;

    protected ValueChangeListener valueChangeListener;

    private final ConnectionContext connectionContext = ConnectionContext.createDummy();

    // Variables declaration - do not modify//GEN-BEGIN:variables
    protected javax.swing.JButton complexEditorButton;
    private javax.swing.JLabel linkLabel;
    protected javax.swing.JTextField simpleValueField;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates new form DefaultSimpleMetaAttributeEditor.
     */
    public DefaultSimpleComplexMetaAttributeEditor() {
        this.logger = Logger.getLogger(this.getClass());

        this.editorActivationDelegate = new SimpleEditorActivationDelegate();
        this.editorUIDelegate = new SimpleEditorUIDelegate();
        this.valueChangeListener = this.getValueChangeListener();

        this.initComponents();

        // Beim Dr\u00FCcken auf den [...]-Button sollte sich der komplexe Editor \u00F6ffnen
        // (oder auch nicht ...);
        this.complexEditorButton.addActionListener(this.editorActivationDelegate);

        this.simpleValueField.addFocusListener(valueChangeListener);
        this.simpleValueField.addActionListener(valueChangeListener);

        this.complexEditorButton.setPreferredSize(new Dimension(
                this.simpleValueField.getPreferredSize().height,
                this.complexEditorButton.getPreferredSize().width));
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        linkLabel = new javax.swing.JLabel();
        simpleValueField = new javax.swing.JTextField();
        final DropTarget dropTarget = new DropTarget(this.simpleValueField, new MetaAttributeDropTargetListener());
        complexEditorButton = new javax.swing.JButton();

        setLayout(new java.awt.GridBagLayout());

        linkLabel.setMaximumSize(new java.awt.Dimension(18, 18));
        linkLabel.setMinimumSize(new java.awt.Dimension(18, 18));
        linkLabel.setPreferredSize(new java.awt.Dimension(18, 18));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        add(linkLabel, gridBagConstraints);

        simpleValueField.setColumns(10);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        add(simpleValueField, gridBagConstraints);

        complexEditorButton.setText(org.openide.util.NbBundle.getMessage(
                DefaultSimpleComplexMetaAttributeEditor.class,
                "DefaultSimpleComplexMetaAttributeEditor.complexEditorButton.text")); // NOI18N
        complexEditorButton.setActionCommand(AbstractSimpleEditor.SimpleEditorActivationDelegate.SHOW_UI_COMMAND);
        complexEditorButton.setEnabled(false);
        complexEditorButton.setMargin(new java.awt.Insets(1, 1, 1, 1));
        complexEditorButton.setMaximumSize(new java.awt.Dimension(0, 0));
        complexEditorButton.setMinimumSize(new java.awt.Dimension(15, 20));
        complexEditorButton.setPreferredSize(new java.awt.Dimension(15, 20));
        complexEditorButton.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    complexEditorButtonActionPerformed(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        add(complexEditorButton, gridBagConstraints);
    } // </editor-fold>//GEN-END:initComponents

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void complexEditorButtonActionPerformed(final java.awt.event.ActionEvent evt) //GEN-FIRST:event_complexEditorButtonActionPerformed
    {                                                                                     //GEN-HEADEREND:event_complexEditorButtonActionPerformed
// TODO add your handling code here:
    } //GEN-LAST:event_complexEditorButtonActionPerformed

    /**
     * Der Wert wurde schon im ValueChanged Listener ver\u00E4ndert.
     *
     * @return  DOCUMENT ME!
     */
    @Override
    protected Object getComponentValue() {
        return this.getValue();
    }

    @Override
    protected void setComponentValue(final Object value) {
        final MetaObject MetaObject = this.getMetaObject(value);
        if (MetaObject != null) {
            this.simpleValueField.setText(MetaObject.toString());
        } else {
            this.simpleValueField.setText(null);
        }
    }

    /**
     * Der [...]-Button interessiert uns nur, wenn ein komplexer child editor verf\u00FCgbar ist ...
     *
     * @param   parentContainer     DOCUMENT ME!
     * @param   complexChildEditor  DOCUMENT ME!
     * @param   id                  DOCUMENT ME!
     * @param   value               DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    @Override
    public Component getEditorComponent(final BasicContainer parentContainer,
            final ComplexEditor complexChildEditor,
            final Object id,
            final Object value) {
        final Component editorComponent = super.getEditorComponent(parentContainer, complexChildEditor, id, value);
        if (this.complexEditorButton != null) {
            this.complexEditorButton.setEnabled(complexChildEditor != null);
        }

        return editorComponent;
    }

    @Override
    protected void initUI() {
        this.simpleValueField.setEnabled(this.isStringCreateable((Attribute)this.getValue()));
        this.simpleValueField.setEditable(this.isEditable(null));

        if ((this.getValue() != null) && (this.getMetaObject(this.getValue()) != null)
                    && (this.getMetaObject(this.getValue()).getID() != -1)) {
            this.linkLabel.setIcon(RESOURCE.getIcon("link_icon.gif")); // NOI18N
        } else {
            this.linkLabel.setIcon(RESOURCE.getIcon("copy_icon.gif")); // NOI18N
        }
    }
    /**
     * Hilfsmethoden ...........................................................
     *
     * @param   value  DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    protected MetaObject getMetaObject(final Object value) {
        if (value != null) {
            if (value instanceof MetaObject) {
                return (MetaObject)value;
            } else if (value instanceof Attribute) {
                final Object attributeValue = ((Attribute)value).getValue();
                if ((attributeValue == null) || ((attributeValue != null) && (attributeValue instanceof MetaObject))) {
                    return (MetaObject)attributeValue;
                } else {
                    logger.error("getMetaObject(" + this + ") value of Attribute '" + ((Attribute)value).getName()
                                + "' is not of type MetaObject (" + attributeValue.getClass().getName() + ")"); // NOI18N
                }
            } else {
                logger.error("getMetaObject(" + this + ") value is not of type Attribute or MetaObject ("
                            + value.getClass().getName() + ")");                                                // NOI18N
            }
        }

        return null;
    }

    /**
     * DOCUMENT ME!
     *
     * @param   object    DOCUMENT ME!
     * @param   newValue  DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     *
     * @throws  Exception  DOCUMENT ME!
     */
    protected boolean setValueFromString(final Object object, final String newValue) throws Exception {
        if (object != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("setValueFromString(): setting value from string " + newValue); // NOI18N
            }
            // Object object = ((StringCreateable)MetaObject).fromString(newValue, MetaObject);
            final Object newObject = ((StringCreateable)object).fromString(newValue, this.getMetaObject(object));
            this.setComponentValue(newObject);
            this.setValue(newObject);
            return true;
        }

        return false;
    }

    /**
     * DOCUMENT ME!
     *
     * @param   oldMetaObject  DOCUMENT ME!
     * @param   newMetaObject  DOCUMENT ME!
     * @param   link           DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    protected boolean setValueFromDragAndDrop(final MetaObject oldMetaObject,
            final MetaObject newMetaObject,
            final boolean link) {
        if (oldMetaObject.getClassKey().equals(newMetaObject.getClassKey())) {
            // Kopie!!!
            this.setValue(newMetaObject);

            // Kopie ver\u00E4ndern
            // this.getMetaObject(this.getValue()).setChanged(true);

            if (!link) {
                if (logger.isDebugEnabled()) {
                    logger.debug("setValueFromDragAndDrop() creating a copy of the selected meta object"); // NOI18N
                }
                this.getMetaObject(this.getValue()).setPrimaryKey(new Integer(-1));
                this.linkLabel.setIcon(RESOURCE.getIcon("copy_icon.gif"));                                 // NOI18N
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug("setValueFromDragAndDrop() creating a link to the selected meta object"); // NOI18N
                }
                this.linkLabel.setIcon(RESOURCE.getIcon("link_icon.gif"));                                 // NOI18N
            }

            this.setComponentValue(this.getValue());
            this.setValueChanged(true);
            return this.stopEditing();
        } else {
            String oldClassName = oldMetaObject.getClassKey();
            String newClassName = newMetaObject.getClassKey();

            try {
                oldClassName = Sirius.navigator.connection.SessionManager.getProxy()
                            .getMetaClass(oldClassName, getConnectionContext())
                            .getName();
                newClassName = Sirius.navigator.connection.SessionManager.getProxy()
                            .getMetaClass(newClassName, getConnectionContext())
                            .getName();
            } catch (Throwable t) {
                logger.warn("setValueFromDragAndDrop(): could not retrieve class names", t); // NOI18N
            }

            // XXX i18n
            JOptionPane.showMessageDialog(
                DefaultSimpleComplexMetaAttributeEditor.this,
                org.openide.util.NbBundle.getMessage(
                    DefaultSimpleComplexMetaAttributeEditor.class,
                    "DefaultSimpleComplexMetaAttributeEditor.setValueFromDragAndDrop().ErrorMessage",
                    new Object[] { oldClassName, newClassName }), // NOI18N
                org.openide.util.NbBundle.getMessage(
                    DefaultSimpleComplexMetaAttributeEditor.class,
                    "DefaultSimpleComplexMetaAttributeEditor.setValueFromDragAndDrop().ErrorTitle"),
                JOptionPane.WARNING_MESSAGE); // NOI18N
            return false;
        }
    }

    @Override
    protected Sirius.navigator.ui.attributes.editor.metaobject.AbstractSimpleMetaAttributeEditor.ValueChangeListener
    getValueChangeListener() {
        return new DefaultSimpleComplexValueChangeListener();
    }

    @Override
    public final ConnectionContext getConnectionContext() {
        return connectionContext;
    }

    //~ Inner Classes ----------------------------------------------------------

    /**
     * Speichert den Wert des Editors, wenn das Textfeld den Focus verliert oder ENTER gedr\u00FCckt wird.
     *
     * @version  $Revision$, $Date$
     */
    protected class DefaultSimpleComplexValueChangeListener extends ValueChangeListener {

        //~ Methods ------------------------------------------------------------

        @Override
        protected Object getNewValue() {
            return DefaultSimpleComplexMetaAttributeEditor.this.simpleValueField.getText();
        }

        @Override
        protected void actionPerformed() {
            DefaultSimpleComplexMetaAttributeEditor.this.setValueChanged(DefaultSimpleComplexMetaAttributeEditor.this
                        .isValueChanged() | this.isChanged());
            if (DefaultSimpleComplexMetaAttributeEditor.this.isValueChanged()) {
                try {
                    // MetaObject MetaObject = getMetaObject(getValue());
                    if (isStringCreateable((Attribute)getValue())
                                && DefaultSimpleComplexMetaAttributeEditor.this.setValueFromString(
                                    getValue(),
                                    this.getNewValue().toString())) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("actionPerformed(" + DefaultSimpleComplexMetaAttributeEditor.this.getId()
                                        + "): saves new input");                 // NOI18N
                        }
                        DefaultSimpleComplexMetaAttributeEditor.this.stopEditing();
                    } else {
                        logger.error("actionPerformed(" + DefaultSimpleComplexMetaAttributeEditor.this.getId()
                                    + "): value is not from String createable"); // NOI18N
                    }
                } catch (Throwable t) {
                    logger.error("actionPerformed(" + DefaultSimpleComplexMetaAttributeEditor.this.getId()
                                + "): from String creation ('" + this.getNewValue() + "' failed",
                        t);                                                      // NOI18N

                    // XXX i18n
                    JOptionPane.showMessageDialog(
                        DefaultSimpleComplexMetaAttributeEditor.this,
                        org.openide.util.NbBundle.getMessage(
                            DefaultSimpleComplexMetaAttributeEditor.class,
                            "DefaultSimpleComplexMetaAttributeEditor.actionPerformed().ErrorMessage"), // NOI18N
                        org.openide.util.NbBundle.getMessage(
                            DefaultSimpleComplexMetaAttributeEditor.class,
                            "DefaultSimpleComplexMetaAttributeEditor.actionPerformed().ErrorTitle"),
                        JOptionPane.ERROR_MESSAGE); // NOI18N

                    // reset
                    setComponentValue(getValue());
                }
            }
        }
    }

    /**
     * A Simple TransferHandler that exports the data as a String, and imports the data from the String clipboard. This
     * is only used if the UI hasn't supplied one, which would only happen if someone hasn't subclassed Basic.
     *
     * @version  $Revision$, $Date$
     */
    private class MetaAttributeDropTargetListener implements DropTargetListener {

        //~ Instance fields ----------------------------------------------------

        private Logger logger;
        private DataFlavor[] supportedDataFlavours;

        //~ Constructors -------------------------------------------------------

        /**
         * Creates a new MetaAttributeDropTargetListener object.
         */
        public MetaAttributeDropTargetListener() {
            this.logger = Logger.getLogger(this.getClass());

            try {
                this.supportedDataFlavours = new DataFlavor[3];

                // String
                this.supportedDataFlavours[0] = DataFlavor.stringFlavor;
                // MetaTreeNode
                this.supportedDataFlavours[1] = new DataFlavor(DataFlavor.javaJVMLocalObjectMimeType + ";class="
                                + DefaultMetaTreeNode.class.getName()); // NOI18N
                // ObjectTreeNode
                this.supportedDataFlavours[2] = new DataFlavor(DataFlavor.javaJVMLocalObjectMimeType + ";class="
                                + ObjectAttributeNode.class.getName());                            // NOI18N
            } catch (ClassNotFoundException cnfe) {
                logger.error("getTransferDataFlavors() could not create DnD data flavours", cnfe); // NOI18N
                this.supportedDataFlavours = new DataFlavor[0];
            }
        }

        //~ Methods ------------------------------------------------------------

        /**
         * DOCUMENT ME!
         *
         * @param   t  DOCUMENT ME!
         *
         * @return  DOCUMENT ME!
         */
        private boolean isLink(final Transferable t) {
            if (Sirius.navigator.ui.dnd.MetaTransferable.class.isAssignableFrom(t.getClass())) {
                logger.fatal("((MetaTransferable)t).getTransferAction(): "
                            + ((Sirius.navigator.ui.dnd.MetaTransferable)t).getTransferAction()); // NOI18N
                return (((MetaTransferable)t).getTransferAction() & java.awt.dnd.DnDConstants.ACTION_LINK) != 0;
            }

            logger.fatal("((MetaTransferable)t).getTransferAction(): "
                        + ((Sirius.navigator.ui.dnd.MetaTransferable)t).getTransferAction()); // NOI18N

            return false;
        }

        /**
         * DOCUMENT ME!
         *
         * @param   flavors  DOCUMENT ME!
         *
         * @return  DOCUMENT ME!
         */
        private DataFlavor getFlavor(final DataFlavor[] flavors) {
            if (flavors != null) {
                for (int i = 0; i < flavors.length; i++) {
                    for (int j = 0; i < this.supportedDataFlavours.length; j++) {
                        if (flavors[i].equals(this.supportedDataFlavours[j])) {
                            if (logger.isDebugEnabled()) {
                                logger.debug(flavors[i]);
                            }
                            return this.supportedDataFlavours[j];
                        }
                    }
                }
            }

            return null;
        }

        /**
         * DOCUMENT ME!
         *
         * @param   action  DOCUMENT ME!
         *
         * @return  DOCUMENT ME!
         */
        private boolean isLink(final int action) {
            return (action & java.awt.dnd.DnDConstants.ACTION_LINK) != 0;
        }

        /**
         * DOCUMENT ME!
         *
         * @param   t       DOCUMENT ME!
         * @param   action  DOCUMENT ME!
         *
         * @return  DOCUMENT ME!
         */
        private boolean importData(final Transferable t, final int action) {
            final DataFlavor dataFlavor = getFlavor(t.getTransferDataFlavors());
            try {
                if (dataFlavor != null) {
                    if (dataFlavor.equals(this.supportedDataFlavours[0])) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("importData() importing String Data"); // NOI18N
                        }

                        final String data = (String)t.getTransferData(dataFlavor);
                        DefaultSimpleComplexMetaAttributeEditor.this.simpleValueField.setText(data);
                        DefaultSimpleComplexMetaAttributeEditor.this.valueChangeListener.actionPerformed();

                        return true;
                    } else if (dataFlavor.equals(this.supportedDataFlavours[1])) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("importData() importing ObjectTreeNode Data"); // NOI18N
                        }
                        final Object object = t.getTransferData(dataFlavor);

                        if ((object != null) && (object instanceof ObjectTreeNode)) {
                            final MetaObject oldMetaObject = DefaultSimpleComplexMetaAttributeEditor.this.getMetaObject(
                                    DefaultSimpleComplexMetaAttributeEditor.this.getValue());
                            final MetaObject newMetaObject = ((ObjectTreeNode)object).getMetaObject();

                            return DefaultSimpleComplexMetaAttributeEditor.this.setValueFromDragAndDrop(
                                    oldMetaObject,
                                    newMetaObject,
                                    this.isLink(action));
                        } else if (logger.isDebugEnabled()) {
                            logger.warn("not supported MetaTreeNode: " + object); // NOI18N
                        }
                    } else if (dataFlavor.equals(this.supportedDataFlavours[2])) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("importData() importing ObjectAttributeNode Data"); // NOI18N
                        }
                        final Object object = t.getTransferData(dataFlavor);

                        if ((object != null) && (object instanceof ObjectAttributeNode)) {
                            final MetaObject oldMetaObject = DefaultSimpleComplexMetaAttributeEditor.this.getMetaObject(
                                    DefaultSimpleComplexMetaAttributeEditor.this.getValue());
                            final MetaObject newMetaObject = ((ObjectAttributeNode)object).getMetaObject();

                            return DefaultSimpleComplexMetaAttributeEditor.this.setValueFromDragAndDrop(
                                    oldMetaObject,
                                    newMetaObject,
                                    this.isLink(action));
                        } else if (logger.isDebugEnabled()) {
                            logger.warn("not supported AttributeTreeNode: " + object); // NOI18N
                        }
                    }

                    // XXX i18n
                    JOptionPane.showMessageDialog(
                        DefaultSimpleComplexMetaAttributeEditor.this,
                        org.openide.util.NbBundle.getMessage(
                            DefaultSimpleComplexMetaAttributeEditor.class,
                            "DefaultSimpleComplexMetaAttributeEditor.importData().ErrorMessage"), // NOI18N
                        org.openide.util.NbBundle.getMessage(
                            DefaultSimpleComplexMetaAttributeEditor.class,
                            "DefaultSimpleComplexMetaAttributeEditor.importData().ErrorTitle"),
                        JOptionPane.WARNING_MESSAGE); // NOI18N
                }
            } catch (Throwable th) {
                logger.error("importData():  data import failed", th); // NOI18N
            }

            return false;
        }

        @Override
        public void dragEnter(final DropTargetDragEvent dtde) {
            if (logger.isDebugEnabled()) {
                logger.debug("dragEnter()"); // NOI18N
            }

            if (this.getFlavor(dtde.getCurrentDataFlavors()) == null) {
                dtde.rejectDrag();
            }
        }

        @Override
        public void drop(final DropTargetDropEvent dtde) {
            if (logger.isDebugEnabled()) {
                logger.debug("drop()"); // NOI18N
            }

            if (!this.importData(dtde.getTransferable(), dtde.getDropAction())) {
                dtde.rejectDrop();
            }
        }

        @Override
        public void dragExit(final DropTargetEvent dte) {
            // if(LOG.isDebugEnabled())LOG.debug("dragExit()");
        }

        @Override
        public void dragOver(final DropTargetDragEvent dtde) {
            // if(LOG.isDebugEnabled())LOG.debug("dragOver()");
        }

        @Override
        public void dropActionChanged(final DropTargetDragEvent dtde) {
            // if(LOG.isDebugEnabled())LOG.debug("dropActionChangedr()");
        }
    }
}
