/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
/*
 * ReadOnlyMetaAttributeEditor.java
 *
 * Created on 27. August 2004, 09:24
 */
package Sirius.navigator.ui.attributes.editor.metaobject;

import org.apache.log4j.Logger;

/**
 * DOCUMENT ME!
 *
 * @author   pascal
 * @version  $Revision$, $Date$
 */
public class ReadOnlyMetaAttributeEditor extends AbstractSimpleMetaAttributeEditor // javax.swing.JPanel
{

    //~ Instance fields --------------------------------------------------------

    protected ValueChangeListener valueChangeListener;

    // Variables declaration - do not modify//GEN-BEGIN:variables
    protected javax.swing.JTextField simpleValueField;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates new form ReadOnlyMetaAttributeEditor.
     */
    public ReadOnlyMetaAttributeEditor() {
        this.logger = Logger.getLogger(this.getClass());

        this.editorActivationDelegate = new SimpleEditorActivationDelegate();
        this.editorUIDelegate = new SimpleEditorUIDelegate();
        valueChangeListener = this.getValueChangeListener();

        this.initComponents();

        this.readOnly = true;
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        final java.awt.GridBagConstraints gridBagConstraints;

        simpleValueField = new javax.swing.JTextField();

        setLayout(new java.awt.GridBagLayout());

        simpleValueField.setColumns(12);
        simpleValueField.setDragEnabled(true);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        add(simpleValueField, gridBagConstraints);
    }
    // </editor-fold>//GEN-END:initComponents

    @Override
    protected void initUI() {
        this.simpleValueField.setEnabled(false);
        this.simpleValueField.setEditable(false);
    }

    @Override
    protected Object getComponentValue() {
        return this.getValue();
    }

    /**
     * Setzt den Wert, der angezeigt werden soll.
     *
     * @param  value  ein Objekt vom Typ Attribut
     */
    @Override
    protected void setComponentValue(final Object value) {
        if (value != null) {
            this.simpleValueField.setText(value.toString());
        } else {
            this.simpleValueField.setText(null);
        }
    }

    @Override
    protected Sirius.navigator.ui.attributes.editor.metaobject.AbstractSimpleMetaAttributeEditor.ValueChangeListener
    getValueChangeListener() {
        return new DefaultSimpleValueChangeListener();
    }

    @Override
    public boolean isValueChanged() {
        return false;
    }

    @Override
    public boolean isValueNew() {
        return false;
    }

    //~ Inner Classes ----------------------------------------------------------

    /**
     * Speichert den Wert des Editors, wenn das Textfeld den Focus verliert oder ENTER gedr\u00FCckt wird.
     *
     * @version  $Revision$, $Date$
     */
    protected class DefaultSimpleValueChangeListener extends ValueChangeListener {

        //~ Methods ------------------------------------------------------------

        @Override
        protected Object getNewValue() {
            return ReadOnlyMetaAttributeEditor.this.getValue();
        }
    }
}
