/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
/*
 * SimpleBooleanMetaAttributeEditor.java
 *
 * Created on 29. August 2004, 15:48
 */
package Sirius.navigator.ui.attributes.editor.metaobject;

import Sirius.navigator.ui.attributes.editor.*;

import Sirius.server.localserver.attribute.Attribute;
import Sirius.server.middleware.types.MetaObject;

import org.apache.log4j.Logger;

import java.awt.*;
import java.awt.event.*;

import java.util.*;

import javax.swing.*;
import javax.swing.event.*;

/**
 * Ein Editor f\u00FCr Boolean Attribute.
 *
 * @author   Pascal
 * @version  $Revision$, $Date$
 */
public class SimpleBooleanMetaAttributeEditor extends AbstractSimpleMetaAttributeEditor {

    //~ Instance fields --------------------------------------------------------

    // Variables declaration - do not modify//GEN-BEGIN:variables
    protected javax.swing.JCheckBox booleanCheckBox;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates new form SimpleBooleanMetaAttributeEditor.
     */
    public SimpleBooleanMetaAttributeEditor() {
        this.logger = Logger.getLogger(this.getClass());

        this.editorActivationDelegate = new SimpleEditorActivationDelegate();
        this.editorUIDelegate = new SimpleEditorUIDelegate();
        this.readOnly = false;

        this.initComponents();
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        final java.awt.GridBagConstraints gridBagConstraints;

        booleanCheckBox = new javax.swing.JCheckBox();

        setLayout(new java.awt.GridBagLayout());

        booleanCheckBox.setMargin(new java.awt.Insets(2, 0, 2, 2));
        booleanCheckBox.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    booleanCheckBoxActionPerformed(evt);
                }
            });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        add(booleanCheckBox, gridBagConstraints);
    }
    // </editor-fold>//GEN-END:initComponents

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void booleanCheckBoxActionPerformed(final java.awt.event.ActionEvent evt) //GEN-FIRST:event_booleanCheckBoxActionPerformed
    {                                                                                 //GEN-HEADEREND:event_booleanCheckBoxActionPerformed
        this.setValueChanged(true);
        this.stopEditing();
    }                                                                                 //GEN-LAST:event_booleanCheckBoxActionPerformed

    @Override
    protected void initUI() {
        this.booleanCheckBox.setEnabled(this.isEditable(null));
    }

    @Override
    public boolean isEditable(final java.util.EventObject anEvent) {
        return true;
    }

    @Override
    protected Object getComponentValue() {
        return new Boolean(this.booleanCheckBox.isSelected());
    }

    @Override
    protected void setComponentValue(final Object value) {
        if (logger.isDebugEnabled()) {
            logger.debug("setting boolean value: " + value); // NOI18N
        }

        if (value != null) {
            final Object attributeValue = this.getAttributeValue(value);
            if ((attributeValue != null) && (attributeValue instanceof Boolean)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("this.booleanCheckBox.setSelected(((Boolean)value).booleanValue()): "
                                + ((Boolean)attributeValue).booleanValue());                 // NOI18N
                }
                this.booleanCheckBox.setSelected(((Boolean)value).booleanValue());
            } else {
                logger.warn("new value (" + attributeValue
                            + ") is null or not of type Boolean, setting value to 'FALSE'"); // NOI18N
                this.setValue(new Boolean(false));
                this.booleanCheckBox.setSelected(false);
            }
        } else {
            // standardm\u00E4\u00DFig auf false setzen
            this.booleanCheckBox.setSelected(false);
            this.setValue(new Boolean(false));
            this.setValueChanged(true);
        }
    }

    @Override
    protected Sirius.navigator.ui.attributes.editor.metaobject.AbstractSimpleMetaAttributeEditor.ValueChangeListener
    getValueChangeListener() {
        return null;
    }
}
