/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
/*
 * SimpleDataMetaAttributeEditor.java
 *
 * Created on 14. September 2004, 13:47
 */
package Sirius.navigator.ui.attributes.editor.metaobject;

import Sirius.navigator.ui.attributes.editor.*;
import Sirius.navigator.ui.dialog.DateChooser;

import Sirius.server.localserver.attribute.Attribute;

import org.apache.log4j.Logger;

import java.awt.*;

import java.text.*;

import java.util.*;

import de.cismet.tools.gui.StaticSwingTools;

/**
 * DOCUMENT ME!
 *
 * @author   pascal
 * @version  $Revision$, $Date$
 */
public class SimpleDateMetaAttributeEditor extends AbstractSimpleMetaAttributeEditor {

    //~ Instance fields --------------------------------------------------------

    protected ValueChangeListener valueChangeListener;

    private DateFormat dateFormat;
    private DateChooser dateChooser;
    // Variables declaration - do not modify//GEN-BEGIN:variables
    protected javax.swing.JButton complexEditorButton;
    protected javax.swing.JTextField simpleValueField;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates new form SimpleDataMetaAttributeEditor.
     */
    public SimpleDateMetaAttributeEditor() {
        this.logger = Logger.getLogger(this.getClass());

        this.editorActivationDelegate = new SimpleEditorActivationDelegate();
        this.editorUIDelegate = new SimpleEditorUIDelegate();
        this.readOnly = false;

        this.initComponents();

        valueChangeListener = this.getValueChangeListener();
        this.simpleValueField.addFocusListener(valueChangeListener);
        this.simpleValueField.addActionListener(valueChangeListener);

        this.dateFormat = new SimpleDateFormat("dd.MM.yyyy"); // NOI18N
        this.dateChooser = new DateChooser();

        this.complexEditorButton.setPreferredSize(new Dimension(
                this.simpleValueField.getPreferredSize().height,
                this.complexEditorButton.getPreferredSize().width));
    }

    //~ Methods ----------------------------------------------------------------

    @Override
    protected Sirius.navigator.ui.attributes.editor.metaobject.AbstractSimpleMetaAttributeEditor.ValueChangeListener
    getValueChangeListener() {
        return new DefaultSimpleValueChangeListener();
    }

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        simpleValueField = new javax.swing.JTextField();
        complexEditorButton = new javax.swing.JButton();

        setLayout(new java.awt.GridBagLayout());

        simpleValueField.setColumns(10);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        add(simpleValueField, gridBagConstraints);

        complexEditorButton.setText(org.openide.util.NbBundle.getMessage(
                SimpleDateMetaAttributeEditor.class,
                "SimpleDateMetaAttributeEditor.complexEditorButton.text")); // NOI18N
        complexEditorButton.setActionCommand(AbstractSimpleEditor.SimpleEditorActivationDelegate.SHOW_UI_COMMAND);
        complexEditorButton.setMargin(new java.awt.Insets(1, 1, 1, 1));
        complexEditorButton.setMaximumSize(new java.awt.Dimension(0, 0));
        complexEditorButton.setMinimumSize(new java.awt.Dimension(15, 20));
        complexEditorButton.setPreferredSize(new java.awt.Dimension(15, 20));
        complexEditorButton.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    complexEditorButtonActionPerformed(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        add(complexEditorButton, gridBagConstraints);
    } // </editor-fold>//GEN-END:initComponents

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void complexEditorButtonActionPerformed(final java.awt.event.ActionEvent evt) //GEN-FIRST:event_complexEditorButtonActionPerformed
    {                                                                                     //GEN-HEADEREND:event_complexEditorButtonActionPerformed
                                                                                          // TODO add your handling code
                                                                                          // here:
        if (logger.isDebugEnabled()) {
            logger.debug("complexEditorButtonActionPerformed");                           // NOI18N
        }
        this.dateChooser.pack();
        this.dateChooser.setLocationRelativeTo(this);
        final Object object = this.getAttributeValue(this.getValue());

        if ((object != null) && (object instanceof Date)) {
            if (logger.isDebugEnabled()) {
                logger.debug("showing date chooser with date " + this.dateFormat.format(object)); // NOI18N
            }
            this.dateChooser.show((Date)object);
        } else {
            StaticSwingTools.showDialog(dateChooser);
        }

        if (this.dateChooser.isDateAccepted()) {
            final Date date = dateChooser.getDate();
            this.setValue(new java.sql.Date(date.getTime()));
            this.setComponentValue(date);
            this.setValueChanged(true);
            SimpleDateMetaAttributeEditor.this.stopEditing();
        }
    } //GEN-LAST:event_complexEditorButtonActionPerformed

    @Override
    protected void initUI() {
        this.complexEditorButton.setEnabled(this.isEditable(null));
        this.simpleValueField.setEnabled(this.isStringCreateable((Attribute)this.getValue()));
    }

    /**
     * Der Wert wurde schon im ActionLinster Listener ver\u00E4ndert.
     *
     * @return  DOCUMENT ME!
     */
    @Override
    protected Object getComponentValue() {
        return this.getValue();
    }

    @Override
    protected void setComponentValue(final Object value) {
        final Object attributeValue = this.getAttributeValue(value);
        if ((attributeValue != null) && (attributeValue instanceof Date)) {
            this.simpleValueField.setText(this.dateFormat.format((Date)attributeValue));
        } else {
            this.simpleValueField.setText(null);
        }
    }

    //~ Inner Classes ----------------------------------------------------------

    /**
     * Speichert den Wert des Editors, wenn das Textfeld den Focus verliert oder ENTER gedr\u00FCckt wird.
     *
     * @version  $Revision$, $Date$
     */
    protected class DefaultSimpleValueChangeListener extends ValueChangeListener {

        //~ Instance fields ----------------------------------------------------

        DateFormat shortDF = DateFormat.getDateInstance(DateFormat.SHORT);
        DateFormat mediumDF = DateFormat.getDateInstance(DateFormat.MEDIUM);

        //~ Methods ------------------------------------------------------------

        @Override
        protected Object getNewValue() {
            if (logger.isDebugEnabled()) {
                logger.debug("getNewValue:" + simpleValueField.getText()); // NOI18N
            }
            final String textValue = simpleValueField.getText();
            if ((textValue != null) && (textValue.length() == 0)) {
                setValue(null);
                return null;
            } else {
                Date d = null;
                try {
                    d = shortDF.parse(textValue);
                } catch (ParseException ex) {
                    logger.warn("Error while parsing date:", ex);          // NOI18N
                    setValue(null);
                    setComponentValue(null);
                    setValueChanged(true);
                    simpleValueField.repaint();
                    stopEditing();
                    return null;
                }

                final java.sql.Date sqlDate = new java.sql.Date(d.getTime());
                setValue(sqlDate);
                setComponentValue(sqlDate);
                setValueChanged(true);
                stopEditing();
                return sqlDate;
            }
        }
    }
}
