/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
/*
 * SimpleBooleanMetaAttributeEditor.java
 *
 * Created on 29. August 2004, 15:48
 */
package Sirius.navigator.ui.attributes.editor.metaobject;

import Sirius.navigator.ui.attributes.editor.*;

import Sirius.server.localserver.attribute.Attribute;
import Sirius.server.middleware.types.MetaObject;

import org.apache.log4j.Logger;

import java.awt.*;
import java.awt.event.*;

import java.util.*;

import javax.swing.*;
import javax.swing.event.*;

/**
 * DOCUMENT ME!
 *
 * @author   Pascal
 * @version  $Revision$, $Date$
 */
public class SimpleStringSelectionMetaAttributeEditor extends AbstractSimpleMetaAttributeEditor {

    //~ Instance fields --------------------------------------------------------

    protected Collection selectionValues;

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JComboBox stringComboBox;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates new form SimpleBooleanMetaAttributeEditor.
     */
    public SimpleStringSelectionMetaAttributeEditor() {
        this.logger = Logger.getLogger(this.getClass());
        this.selectionValues = this.getSelectionValues();

        this.editorActivationDelegate = new SimpleEditorActivationDelegate();
        this.editorUIDelegate = new SimpleEditorUIDelegate();
        this.readOnly = false;

        this.initComponents();

        this.stringComboBox.setModel((new DefaultComboBoxModel(
                    (Object[])selectionValues.toArray(new Object[selectionValues.size()]))));
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    protected Collection getSelectionValues() {
        final HashSet selectionValues = new HashSet();

        selectionValues.add("Wert 1"); // NOI18N
        selectionValues.add("Wert 2"); // NOI18N
        selectionValues.add("Wert 3"); // NOI18N

        return selectionValues;
    }

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        final java.awt.GridBagConstraints gridBagConstraints;

        stringComboBox = new javax.swing.JComboBox();

        setLayout(new java.awt.GridBagLayout());

        stringComboBox.addItemListener(new java.awt.event.ItemListener() {

                @Override
                public void itemStateChanged(final java.awt.event.ItemEvent evt) {
                    stringComboBoxItemStateChanged(evt);
                }
            });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        add(stringComboBox, gridBagConstraints);
    }
    // </editor-fold>//GEN-END:initComponents

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void stringComboBoxItemStateChanged(final java.awt.event.ItemEvent evt)               //GEN-FIRST:event_stringComboBoxItemStateChanged
    {                                                                                             //GEN-HEADEREND:event_stringComboBoxItemStateChanged
        if (evt.getStateChange() == ItemEvent.SELECTED) {
            if (logger.isDebugEnabled()) {
                logger.debug("stringComboBoxItemStateChanged() item selected: " + evt.getItem()); // NOI18N
            }
            this.setValueChanged(true);
            this.stopEditing();
        }
    }                                                                                             //GEN-LAST:event_stringComboBoxItemStateChanged

    @Override
    protected void initUI() {
        this.stringComboBox.setEnabled(this.isEditable(null));
    }

    @Override
    public boolean isEditable(final java.util.EventObject anEvent) {
        return true;
    }

    @Override
    protected Object getComponentValue() {
        return this.stringComboBox.getSelectedItem();
    }

    // value ist immer ein Attribut!!!
    @Override
    protected void setComponentValue(final Object value) {
        if (logger.isDebugEnabled()) {
            logger.debug("setComponentValue(): setting string value: '" + value + "'");                               // NOI18N
        }
        if ((value != null) && (this.getAttributeValue(value) != null)) {
            if (this.selectionValues.contains(this.getAttributeValue(value))) {
                if (logger.isDebugEnabled()) {
                    logger.debug("setComponentValue(): this.stringComboBox.setSelectedItem(value): '" + value + "'"); // NOI18N
                }
                this.stringComboBox.setSelectedItem(value.toString());
            } else {
                logger.warn("setComponentValue(): new value (" + value
                            + ") is not in the list of allowed selection values");                                    // NOI18N
                this.stringComboBox.setSelectedIndex(0);

                /*logger.debug(value.getClass());
                 * Iterator iterator = this.selectionValues.iterator(); while(iterator.hasNext()) {
                 * logger.debug(iterator.next());}*/
            }
        } else {
            // standardm\u00E4\u00DFig auf 0 setzen
            this.stringComboBox.setSelectedIndex(0);
            if (logger.isDebugEnabled()) {
                logger.debug("setComponentValue(): value is null, setting index 0 to: "
                            + this.stringComboBox.getSelectedItem()); // NOI18N
            }
            this.setValue(this.getComponentValue());
            this.setValueChanged(true);
        }
    }

    @Override
    protected Sirius.navigator.ui.attributes.editor.metaobject.AbstractSimpleMetaAttributeEditor.ValueChangeListener
    getValueChangeListener() {
        return null;
    }
}
