/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
/*
 * SimpleBooleanEditor.java
 *
 * Created on 24. August 2004, 16:16
 */
package Sirius.navigator.ui.attributes.editor.primitive;

import Sirius.navigator.ui.attributes.editor.*;

import org.apache.log4j.Logger;

import java.awt.event.*;

/**
 * DOCUMENT ME!
 *
 * @author   pascal
 * @version  $Revision$, $Date$
 */
public class SimpleBooleanEditor extends AbstractSimpleEditor // javax.swing.JPanel
{

    //~ Instance fields --------------------------------------------------------

    // Variables declaration - do not modify//GEN-BEGIN:variables
    protected javax.swing.JCheckBox booleanCheckBox;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates new form SimpleBooleanEditor.
     */
    public SimpleBooleanEditor() {
        super();

        this.logger = Logger.getLogger(SimpleBooleanEditor.class);
        this.editorActivationDelegate = null;
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        booleanCheckBox = new javax.swing.JCheckBox();

        setLayout(new java.awt.BorderLayout());

        booleanCheckBox.setMargin(new java.awt.Insets(2, 0, 2, 2));
        booleanCheckBox.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    booleanCheckBoxActionPerformed(evt);
                }
            });
        add(booleanCheckBox, java.awt.BorderLayout.CENTER);
    } // </editor-fold>//GEN-END:initComponents

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void booleanCheckBoxActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_booleanCheckBoxActionPerformed
        // TODO add your handling code here:
    } //GEN-LAST:event_booleanCheckBoxActionPerformed

    @Override
    protected Object getComponentValue() {
        return new Boolean(this.booleanCheckBox.isSelected());
    }

    @Override
    protected void initUI() {
        if (!this.init) {
            this.initComponents();

            this.booleanCheckBox.setSelected(true);
            this.booleanCheckBox.addActionListener(new ValueChangeListener());

            this.init = true;
        } else if (logger.isDebugEnabled()) {
            logger.debug("ui already initialized"); // NOI18N
        }

        this.booleanCheckBox.setEnabled(!this.readOnly);
        this.setValueChanged(false);
    }

    @Override
    public boolean isEditable(final java.util.EventObject anEvent) {
        return this.booleanCheckBox.isEnabled();
    }

    @Override
    protected void setComponentValue(final Object value) {
        // if(logger.isDebugEnabled())logger.debug("setting boolean value: " + value);
        if (value != null) {
            if (value instanceof Boolean) {
                //
                // if(logger.isDebugEnabled())logger.debug("this.booleanCheckBox.setSelected(((Boolean)value).booleanValue()):
                // " + ((Boolean)value).booleanValue());
                this.booleanCheckBox.setSelected(((Boolean)value).booleanValue());
            } else {
                logger.warn("new value (" + value + ") is not of type Boolean, setting value to 'FALSE'"); // NOI18N
                this.setValue(new Boolean(false));
                this.booleanCheckBox.setSelected(false);
            }
        } else {
            // standardm\u00E4\u00DFig auf false setzen
            this.booleanCheckBox.setSelected(false);
            this.setValue(new Boolean(false));
            this.setValueChanged(true);
        }
    }

    //~ Inner Classes ----------------------------------------------------------

    /**
     * DOCUMENT ME!
     *
     * @version  $Revision$, $Date$
     */
    protected class ValueChangeListener implements ActionListener {

        //~ Methods ------------------------------------------------------------

        @Override
        public void actionPerformed(final ActionEvent e) {
            SimpleBooleanEditor.this.setValueChanged(true);
            SimpleBooleanEditor.this.stopEditing();
        }
    }
}
