/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
package Sirius.navigator.ui.attributes.renderer;

import org.apache.commons.lang.StringUtils;

import org.openide.util.NbBundle;

import javax.swing.JComponent;

import de.cismet.tools.gui.TitleComponentProvider;

/**
 * DOCUMENT ME!
 *
 * @author   jruiz
 * @version  $Revision$, $Date$
 */
public class NoDescriptionRenderer extends javax.swing.JPanel implements TitleComponentProvider {

    //~ Static fields/initializers ---------------------------------------------

    private static NoDescriptionRenderer INSTANCE = new NoDescriptionRenderer();
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel lblIcon;
    private javax.swing.JLabel lblText;
    private javax.swing.JLabel lblTitle;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates new form NoDescriptionRenderer.
     */
    public NoDescriptionRenderer() {
        initComponents();
        final String textIconPath = NbBundle.getMessage(
                NoDescriptionRenderer.class,
                "NoDescriptionRenderer.nodescription_text");
        if (StringUtils.isNotBlank(textIconPath)) {
            lblText.setIcon(new javax.swing.ImageIcon(
                    getClass().getResource(textIconPath)));
        }
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    public static NoDescriptionRenderer getInstance() {
        return INSTANCE;
    }

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        lblTitle = new javax.swing.JLabel();
        lblIcon = new javax.swing.JLabel();
        lblText = new javax.swing.JLabel();

        lblTitle.setFont(new java.awt.Font("Tahoma", 1, 18));
        lblTitle.setForeground(new java.awt.Color(255, 255, 255));
        lblTitle.setText(org.openide.util.NbBundle.getMessage(
                NoDescriptionRenderer.class,
                "NoDescriptionRenderer.lblTitle.text")); // NOI18N

        setOpaque(false);
        setLayout(new java.awt.GridBagLayout());

        lblIcon.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        lblIcon.setIcon(new javax.swing.ImageIcon(
                getClass().getResource("/Sirius/navigator/ui/attributes/renderer/nodescription_icon.png"))); // NOI18N
        lblIcon.setText(org.openide.util.NbBundle.getMessage(
                NoDescriptionRenderer.class,
                "NoDescriptionRenderer.lblIcon.text"));                                                      // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(10, 10, 25, 10);
        add(lblIcon, gridBagConstraints);

        lblText.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        lblText.setIcon(new javax.swing.ImageIcon(
                getClass().getResource("/Sirius/navigator/ui/attributes/renderer/nodescription_text.png"))); // NOI18N
        lblText.setText(org.openide.util.NbBundle.getMessage(
                NoDescriptionRenderer.class,
                "NoDescriptionRenderer.lblText.text"));                                                      // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(25, 10, 10, 10);
        add(lblText, gridBagConstraints);
    }                                                                                                        // </editor-fold>//GEN-END:initComponents

    @Override
    public JComponent getTitleComponent() {
        return lblTitle;
    }

    /**
     * DOCUMENT ME!
     *
     * @param  title  node DOCUMENT ME!
     */
    public void setTitle(final String title) {
        lblTitle.setText(title);
    }
}
