/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
package Sirius.navigator.ui.option;

import Sirius.navigator.tools.MetaObjectCache;

import org.apache.log4j.Logger;

import org.jdom.Element;

import org.openide.util.lookup.ServiceProvider;

import javax.swing.JOptionPane;

import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;

import de.cismet.lookupoptions.AbstractOptionsPanel;
import de.cismet.lookupoptions.OptionsPanelController;

import de.cismet.lookupoptions.options.GeneralOptionsCategory;

import de.cismet.tools.configuration.NoWriteError;

/**
 * DOCUMENT ME!
 *
 * @version  $Revision$, $Date$
 */
@ServiceProvider(service = OptionsPanelController.class)
public class MetaObjectCacheOptionsPanel extends AbstractOptionsPanel implements ConnectionContextStore {

    //~ Static fields/initializers ---------------------------------------------

    private static final transient Logger LOG = Logger.getLogger(MetaObjectCacheOptionsPanel.class);
    private static final String MESSAGE_TITLE = org.openide.util.NbBundle.getMessage(
            MetaObjectCacheOptionsPanel.class,
            "MetaObjectCacheOptionsPanel.title");

    //~ Instance fields --------------------------------------------------------

    private final String MESSAGE_CONFIRM_MESSAGE = org.openide.util.NbBundle.getMessage(
            MetaObjectCacheOptionsPanel.class,
            "MetaObjectCacheOptionsPanel.confirm.message");
    private final String MESSAGE_CONFIRM_TITLE = org.openide.util.NbBundle.getMessage(
            MetaObjectCacheOptionsPanel.class,
            "MetaObjectCacheOptionsPanel.confirm.title");

    private ConnectionContext connectionContext = ConnectionContext.createDummy();

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.Box.Filler filler1;
    private javax.swing.JButton jButton1;
    private javax.swing.JLabel lblDialogDescription;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates new form PasswordOptionsDialog.
     */
    public MetaObjectCacheOptionsPanel() {
        super(MESSAGE_TITLE, GeneralOptionsCategory.class);
    }

    //~ Methods ----------------------------------------------------------------

    @Override
    public void initWithConnectionContext(final ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;

        try {
            initComponents();
        } catch (Exception e) {
            LOG.error("Erro during Creation of Password Dialog", e);
        }
    }

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        filler1 = new javax.swing.Box.Filler(new java.awt.Dimension(0, 0),
                new java.awt.Dimension(0, 0),
                new java.awt.Dimension(0, 32767));
        lblDialogDescription = new javax.swing.JLabel();
        jButton1 = new javax.swing.JButton();

        setBorder(javax.swing.BorderFactory.createEmptyBorder(5, 5, 5, 5));
        setMaximumSize(new java.awt.Dimension(264, 177));
        setMinimumSize(new java.awt.Dimension(100, 177));
        setLayout(new java.awt.GridBagLayout());
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weighty = 0.1;
        add(filler1, gridBagConstraints);

        lblDialogDescription.setText(org.openide.util.NbBundle.getMessage(
                MetaObjectCacheOptionsPanel.class,
                "MetaObjectCacheOptionsPanel.lblDialogDescription.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 10, 4);
        add(lblDialogDescription, gridBagConstraints);

        jButton1.setText(org.openide.util.NbBundle.getMessage(
                MetaObjectCacheOptionsPanel.class,
                "MetaObjectCacheOptionsPanel.jButton1.text")); // NOI18N
        jButton1.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    jButton1ActionPerformed(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
        add(jButton1, gridBagConstraints);
    } // </editor-fold>//GEN-END:initComponents

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void jButton1ActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_jButton1ActionPerformed
        MetaObjectCache.getInstance().clearCache();
        JOptionPane.showMessageDialog(
            this,
            MESSAGE_CONFIRM_MESSAGE,
            MESSAGE_CONFIRM_TITLE,
            JOptionPane.INFORMATION_MESSAGE);
    }                                                                            //GEN-LAST:event_jButton1ActionPerformed

    @Override
    public void update() {
    }

    @Override
    public void applyChanges() {
    }

    @Override
    public boolean isChanged() {
        return false;
    }

    /**
     * DOCUMENT ME!
     */
    private void updateGui() {
    }

    /**
     * Returns tooltip text.
     *
     * @return  tooltip text
     */
    @Override
    public String getTooltip() {
        return org.openide.util.NbBundle.getMessage(
                MetaObjectCacheOptionsPanel.class,
                "MetaObjectCacheOptionsPanel.tooltip"); // NOI18N
    }

    @Override
    public void configure(final Element parent) {
    }

    @Override
    public Element getConfiguration() throws NoWriteError {
        return null;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public ConnectionContext getConnectionContext() {
        return connectionContext;
    }
}
