/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
package Sirius.navigator.ui.option;

import Sirius.navigator.connection.ConnectionSession;
import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.connection.proxy.ConnectionProxy;
import Sirius.navigator.ui.ComponentRegistry;
import Sirius.navigator.ui.dialog.PasswordDialog;

import Sirius.server.localserver.user.PasswordCheckException;

import org.apache.log4j.Logger;

import org.openide.util.NbBundle;
import org.openide.util.lookup.ServiceProvider;

import java.awt.EventQueue;

import java.util.Arrays;

import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;

import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;

import de.cismet.lookupoptions.AbstractOptionsPanel;
import de.cismet.lookupoptions.OptionsPanelController;

import de.cismet.lookupoptions.options.SecurityOptionsCategory;

/**
 * The PasswordOptionsDialog is intended to provide the user with means for changing her password. It is displayed in
 * the menu "Extras -> Optionen -> Sicherheit->Kennword ändern" and replaces {@link PasswordDialog}.
 *
 * @author   Benjamin Friedrich (benjamin.friedrich@cismet.de)
 * @version  $Revision$, $Date$
 */
@ServiceProvider(service = OptionsPanelController.class)
public class PasswordOptionsDialog extends AbstractOptionsPanel implements ConnectionContextStore {

    //~ Static fields/initializers ---------------------------------------------

    private static final transient Logger LOG = Logger.getLogger(PasswordOptionsDialog.class);

    //~ Instance fields --------------------------------------------------------

    private ConnectionContext connectionContext = ConnectionContext.createDummy();
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton btnChangePassword;
    private javax.swing.Box.Filler filler1;
    private javax.swing.JLabel lblDialogDescription;
    private javax.swing.JLabel lblNewPassword;
    private javax.swing.JLabel lblNewPasswordHints;
    private javax.swing.JLabel lblOldPassword;
    private javax.swing.JLabel lblPasswordAgain;
    private javax.swing.JLabel lblUser;
    private javax.swing.JPasswordField pwdNewPassword;
    private javax.swing.JPasswordField pwdOldPassword;
    private javax.swing.JPasswordField pwdPasswordAgain;
    private javax.swing.JTextField txtUser;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates new form PasswordOptionsDialog.
     */
    public PasswordOptionsDialog() {
        super(org.openide.util.NbBundle.getMessage(
                PasswordOptionsDialog.class,
                "PasswordOptionsDialog.title"), // NOI18N,
            SecurityOptionsCategory.class);
    }

    //~ Methods ----------------------------------------------------------------

    @Override
    public void initWithConnectionContext(final ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
        try {
            initComponents();

            this.txtUser.setText(SessionManager.getSession().getUser().getName());
            this.clearPwdFields();
        } catch (Exception e) {
            LOG.error("Erro during Creation of Password Dialog", e);
            btnChangePassword.setEnabled(false);
            ;
        }
    }

    /**
     * DOCUMENT ME!
     */
    private void clearPwdFields() {
        this.pwdNewPassword.setText("");
        this.pwdOldPassword.setText("");
        this.pwdPasswordAgain.setText("");
        pwdNewPasswordKeyTyped(null);
    }

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        lblUser = new javax.swing.JLabel();
        lblOldPassword = new javax.swing.JLabel();
        lblNewPassword = new javax.swing.JLabel();
        lblPasswordAgain = new javax.swing.JLabel();
        txtUser = new javax.swing.JTextField();
        pwdNewPassword = new javax.swing.JPasswordField();
        pwdOldPassword = new javax.swing.JPasswordField();
        pwdPasswordAgain = new javax.swing.JPasswordField();
        filler1 = new javax.swing.Box.Filler(new java.awt.Dimension(0, 0),
                new java.awt.Dimension(0, 0),
                new java.awt.Dimension(0, 32767));
        btnChangePassword = new javax.swing.JButton();
        lblDialogDescription = new javax.swing.JLabel();
        lblNewPasswordHints = new javax.swing.JLabel();

        setBorder(javax.swing.BorderFactory.createEmptyBorder(5, 5, 5, 5));
        setMaximumSize(new java.awt.Dimension(264, 177));
        setMinimumSize(new java.awt.Dimension(100, 177));
        setLayout(new java.awt.GridBagLayout());

        lblUser.setText(org.openide.util.NbBundle.getMessage(
                PasswordOptionsDialog.class,
                "PasswordOptionsDialog.lblUser.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 0, 0);
        add(lblUser, gridBagConstraints);

        lblOldPassword.setText(org.openide.util.NbBundle.getMessage(
                PasswordOptionsDialog.class,
                "PasswordOptionsDialog.lblOldPassword.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 0, 0);
        add(lblOldPassword, gridBagConstraints);

        lblNewPassword.setText(org.openide.util.NbBundle.getMessage(
                PasswordOptionsDialog.class,
                "PasswordOptionsDialog.lblNewPassword.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 0, 0);
        add(lblNewPassword, gridBagConstraints);

        lblPasswordAgain.setText(org.openide.util.NbBundle.getMessage(
                PasswordOptionsDialog.class,
                "PasswordOptionsDialog.lblPasswordAgain.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 0, 0);
        add(lblPasswordAgain, gridBagConstraints);

        txtUser.setEditable(false);
        txtUser.setEnabled(false);
        txtUser.setPreferredSize(new java.awt.Dimension(100, 27));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        add(txtUser, gridBagConstraints);

        pwdNewPassword.setPreferredSize(new java.awt.Dimension(100, 27));
        pwdNewPassword.addKeyListener(new java.awt.event.KeyAdapter() {

                @Override
                public void keyTyped(final java.awt.event.KeyEvent evt) {
                    pwdNewPasswordKeyTyped(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 2, 4);
        add(pwdNewPassword, gridBagConstraints);

        pwdOldPassword.setPreferredSize(new java.awt.Dimension(100, 27));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        add(pwdOldPassword, gridBagConstraints);

        pwdPasswordAgain.setPreferredSize(new java.awt.Dimension(100, 27));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        add(pwdPasswordAgain, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weighty = 0.1;
        add(filler1, gridBagConstraints);

        btnChangePassword.setText(org.openide.util.NbBundle.getMessage(
                PasswordOptionsDialog.class,
                "PasswordOptionsDialog.btnChangePassword.text"));    // NOI18N
        btnChangePassword.setToolTipText(org.openide.util.NbBundle.getMessage(
                PasswordOptionsDialog.class,
                "PasswordOptionsDialog.btnChangePassword.tooltip")); // NOI18N
        btnChangePassword.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    btnChangePasswordActionPerformed(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        add(btnChangePassword, gridBagConstraints);

        lblDialogDescription.setText(org.openide.util.NbBundle.getMessage(
                PasswordOptionsDialog.class,
                "PasswordOptionsDialog.lblDialogDescription.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 10, 4);
        add(lblDialogDescription, gridBagConstraints);

        lblNewPasswordHints.setFont(new java.awt.Font("Ubuntu Sans", 0, 12)); // NOI18N
        lblNewPasswordHints.setHorizontalAlignment(javax.swing.SwingConstants.TRAILING);
        lblNewPasswordHints.setText(org.openide.util.NbBundle.getMessage(
                PasswordOptionsDialog.class,
                "PasswordOptionsDialog.lblNewPasswordHints.text"));           // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 0, 4);
        add(lblNewPasswordHints, gridBagConstraints);
    }                                                                         // </editor-fold>//GEN-END:initComponents

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void btnChangePasswordActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_btnChangePasswordActionPerformed
        SwingUtilities.invokeLater(new Runnable() {

                @Override
                public void run() {
                    final JFrame mainWindow = ComponentRegistry.getRegistry().getMainWindow();

                    final char[] pwdOld = pwdOldPassword.getPassword();
                    final char[] pwdNew = pwdNewPassword.getPassword();
                    final char[] pwdAgain = pwdPasswordAgain.getPassword();

                    if ((pwdOld.length == 0)
                                || (pwdNew.length == 0)
                                || (pwdAgain.length == 0)) {
                        JOptionPane.showMessageDialog(
                            mainWindow,
                            org.openide.util.NbBundle.getMessage(
                                PasswordOptionsDialog.class,
                                "PasswordOptionsDialog.btnChangePasswordActionPerformed().missingInputError.message"), // NOI18N
                            org.openide.util.NbBundle.getMessage(
                                PasswordOptionsDialog.class,
                                "PasswordOptionsDialog.btnChangePasswordActionPerformed().missingInputError.title"), // NOI18N
                            JOptionPane.ERROR_MESSAGE);
                    } else if (!Arrays.equals(pwdNew, pwdAgain)) {
                        JOptionPane.showMessageDialog(
                            mainWindow,
                            org.openide.util.NbBundle.getMessage(
                                PasswordOptionsDialog.class,
                                "PasswordOptionsDialog.btnChangePasswordActionPerformed().passwordsDifferentError.message"), // NOI18N
                            org.openide.util.NbBundle.getMessage(
                                PasswordOptionsDialog.class,
                                "PasswordOptionsDialog.btnChangePasswordActionPerformed().passwordsDifferentError.title"), // NOI18N
                            JOptionPane.ERROR_MESSAGE);

                        pwdNewPassword.setText("");
                        pwdPasswordAgain.setText("");
                    } else {
                        try {
                            final ConnectionProxy proxy = SessionManager.getProxy();
                            final ConnectionSession session = SessionManager.getSession();

                            final boolean success = proxy.changePassword(
                                    session.getUser(),
                                    String.valueOf(pwdOld),
                                    String.valueOf(pwdNew),
                                    getConnectionContext());

                            if (success) {
                                JOptionPane.showMessageDialog(
                                    mainWindow,
                                    org.openide.util.NbBundle.getMessage(
                                        PasswordOptionsDialog.class,
                                        "PasswordOptionsDialog.btnChangePasswordActionPerformed().passwordOK.message"), // NOI18N
                                    org.openide.util.NbBundle.getMessage(
                                        PasswordOptionsDialog.class,
                                        "PasswordOptionsDialog.btnChangePasswordActionPerformed().passwordOK.title"), // NOI18N
                                    JOptionPane.INFORMATION_MESSAGE);
                            } else {
                                JOptionPane.showMessageDialog(
                                    mainWindow,
                                    org.openide.util.NbBundle.getMessage(
                                        PasswordOptionsDialog.class,
                                        "PasswordOptionsDialog.btnChangePasswordActionPerformed().changePasswordError.message"), // NOI18N
                                    org.openide.util.NbBundle.getMessage(
                                        PasswordOptionsDialog.class,
                                        "PasswordOptionsDialog.btnChangePasswordActionPerformed().changePasswordError.title"), // NOI18N
                                    JOptionPane.ERROR_MESSAGE);
                            }

                            clearPwdFields();
                        } catch (final PasswordCheckException exp) {
                            JOptionPane.showMessageDialog(
                                mainWindow,
                                exp.getMessage(),
                                org.openide.util.NbBundle.getMessage(
                                    PasswordOptionsDialog.class,
                                    "PasswordOptionsDialog.btnChangePasswordActionPerformed().error.title"), // NOI18N
                                JOptionPane.ERROR_MESSAGE);
                        } catch (final Exception exp) {
                            final Throwable lastCause = getLastCause(exp);

                            if (lastCause instanceof PasswordCheckException) {
                                JOptionPane.showMessageDialog(
                                    mainWindow,
                                    lastCause.getMessage(),
                                    org.openide.util.NbBundle.getMessage(
                                        PasswordOptionsDialog.class,
                                        "PasswordOptionsDialog.btnChangePasswordActionPerformed().error.title"), // NOI18N
                                    JOptionPane.ERROR_MESSAGE);
                            } else {
                                LOG.error("an error occurred while changing the password", exp);
                                JOptionPane.showMessageDialog(
                                    mainWindow,
                                    exp.getMessage(),
                                    org.openide.util.NbBundle.getMessage(
                                        PasswordOptionsDialog.class,
                                        "PasswordOptionsDialog.btnChangePasswordActionPerformed().error.title"), // NOI18N
                                    JOptionPane.ERROR_MESSAGE);
                            }
                        }
                    }
                }
            });
    }                                 //GEN-LAST:event_btnChangePasswordActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void pwdNewPasswordKeyTyped(final java.awt.event.KeyEvent evt) { //GEN-FIRST:event_pwdNewPasswordKeyTyped
        EventQueue.invokeLater(new Thread() {

                @Override
                public void run() {
                    final char[] password = pwdNewPassword.getPassword();
                    boolean digit = false;
                    boolean letter = false;
                    boolean special = false;

                    for (int i = 0; i < password.length; ++i) {
                        final char c = password[i];
                        if (Character.isDigit(c)) {
                            digit = true;
                        } else if (Character.isAlphabetic(c)) {
                            letter = true;
                        } else {
                            // all characters, which are not a letter or a digit are special characters
                            special = true;
                        }
                    }

                    String hintText = "";

                    if (password.length >= 8) {
                        hintText += "<html><span style=\"color:green;\">"
                                    + NbBundle.getMessage(
                                        PasswordOptionsDialog.class,
                                        "PasswordOptionsDialog.lblNewPasswordHints.amount") + "</span>";
                    } else {
                        hintText += "<html>"
                                    + NbBundle.getMessage(
                                        PasswordOptionsDialog.class,
                                        "PasswordOptionsDialog.lblNewPasswordHints.amount");
                    }

                    if (letter) {
                        hintText += "<span style=\"color:green;\"> "
                                    + NbBundle.getMessage(
                                        PasswordOptionsDialog.class,
                                        "PasswordOptionsDialog.lblNewPasswordHints.letter") + "</span>";
                    } else {
                        hintText += " "
                                    + NbBundle.getMessage(
                                        PasswordOptionsDialog.class,
                                        "PasswordOptionsDialog.lblNewPasswordHints.letter");
                    }

                    if (digit) {
                        hintText += "<span style=\"color:green;\"> "
                                    + NbBundle.getMessage(
                                        PasswordOptionsDialog.class,
                                        "PasswordOptionsDialog.lblNewPasswordHints.digit") + "</span>";
                    } else {
                        hintText += " "
                                    + NbBundle.getMessage(
                                        PasswordOptionsDialog.class,
                                        "PasswordOptionsDialog.lblNewPasswordHints.digit");
                    }

                    if (special) {
                        hintText += "<span style=\"color:green;\"> "
                                    + NbBundle.getMessage(
                                        PasswordOptionsDialog.class,
                                        "PasswordOptionsDialog.lblNewPasswordHints.special") + "</span>";
                    } else {
                        hintText += " "
                                    + NbBundle.getMessage(
                                        PasswordOptionsDialog.class,
                                        "PasswordOptionsDialog.lblNewPasswordHints.special");
                    }

                    lblNewPasswordHints.setText(hintText);
                }
            });
    } //GEN-LAST:event_pwdNewPasswordKeyTyped

    /**
     * DOCUMENT ME!
     *
     * @param   ex  DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    private Throwable getLastCause(final Exception ex) {
        Throwable lastCause = ex;

        while ((lastCause != null) && (lastCause.getCause() != null)) {
            lastCause = lastCause.getCause();
        }

        return lastCause;
    }

    @Override
    public void update() {
        this.clearPwdFields();
    }

    /**
     * Returns tooltip text.
     *
     * @return  tooltip text
     */
    @Override
    public String getTooltip() {
        return org.openide.util.NbBundle.getMessage(
                PasswordOptionsDialog.class,
                "PasswordOptionsDialog.tooltip"); // NOI18N
    }

    @Override
    public ConnectionContext getConnectionContext() {
        return connectionContext;
    }
}
