/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
package Sirius.navigator.ui.tree.postfilter;

import Sirius.server.middleware.types.Node;

import java.util.ArrayList;
import java.util.Collection;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/**
 * DOCUMENT ME!
 *
 * @author   thorsten
 * @version  $Revision$, $Date$
 */
//@ServiceProvider(service = PostFilterGUI.class)
public class ExampleCommonPostFilterGUI extends AbstractPostFilterGUI {

    //~ Instance fields --------------------------------------------------------

    private ArrayList<PostFilterListener> pfListeners = new ArrayList<PostFilterListener>();
    private PostFilter filter = new PostFilter() {

            @Override
            public Integer getFilterChainOrderKeyPrio() {
                return 1000;
            }

            @Override
            public Collection<Node> filter(final Collection<Node> input) {
                if ((input != null) && (input.size() > (Integer)(spiLimit.getValue()))) {
                    final ArrayList<Node> ret = new ArrayList<Node>();
                    int i = 0;
                    final int size = (Integer)(spiLimit.getValue());
                    for (final Node n : input) {
                        if (i < (size)) {
                            ret.add(n);
                            i++;
                        } else {
                            break;
                        }
                    }
                    return ret;
                } else {
                    return input;
                }
            }
        };

    private ChangeListener cl = new ChangeListener() {

            @Override
            public void stateChanged(final ChangeEvent e) {
                firePostFilterChanged();
            }
        };

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JSpinner spiLimit;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates new form ExamplePostFilterGUI.
     */
    public ExampleCommonPostFilterGUI() {
        initComponents();
    }

    //~ Methods ----------------------------------------------------------------

    @Override
    public void initializeFilter(final Collection<Node> nodes) {
        spiLimit.getModel().removeChangeListener(cl);
        spiLimit.setValue(nodes.size());
        spiLimit.getModel().addChangeListener(cl);
    }

    @Override
    public void adjustFilter(final Collection<Node> nodes) {
        initializeFilter(nodes);
    }

    @Override
    public boolean canHandle(final Collection<Node> nodes) {
        return true;
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public PostFilter getFilter() {
        return filter;
    }

    @Override
    public Integer getDisplayOrderKeyPrio() {
        return 0;
    }

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        spiLimit = new javax.swing.JSpinner();
        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();

        spiLimit.setVerifyInputWhenFocusTarget(false);

        org.openide.awt.Mnemonics.setLocalizedText(
            jLabel1,
            org.openide.util.NbBundle.getMessage(
                ExampleCommonPostFilterGUI.class,
                "ExampleCommonPostFilterGUI.jLabel1.text")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(
            jLabel2,
            org.openide.util.NbBundle.getMessage(
                ExampleCommonPostFilterGUI.class,
                "ExampleCommonPostFilterGUI.jLabel2.text")); // NOI18N

        jLabel3.setForeground(new java.awt.Color(102, 102, 102));
        org.openide.awt.Mnemonics.setLocalizedText(
            jLabel3,
            org.openide.util.NbBundle.getMessage(
                ExampleCommonPostFilterGUI.class,
                "ExampleCommonPostFilterGUI.jLabel3.text")); // NOI18N

        final javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING).addGroup(
                layout.createSequentialGroup().addContainerGap().addGroup(
                    layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING).addComponent(jLabel3)
                                .addComponent(jLabel2).addGroup(
                        layout.createSequentialGroup().addComponent(
                            spiLimit,
                            javax.swing.GroupLayout.PREFERRED_SIZE,
                            68,
                            javax.swing.GroupLayout.PREFERRED_SIZE).addPreferredGap(
                            javax.swing.LayoutStyle.ComponentPlacement.RELATED).addComponent(jLabel1))).addContainerGap(
                    67,
                    Short.MAX_VALUE)));
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING).addGroup(
                layout.createSequentialGroup().addContainerGap().addComponent(jLabel2).addPreferredGap(
                    javax.swing.LayoutStyle.ComponentPlacement.RELATED).addGroup(
                    layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE).addComponent(
                        spiLimit,
                        javax.swing.GroupLayout.PREFERRED_SIZE,
                        javax.swing.GroupLayout.DEFAULT_SIZE,
                        javax.swing.GroupLayout.PREFERRED_SIZE).addComponent(jLabel1)).addPreferredGap(
                    javax.swing.LayoutStyle.ComponentPlacement.UNRELATED).addComponent(jLabel3).addContainerGap(
                    30,
                    Short.MAX_VALUE)));
    } // </editor-fold>//GEN-END:initComponents

    @Override
    public String getTitle() {
        return "Erstes Beispiel";
    }
}
