/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
package Sirius.navigator.ui.tree.postfilter;

import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.Node;

import java.util.ArrayList;
import java.util.Collection;

import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

import de.cismet.cids.navigator.utils.ClassCacheMultiple;

import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;

/**
 * DOCUMENT ME!
 *
 * @author   thorsten
 * @version  $Revision$, $Date$
 */
//@ServiceProvider(service = PostFilterGUI.class)
public class ExampleFlurstueckPostFilterGUI extends AbstractPostFilterGUI implements ConnectionContextStore {

    //~ Instance fields --------------------------------------------------------

    DocumentListener dl = new DocumentListener() {

            @Override
            public void insertUpdate(final DocumentEvent e) {
                firePostFilterChanged();
            }

            @Override
            public void removeUpdate(final DocumentEvent e) {
                firePostFilterChanged();
            }

            @Override
            public void changedUpdate(final DocumentEvent e) {
                firePostFilterChanged();
            }
        };

    PostFilter f = new PostFilter() {

            @Override
            public Integer getFilterChainOrderKeyPrio() {
                return 1001;
            }

            @Override
            public Collection<Node> filter(final Collection<Node> input) {
                if (txtRegEx.getText().equals("")) {
                    return input;
                } else {
                    final ArrayList<Node> ret = new ArrayList<>();
                    for (final Node n : input) {
                        if (n.getClassId() == fstck.getId()) {
                            if (n.getName().contains(txtRegEx.getText())) {
                                ret.add(n);
                            }
                        } else {
                            ret.add(n);
                        }
                    }
                    return ret;
                }
            }
        };

    MetaClass fstck;
    private ConnectionContext connectionContext = ConnectionContext.createDummy();

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTextField txtRegEx;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates new form ExampleFlurstueckPostFilterGUI.
     */
    public ExampleFlurstueckPostFilterGUI() {
    }

    //~ Methods ----------------------------------------------------------------

    @Override
    public void initWithConnectionContext(final ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
        initComponents();
        fstck = ClassCacheMultiple.getMetaClass("WUNDA_BLAU", "ALKIS_LANDPARCEL", getConnectionContext());
    }

    @Override
    public void initializeFilter(final Collection<Node> nodes) {
        txtRegEx.getDocument().removeDocumentListener(dl);
        txtRegEx.setText("");
        txtRegEx.getDocument().addDocumentListener(dl);
    }

    @Override
    public void adjustFilter(final Collection<Node> nodes) {
    }

    @Override
    public boolean canHandle(final Collection<Node> nodes) {
        if (fstck != null) {
            for (final Node n : nodes) {
                if (n.getClassId() == fstck.getId()) {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public String getTitle() {
        return "Flurstückfilter";
    }

    @Override
    public PostFilter getFilter() {
        return f;
    }

    @Override
    public Integer getDisplayOrderKeyPrio() {
        return 100;
    }

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        txtRegEx = new javax.swing.JTextField();

        txtRegEx.setText(org.openide.util.NbBundle.getMessage(
                ExampleFlurstueckPostFilterGUI.class,
                "ExampleFlurstueckPostFilterGUI.txtRegEx.text")); // NOI18N
        txtRegEx.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    txtRegExActionPerformed(evt);
                }
            });

        final javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING).addGroup(
                layout.createSequentialGroup().addGap(45, 45, 45).addComponent(
                    txtRegEx,
                    javax.swing.GroupLayout.PREFERRED_SIZE,
                    277,
                    javax.swing.GroupLayout.PREFERRED_SIZE).addContainerGap(78, Short.MAX_VALUE)));
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING).addGroup(
                layout.createSequentialGroup().addGap(33, 33, 33).addComponent(
                    txtRegEx,
                    javax.swing.GroupLayout.PREFERRED_SIZE,
                    javax.swing.GroupLayout.DEFAULT_SIZE,
                    javax.swing.GroupLayout.PREFERRED_SIZE).addContainerGap(35, Short.MAX_VALUE)));
    } // </editor-fold>//GEN-END:initComponents

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void txtRegExActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_txtRegExActionPerformed
    }                                                                            //GEN-LAST:event_txtRegExActionPerformed

    @Override
    public ConnectionContext getConnectionContext() {
        return connectionContext;
    }
}
