/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
/*
 * TitleBar.java
 *
 * Created on 18. M\u00E4rz 2004, 16:33
 */
package Sirius.navigator.ui.widget;

import java.awt.*;

import javax.swing.*;

/**
 * DOCUMENT ME!
 *
 * @author   pascal
 * @version  $Revision$, $Date$
 */
public class TitleBar extends javax.swing.JPanel {

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel iconLabel;
    private javax.swing.JLabel titleLabel;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates new form TitleBar.
     */
    public TitleBar() {
        initComponents();
    }

    /**
     * Creates a new TitleBar object.
     *
     * @param  title  DOCUMENT ME!
     * @param  icon   DOCUMENT ME!
     */
    public TitleBar(final String title, final Icon icon) {
        this();

        this.setTitle(title);
        this.setIcon(icon);
    }

    //~ Methods ----------------------------------------------------------------

    @Override
    protected void paintComponent(final Graphics g) {
        final Color left = this.getForeground();
        final Color right = this.getBackground();

        final int w = getWidth();
        final int h = getHeight();
        final Graphics2D g2d = (Graphics2D)(g);
        g2d.setPaint(new GradientPaint(0, 0, left, w, h, right, true));
        g2d.fill(new Rectangle(0, 0, w, h));
    }

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        iconLabel = new javax.swing.JLabel();
        titleLabel = new javax.swing.JLabel();

        setForeground(javax.swing.UIManager.getDefaults().getColor("CheckBoxMenuItem.selectionBackground"));
        setLayout(new java.awt.GridBagLayout());
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        add(iconLabel, gridBagConstraints);

        titleLabel.setForeground(new java.awt.Color(255, 255, 255));
        titleLabel.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        titleLabel.setText(org.openide.util.NbBundle.getMessage(TitleBar.class, "TitleBar.titleLabel.text")); // NOI18N
        titleLabel.setHorizontalTextPosition(javax.swing.SwingConstants.LEFT);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        add(titleLabel, gridBagConstraints);
    }                                                                                                         // </editor-fold>//GEN-END:initComponents

    /**
     * Getter for property icon.
     *
     * @return  Value of property icon.
     */
    public javax.swing.Icon getIcon() {
        return this.iconLabel.getIcon();
    }

    /**
     * Setter for property icon.
     *
     * @param  icon  New value of property icon.
     */
    public void setIcon(final javax.swing.Icon icon) {
        this.iconLabel.setIcon(icon);
    }

    /**
     * Getter for property title.
     *
     * @return  Value of property title.
     */
    public String getTitle() {
        return this.titleLabel.getText();
    }

    /**
     * Setter for property title.
     *
     * @param  title  New value of property title.
     */
    public void setTitle(final String title) {
        this.titleLabel.setText(title);
    }

    /**
     * Getter for property titleColor.
     *
     * @return  Value of property titleColor.
     */
    public java.awt.Color getTitleColor() {
        return this.titleLabel.getForeground();
    }

    /**
     * Setter for property titleColor.
     *
     * @param  titleColor  New value of property titleColor.
     */
    public void setTitleColor(final java.awt.Color titleColor) {
        this.titleLabel.setForeground(titleColor);
    }

    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    public JLabel getIconLabel() {
        return iconLabel;
    }

    /**
     * DOCUMENT ME!
     *
     * @param  iconLabel  DOCUMENT ME!
     */
    public void setIconLabel(final JLabel iconLabel) {
        this.iconLabel = iconLabel;
    }

    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    public JLabel getTitleLabel() {
        return titleLabel;
    }

    /**
     * DOCUMENT ME!
     *
     * @param  titleLabel  DOCUMENT ME!
     */
    public void setTitleLabel(final JLabel titleLabel) {
        this.titleLabel = titleLabel;
    }
}
