/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
package de.cismet.cids.client.tools;

import Sirius.navigator.ui.ComponentRegistry;
import Sirius.navigator.ui.DescriptionPane;

import Sirius.server.middleware.types.Node;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import javax.swing.SwingWorker;

/**
 * DOCUMENT ME!
 *
 * @author   jruiz
 * @version  $Revision$, $Date$
 */
public class ObjectRendererDialog extends javax.swing.JDialog {

    //~ Instance fields --------------------------------------------------------

    private final transient org.apache.log4j.Logger LOG = org.apache.log4j.Logger.getLogger(ObjectRendererDialog.class);

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel jLabel1;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JSplitPane jSplitPane1;
    private javax.swing.JTree jTree1;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates new form RendererDialog.
     *
     * @param  descriptionPane  DOCUMENT ME!
     */
    public ObjectRendererDialog(final DescriptionPane descriptionPane) {
        initComponents();
        jPanel2.add(descriptionPane);
    }

    /**
     * Creates new form RendererDialog.
     *
     * @param  parent           DOCUMENT ME!
     * @param  modal            DOCUMENT ME!
     * @param  descriptionPane  DOCUMENT ME!
     */
    public ObjectRendererDialog(final java.awt.Frame parent,
            final boolean modal,
            final DescriptionPane descriptionPane) {
        super(parent, modal);
        initComponents();
        jPanel2.add(descriptionPane);
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * DOCUMENT ME!
     *
     * @param  nodes  DOCUMENT ME!
     */
    public void setNodes(final Node[] nodes) {
        if ((nodes == null) || (nodes.length == 0)) {
            ComponentRegistry.getRegistry().getSearchResultsTree().clear();
        } else {
            ComponentRegistry.getRegistry()
                    .getSearchResultsTree()
                    .setResultNodes(nodes, false, new PropertyChangeListener() {

                            @Override
                            public void propertyChange(final PropertyChangeEvent evt) {
                                if (!(evt.getSource() instanceof SwingWorker)
                                    || !"state".equalsIgnoreCase(evt.getPropertyName())) {
                                    return;
                                }

                                if (SwingWorker.StateValue.DONE.equals(evt.getNewValue())) {
                                    ComponentRegistry.getRegistry().getSearchResultsTree().setSelectionRow(0);
                                }
                            }
                        });
        }
    }

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jSplitPane1 = new javax.swing.JSplitPane();
        jPanel1 = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        jScrollPane2 = new javax.swing.JScrollPane();
        jTree1 = ComponentRegistry.getRegistry().getSearchResultsTree();
        jPanel2 = new javax.swing.JPanel();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle(org.openide.util.NbBundle.getMessage(ObjectRendererDialog.class, "ObjectRendererDialog.title")); // NOI18N

        jSplitPane1.setDividerLocation(250);

        jPanel1.setLayout(new java.awt.GridBagLayout());

        org.openide.awt.Mnemonics.setLocalizedText(
            jLabel1,
            org.openide.util.NbBundle.getMessage(ObjectRendererDialog.class, "ObjectRendererDialog.jLabel1.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        jPanel1.add(jLabel1, gridBagConstraints);

        jScrollPane2.setMinimumSize(new java.awt.Dimension(200, 23));
        jScrollPane2.setPreferredSize(new java.awt.Dimension(200, 342));
        jScrollPane2.setViewportView(jTree1);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 5, 5);
        jPanel1.add(jScrollPane2, gridBagConstraints);

        jSplitPane1.setLeftComponent(jPanel1);

        jPanel2.setLayout(new java.awt.BorderLayout());
        jSplitPane1.setRightComponent(jPanel2);

        getContentPane().add(jSplitPane1, java.awt.BorderLayout.CENTER);

        pack();
    } // </editor-fold>//GEN-END:initComponents
}
