/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
package de.cismet.cids.client.tools;

/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/

import Sirius.navigator.connection.Connection;
import Sirius.navigator.connection.ConnectionFactory;
import Sirius.navigator.connection.ConnectionInfo;
import Sirius.navigator.connection.ConnectionSession;
import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.connection.proxy.ConnectionProxy;
import Sirius.navigator.ui.dialog.LoginDialog;

import Sirius.server.newuser.UserException;

import org.apache.log4j.Logger;

import org.jdesktop.swingx.JXErrorPane;
import org.jdesktop.swingx.error.ErrorInfo;

import java.io.BufferedInputStream;
import java.io.FileInputStream;

import java.net.URL;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;

import javax.swing.DefaultComboBoxModel;
import javax.swing.SwingWorker;

import de.cismet.cids.server.actions.PasswordSwitcherAdminAction;
import de.cismet.cids.server.actions.ServerActionParameter;

import de.cismet.connectioncontext.AbstractConnectionContext;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextProvider;

import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.log4jquickconfig.Log4JQuickConfig;

/*
 * Copyright (C) 2013 cismet GmbH
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * DOCUMENT ME!
 *
 * @author   jruiz
 * @version  $Revision$, $Date$
 */
public class PasswordSwitcherAdminDialog extends javax.swing.JDialog implements ConnectionContextProvider {

    //~ Static fields/initializers ---------------------------------------------

    private static final String LABEL_RECOVERY_COUNTER = "Passwort wiederhergestellt in <sec> Sekunden.";
    private static final String LABEL_CHANGE_BUTTON = "Admin-Passwort setzen";
    private static final String REPLACE_RECOVERY_COUNTER = "<sec>";
    private static final int RECOVERY_TIMER = 10000;

    private static final Logger LOG = Logger.getLogger(PasswordSwitcherAdminDialog.class);

    //~ Instance fields --------------------------------------------------------

    private final Timer timer = new Timer();
    private String username = null;
    private CountDownTask countDownTask;

    private final ConnectionContext connectionContext = ConnectionContext.createDummy();

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton btnChangePassword;
    private javax.swing.JButton btnClose;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JTextField txtUsername;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates new form AdminPasswordChangerDialog.
     *
     * @param  parent  DOCUMENT ME!
     * @param  modal   DOCUMENT ME!
     */
    public PasswordSwitcherAdminDialog(final java.awt.Frame parent, final boolean modal) {
        super(parent, modal);
        initComponents();
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jPanel1 = new javax.swing.JPanel();
        jPanel2 = new javax.swing.JPanel();
        txtUsername = new javax.swing.JTextField();
        jLabel2 = new javax.swing.JLabel();
        btnChangePassword = new javax.swing.JButton();
        jLabel1 = new javax.swing.JLabel();
        jPanel3 = new javax.swing.JPanel();
        btnClose = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.DO_NOTHING_ON_CLOSE);
        setTitle(org.openide.util.NbBundle.getMessage(
                PasswordSwitcherAdminDialog.class,
                "PasswordSwitcherAdminDialog.title")); // NOI18N
        setResizable(false);
        getContentPane().setLayout(new java.awt.GridBagLayout());

        jPanel1.setLayout(new java.awt.BorderLayout());

        jPanel2.setLayout(new java.awt.GridBagLayout());

        txtUsername.setText(org.openide.util.NbBundle.getMessage(
                PasswordSwitcherAdminDialog.class,
                "PasswordSwitcherAdminDialog.txtUsername.text")); // NOI18N
        txtUsername.setMinimumSize(new java.awt.Dimension(150, 27));
        txtUsername.setPreferredSize(new java.awt.Dimension(150, 27));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        jPanel2.add(txtUsername, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(
            jLabel2,
            org.openide.util.NbBundle.getMessage(
                PasswordSwitcherAdminDialog.class,
                "PasswordSwitcherAdminDialog.jLabel2.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 10);
        jPanel2.add(jLabel2, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(btnChangePassword, LABEL_CHANGE_BUTTON);
        btnChangePassword.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    btnChangePasswordActionPerformed(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(10, 0, 10, 0);
        jPanel2.add(btnChangePassword, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(
            jLabel1,
            org.openide.util.NbBundle.getMessage(
                PasswordSwitcherAdminDialog.class,
                "PasswordSwitcherAdminDialog.jLabel1.text")); // NOI18N
        jLabel1.setMinimumSize(new java.awt.Dimension(300, 70));
        jLabel1.setPreferredSize(new java.awt.Dimension(300, 70));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 10, 0);
        jPanel2.add(jLabel1, gridBagConstraints);

        jPanel1.add(jPanel2, java.awt.BorderLayout.CENTER);

        jPanel3.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.RIGHT));

        org.openide.awt.Mnemonics.setLocalizedText(
            btnClose,
            org.openide.util.NbBundle.getMessage(
                PasswordSwitcherAdminDialog.class,
                "PasswordSwitcherAdminDialog.btnClose.text")); // NOI18N
        btnClose.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    btnCloseActionPerformed(evt);
                }
            });
        jPanel3.add(btnClose);

        jPanel1.add(jPanel3, java.awt.BorderLayout.SOUTH);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        getContentPane().add(jPanel1, gridBagConstraints);

        pack();
    } // </editor-fold>//GEN-END:initComponents

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void btnCloseActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_btnCloseActionPerformed
        System.exit(0);
    }                                                                            //GEN-LAST:event_btnCloseActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void btnChangePasswordActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_btnChangePasswordActionPerformed
        username = txtUsername.getText().trim();

        switchStarted();

        new SwingWorker<Object, Object>() {

                @Override
                protected Object doInBackground() throws Exception {
                    switchPassword(username);
                    return null;
                }

                @Override
                protected void done() {
                    try {
                        get();
                        switchFinished();
                    } catch (final Exception ex) {
                        switchFinished();
                        LOG.error("error while executing swingworker", ex);
                        final ErrorInfo errorInfo = new ErrorInfo(
                                "Fehler",
                                "Fehler beim Switchen des Passworts: "
                                        + ex.getCause().getMessage(),
                                null,
                                null,
                                ex,
                                Level.ALL,
                                null);
                        JXErrorPane.showDialog(null, errorInfo);
                    }
                }
            }.execute();
    } //GEN-LAST:event_btnChangePasswordActionPerformed

    /**
     * DOCUMENT ME!
     */
    private void switchStarted() {
        btnChangePassword.setEnabled(false);
        btnClose.setEnabled(false);
        txtUsername.setEditable(false);

        if (countDownTask != null) {
            countDownTask.cancel();
        }
        countDownTask = new CountDownTask(RECOVERY_TIMER / 1000);
        timer.scheduleAtFixedRate(countDownTask, 0, 1000);
    }

    /**
     * DOCUMENT ME!
     */
    private void switchFinished() {
        countDownTask.cancel();
        btnChangePassword.setEnabled(true);
        btnChangePassword.setText(LABEL_CHANGE_BUTTON);
        btnClose.setEnabled(true);
        txtUsername.setEditable(true);
    }

    /**
     * DOCUMENT ME!
     *
     * @param  counter  DOCUMENT ME!
     */
    private void timerUpdate(final int counter) {
        btnChangePassword.setText(LABEL_RECOVERY_COUNTER.replaceFirst(
                REPLACE_RECOVERY_COUNTER,
                Integer.toString(counter)));
    }

    /**
     * DOCUMENT ME!
     *
     * @param  args  the command line arguments
     */
    public static void main(final String[] args) {
        Log4JQuickConfig.configure4LumbermillOnLocalhost();

        /* Create and display the dialog */
        java.awt.EventQueue.invokeLater(new Runnable() {

                @Override
                public void run() {
                    try {
                        final PasswordSwitcherAdminDialog dialog = new PasswordSwitcherAdminDialog(
                                new javax.swing.JFrame(),
                                true);
                        final String callServerUrl;
                        final boolean compressionEnabled;

                        if (args.length == 1) {
                            final String cfgFile = args[0];
                            final Properties properties = new Properties();
                            if ((cfgFile.indexOf("http://") == 0) || (cfgFile.indexOf("https://") == 0)
                                        || (cfgFile.indexOf("file:/") == 0)) {
                                properties.load(new URL(cfgFile).openStream());
                            } else {
                                properties.load(new BufferedInputStream(new FileInputStream(cfgFile)));
                            }
                            callServerUrl = properties.getProperty("callserverURL");
                            compressionEnabled = Boolean.parseBoolean(
                                    properties.getProperty("compressionEnabled", "true"));
                        } else {
                            callServerUrl = args[0];
                            compressionEnabled = (args.length > 2) && "compressionEnabled".equals(args[2]);
                        }

                        final ConnectionContext cc = ConnectionContext.create(
                                AbstractConnectionContext.Category.OTHER,
                                "PasswordSwitcher");

                        final Connection connection = ConnectionFactory.getFactory()
                                    .createConnection(
                                        "Sirius.navigator.connection.RESTfulConnection",
                                        callServerUrl,
                                        "Password Switcher",
                                        null,
                                        compressionEnabled,
                                        cc);
                        final ConnectionInfo connectionInfo = new ConnectionInfo();
                        connectionInfo.setCallserverURL(callServerUrl);
                        ConnectionSession connectionSession = null;

                        try {
                            connectionSession = ConnectionFactory.getFactory()
                                        .createSession(
                                                connection,
                                                connectionInfo,
                                                false,
                                                cc);
                        } catch (UserException uexp) {
                        }

                        final ConnectionProxy connectionProxy = ConnectionFactory.getFactory()
                                    .createProxy(
                                        "Sirius.navigator.connection.proxy.DefaultConnectionProxyHandler",
                                        connectionSession,
                                        cc);
                        SessionManager.init(connectionProxy);

                        final LoginDialog loginDialog = new LoginDialog(null, true, true);
                        StaticSwingTools.showDialog(loginDialog);

                        dialog.addWindowListener(new java.awt.event.WindowAdapter() {

                                @Override
                                public void windowClosing(final java.awt.event.WindowEvent e) {
                                    System.exit(0);
                                }
                            });
                        StaticSwingTools.showDialog(dialog);
                        System.exit(0);
                    } catch (final Exception ex) {
                        LOG.fatal("Fehler beim Starten des Password-Changer.", ex);
                        final ErrorInfo errorInfo = new ErrorInfo(
                                "Fehler",
                                "Fehler beim Starten des Password-Changer.",
                                null,
                                null,
                                ex,
                                Level.ALL,
                                null);
                        JXErrorPane.showDialog(null, errorInfo);
                        System.exit(1);
                    }
                }
            });
    }

    /**
     * DOCUMENT ME!
     *
     * @param   username  DOCUMENT ME!
     *
     * @throws  Exception  DOCUMENT ME!
     */
    private void switchPassword(final String username) throws Exception {
        final ServerActionParameter paramLoginName = new ServerActionParameter(
                PasswordSwitcherAdminAction.ParameterType.LOGIN_NAME.toString(),
                username);
        final ServerActionParameter paramRecoveryTimeout = new ServerActionParameter(
                PasswordSwitcherAdminAction.ParameterType.RECOVERY_TIMER.toString(),
                RECOVERY_TIMER);
        final Object ret = SessionManager.getProxy()
                    .executeTask(
                        PasswordSwitcherAdminAction.TASK_NAME,
                        SessionManager.getSession().getUser().getDomain(),
                        (Object)null,
                        getConnectionContext(),
                        paramLoginName,
                        paramRecoveryTimeout);

        if (ret instanceof Exception) {
            throw (Exception)ret;
        }
    }

    @Override
    public final ConnectionContext getConnectionContext() {
        return connectionContext;
    }

    //~ Inner Classes ----------------------------------------------------------

    /**
     * DOCUMENT ME!
     *
     * @version  $Revision$, $Date$
     */
    class CountDownTask extends TimerTask {

        //~ Instance fields ----------------------------------------------------

        int counter;

        //~ Constructors -------------------------------------------------------

        /**
         * Creates a new CountDownTask object.
         *
         * @param  startAt  DOCUMENT ME!
         */
        public CountDownTask(final int startAt) {
            counter = startAt;
        }

        //~ Methods ------------------------------------------------------------

        @Override
        public void run() {
            timerUpdate(--counter);
            if (counter <= 0) {
                cancel();
            }
        }
    }
}
