/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
/*
 * ArrayTitleAndControls.java
 *
 * Created on 25.02.2009, 12:19:03
 */
package de.cismet.cids.editors;

import Sirius.server.middleware.types.MetaClass;

import java.util.List;

import javax.swing.JList;

import de.cismet.cids.dynamics.CidsBean;

import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextProvider;

/**
 * DOCUMENT ME!
 *
 * @author   thorsten
 * @version  $Revision$, $Date$
 */
public class ArrayTitleAndControls extends javax.swing.JPanel implements ConnectionContextProvider {

    //~ Instance fields --------------------------------------------------------

    private MetaClass detailClass;
    private CidsBean cidsBean;
    private String arrayProperty;
    private JList jList;
    private final ConnectionContext connectionContext;
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton cmdAdd;
    private javax.swing.JButton cmdRemove;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JLabel lblTitle;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates a new ArrayTitleAndControls object.
     *
     * @param  title              DOCUMENT ME!
     * @param  detailClass        DOCUMENT ME!
     * @param  arrayProperty      DOCUMENT ME!
     * @param  jList              DOCUMENT ME!
     * @param  connectionContext  DOCUMENT ME!
     */
    public ArrayTitleAndControls(final String title,
            final MetaClass detailClass,
            final String arrayProperty,
            final JList jList,
            final ConnectionContext connectionContext) {
        super();
        this.connectionContext = connectionContext;
        this.jList = jList;
        initComponents();
        this.detailClass = detailClass;
        this.arrayProperty = arrayProperty;
        lblTitle.setText(title);
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    public MetaClass getDetailClass() {
        return detailClass;
    }

    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    public JList getJList() {
        return jList;
    }

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        jPanel2 = new javax.swing.JPanel();
        jPanel1 = new javax.swing.JPanel();
        cmdAdd = new javax.swing.JButton();
        cmdRemove = new javax.swing.JButton();
        jPanel3 = new javax.swing.JPanel();
        lblTitle = new javax.swing.JLabel();
        jLabel1 = new javax.swing.JLabel();

        setOpaque(false);
        setLayout(new java.awt.BorderLayout());

        jPanel2.setOpaque(false);
        jPanel2.setLayout(new java.awt.BorderLayout());

        jPanel1.setOpaque(false);
        jPanel1.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.RIGHT, 2, 2));

        cmdAdd.setIcon(new javax.swing.ImageIcon(getClass().getResource("/de/cismet/cids/editors/edit_add_mini.png"))); // NOI18N
        cmdAdd.setBorderPainted(false);
        cmdAdd.setMinimumSize(new java.awt.Dimension(16, 16));
        cmdAdd.setPreferredSize(new java.awt.Dimension(16, 16));
        cmdAdd.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    cmdAddActionPerformed(evt);
                }
            });
        jPanel1.add(cmdAdd);

        cmdRemove.setIcon(new javax.swing.ImageIcon(
                getClass().getResource("/de/cismet/cids/editors/edit_remove_mini.png"))); // NOI18N
        cmdRemove.setBorderPainted(false);
        cmdRemove.setMinimumSize(new java.awt.Dimension(16, 16));
        cmdRemove.setPreferredSize(new java.awt.Dimension(16, 16));
        cmdRemove.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    cmdRemoveActionPerformed(evt);
                }
            });
        jPanel1.add(cmdRemove);

        jPanel2.add(jPanel1, java.awt.BorderLayout.WEST);

        jPanel3.setOpaque(false);
        jPanel3.setLayout(new java.awt.BorderLayout());

        lblTitle.setText(org.openide.util.NbBundle.getMessage(
                ArrayTitleAndControls.class,
                "ArrayTitleAndControls.lblTitle.text")); // NOI18N
        jPanel3.add(lblTitle, java.awt.BorderLayout.EAST);

        jLabel1.setText("           ");
        jPanel3.add(jLabel1, java.awt.BorderLayout.CENTER);

        jPanel2.add(jPanel3, java.awt.BorderLayout.CENTER);

        add(jPanel2, java.awt.BorderLayout.PAGE_START);
    } // </editor-fold>//GEN-END:initComponents

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void cmdRemoveActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_cmdRemoveActionPerformed
        final Object o = jList.getSelectedValue();
        if ((o instanceof CidsBean) && (o != null)) {
            try {
                final int index = jList.getSelectedIndex();
                ((CidsBean)o).delete();

                if (jList.getModel().getSize() == 0) {
                    jList.setSelectedValue(null, false);
                } else if (index <= (jList.getModel().getSize() - 1)) {
                    jList.setSelectedIndex(index);
                } else {
                    jList.setSelectedIndex(jList.getModel().getSize() - 1);
                }
            } catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    } //GEN-LAST:event_cmdRemoveActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void cmdAddActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_cmdAddActionPerformed
        try {
            final CidsBean newOne = detailClass.getEmptyInstance(getConnectionContext()).getBean();

            final CidsBean sourcebean = (CidsBean)jList.getClientProperty(CidsObjectEditorFactory.CIDS_BEAN);
            final JList sourcelist = (JList)jList.getClientProperty(CidsObjectEditorFactory.SOURCE_LIST);
            if (sourcebean != null) {
                ((List)(sourcebean.getProperty(arrayProperty))).add(newOne);
            } else if ((sourcelist != null) && (sourcelist.getSelectedValue() != null)) {
                final CidsBean localSourceBean = (CidsBean)sourcelist.getSelectedValue();
                // Entferne den String bis zum ersten []
                final String subElement = arrayProperty.substring(arrayProperty.lastIndexOf("[]") + 2); // NOI18N
                ((List)(localSourceBean.getProperty(arrayProperty))).add(newOne);
            }
            jList.setSelectedValue(newOne, true);
        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }                                                                                                   //GEN-LAST:event_cmdAddActionPerformed

    @Override
    public ConnectionContext getConnectionContext() {
        return connectionContext;
    }
}
