/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
/*
 * DefaultCustomObjectEditor.java
 *
 * Created on 11.03.2009, 16:56:02
 */
package de.cismet.cids.editors;

import Sirius.server.localserver.attribute.ObjectAttribute;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaClassStore;
import Sirius.server.middleware.types.MetaObject;

import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.el.impl.ValueExpressionImpl;

import java.lang.reflect.Field;

import java.util.List;

import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.dynamics.DisposableCidsBeanStore;

import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;

/**
 * DOCUMENT ME!
 *
 * @author   thorsten
 * @version  $Revision$, $Date$
 */
public class DefaultCustomObjectEditor extends javax.swing.JPanel implements DisposableCidsBeanStore,
    ConnectionContextStore {

    //~ Static fields/initializers ---------------------------------------------

    private static final org.apache.log4j.Logger LOG = org.apache.log4j.Logger.getLogger(
            DefaultCustomObjectEditor.class);

    //~ Instance fields --------------------------------------------------------

    protected CidsBean cidsBean;
    private ConnectionContext connectionContext = ConnectionContext.createDummy();

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates new form DefaultCustomObjectEditor.
     */
    public DefaultCustomObjectEditor() {
    }

    //~ Methods ----------------------------------------------------------------

    @Override
    public void initWithConnectionContext(final ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
        initComponents();
    }

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        final javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    } // </editor-fold>//GEN-END:initComponents

    @Override
    public CidsBean getCidsBean() {
        return cidsBean;
    }

    @Override
    public synchronized void setCidsBean(final CidsBean cidsBean) {
        this.cidsBean = cidsBean;
        try {
            final BindingGroup bindingGroup = getBindingGroupFormChildClass();
            if (bindingGroup != null) {
                setMetaClassInformationToMetaClassStoreComponentsInBindingGroup(
                    bindingGroup,
                    cidsBean,
                    getConnectionContext());

                bindingGroup.unbind();
                bindingGroup.bind();
                boundAndReadyNotify();
            }
        } catch (final Exception e) {
            throw new RuntimeException("Bindingproblems occur", e); // NOI18N
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     *
     * @throws  NoSuchFieldException      DOCUMENT ME!
     * @throws  IllegalArgumentException  DOCUMENT ME!
     * @throws  IllegalAccessException    DOCUMENT ME!
     */
    private BindingGroup getBindingGroupFormChildClass() throws NoSuchFieldException,
        IllegalArgumentException,
        IllegalAccessException {
        if (this instanceof BindingGroupStore) {
            return ((BindingGroupStore)this).getBindingGroup();
        } else {
            final Field bindingGroupField;
            try {
                bindingGroupField = getClass().getDeclaredField("bindingGroup"); // NOI18N
            } catch (final Exception ex) {
                LOG.info("error while getting declaredField bindingGroup", ex);
                return null;
            }

            if (bindingGroupField != null) {
                bindingGroupField.setAccessible(true);
                return (BindingGroup)bindingGroupField.get(this);
            }
        }
        return null;
    }

    /**
     * DOCUMENT ME!
     *
     * @param  bindingGroup  DOCUMENT ME!
     * @param  cidsBean      DOCUMENT ME!
     */
    @Deprecated
    public static void setMetaClassInformationToMetaClassStoreComponentsInBindingGroup(final BindingGroup bindingGroup,
            final CidsBean cidsBean) {
        setMetaClassInformationToMetaClassStoreComponentsInBindingGroup(
            bindingGroup,
            cidsBean,
            ConnectionContext.createDeprecated());
    }

    /**
     * DOCUMENT ME!
     *
     * @param  bindingGroup       DOCUMENT ME!
     * @param  cidsBean           DOCUMENT ME!
     * @param  connectionContext  DOCUMENT ME!
     */
    public static void setMetaClassInformationToMetaClassStoreComponentsInBindingGroup(final BindingGroup bindingGroup,
            final CidsBean cidsBean,
            final ConnectionContext connectionContext) {
        final List<Binding> bindings = bindingGroup.getBindings();
        for (final Binding binding : bindings) {
            if (binding.getTargetObject() instanceof MetaClassStore) {
                // log.fatal("MetaClassStores gefunden");
                String expr = null;
                try {
                    final MetaClassStore mcs = (MetaClassStore)binding.getTargetObject();
                    final ELProperty p = (ELProperty)binding.getSourceProperty();
                    expr = getPropertyStringOutOfELProperty(p);
                    expr = expr.substring(2, expr.length() - 1);

                    final String domain = cidsBean.getMetaObject().getDomain();
                    int foreignClassId = cidsBean.getMetaObject().getMetaClass().getId();
                    ObjectAttribute oa;
                    while (expr.contains(".")) {
                        final MetaClass mc = CidsObjectEditorFactory.getMetaClass(
                                domain,
                                foreignClassId,
                                connectionContext);
                        final MetaObject mo = mc.getEmptyInstance(connectionContext);
                        expr = expr.substring(expr.indexOf(".") + 1); // NOI18N
                        final String fieldname = expr.contains(".") ? expr.substring(0, expr.indexOf(".")) : expr;
                        oa = mo.getAttributeByFieldName(fieldname);
                        foreignClassId = oa.getMai().getForeignKeyClassId();
                    }

                    final MetaClass foreignClass = CidsObjectEditorFactory.getMetaClass(
                            domain,
                            foreignClassId,
                            connectionContext);
                    mcs.setMetaClass(foreignClass);
                } catch (Exception e) {
                    LOG.error("Error during Bind: " + expr + " of " + cidsBean.getMetaObject().getMetaClass(), e);
                }
            }
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @param   p  DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     *
     * @throws  Exception  DOCUMENT ME!
     */
    private static String getPropertyStringOutOfELProperty(final ELProperty p) throws Exception {
        final Field expressionField = p.getClass().getDeclaredField("expression"); // NOI18N
        expressionField.setAccessible(true);

        final ValueExpressionImpl valueExpression = (ValueExpressionImpl)expressionField.get(p);
        return valueExpression.getExpressionString();
    }

    /**
     * DOCUMENT ME!
     */
    public void boundAndReadyNotify() {
    }

    @Override
    public void dispose() {
        try {
            final BindingGroup bindingGroup = getBindingGroupFormChildClass();
            if (bindingGroup != null) {
                bindingGroup.unbind();
            }
        } catch (final Exception ex) {
            throw new RuntimeException("Binding Problem!", ex); // NOI18N
        }
    }

    @Override
    public ConnectionContext getConnectionContext() {
        return connectionContext;
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    // End of variables declaration//GEN-END:variables
}
