/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package de.cismet.cids.editors;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.ui.ComponentRegistry;

import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaClassStore;
import Sirius.server.middleware.types.MetaObjectNode;

import lombok.Getter;
import lombok.Setter;

import org.apache.log4j.Logger;

import org.jdesktop.swingx.JXHyperlink;

import java.awt.event.ActionEvent;

import java.util.Collection;

import javax.swing.AbstractAction;
import javax.swing.JLabel;
import javax.swing.SwingWorker;

import de.cismet.cids.server.search.CidsServerSearch;

import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;

import de.cismet.layout.WrapLayout;

/**
 * DOCUMENT ME!
 *
 * @author   jruiz
 * @version  $Revision$, $Date$
 */
public class SearchLabelsFieldPanel extends javax.swing.JPanel implements ConnectionContextStore {

    //~ Static fields/initializers ---------------------------------------------

    private static final Logger LOG = Logger.getLogger(SearchLabelsFieldPanel.class);

    //~ Instance fields --------------------------------------------------------

    @Getter private ConnectionContext connectionContext = ConnectionContext.createDummy();
    @Getter @Setter private final CidsServerSearch search;
    @Getter @Setter private boolean hyperlink = false;

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel jPanel1;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates new form SearchLabelFieldPanel.
     */
    public SearchLabelsFieldPanel() {
        this(null, false);
    }

    /**
     * Creates a new SearchLabelsFieldPanel object.
     *
     * @param  search  DOCUMENT ME!
     */
    public SearchLabelsFieldPanel(final CidsServerSearch search) {
        this(search, false);
    }

    /**
     * Creates a new SearchLabelsFieldPanel object.
     *
     * @param  search     DOCUMENT ME!
     * @param  hyperlink  DOCUMENT ME!
     */
    public SearchLabelsFieldPanel(final CidsServerSearch search,
            final boolean hyperlink) {
        this.search = search;
        this.hyperlink = hyperlink;

        if (java.beans.Beans.isDesignTime()) {
            initComponents();
        }
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        final java.awt.GridBagConstraints gridBagConstraints;

        jPanel1 = new javax.swing.JPanel();

        setLayout(new java.awt.GridBagLayout());

        jPanel1.setOpaque(isOpaque());
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        add(jPanel1, gridBagConstraints);
        jPanel1.setLayout(new WrapLayout(WrapLayout.LEADING, 0, 5));
    } // </editor-fold>//GEN-END:initComponents

    @Override
    public void initWithConnectionContext(final ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;

        initComponents();
    }

    /**
     * DOCUMENT ME!
     */
    public void clear() {
        jPanel1.removeAll();
    }

    /**
     * DOCUMENT ME!
     */
    public void refresh() {
        clear();
        final CidsServerSearch search = getSearch();
        if (search != null) {
            jPanel1.add(new JLabel("<html><i>Ergebnisse werden gesucht..."));
            new SwingWorker<Collection<MetaObjectNode>, Object>() {

                    @Override
                    protected Collection<MetaObjectNode> doInBackground() throws Exception {
                        return (Collection<MetaObjectNode>)SessionManager.getProxy()
                                    .customServerSearch(search, getConnectionContext());
                    }

                    @Override
                    protected void done() {
                        clear();
                        try {
                            final Collection<MetaObjectNode> mons = get();
                            if (mons != null) {
                                for (final MetaObjectNode mon : mons) {
                                    if (mon != null) {
                                        final String name = mon.toString();
                                        if (hyperlink) {
                                            jPanel1.add(new JXHyperlink(new AbstractAction(name) {

                                                        @Override
                                                        public void actionPerformed(final ActionEvent e) {
                                                            ComponentRegistry.getRegistry()
                                                                    .getDescriptionPane()
                                                                    .gotoMetaObjectNode(mon, false);
                                                        }
                                                    }));
                                        } else {
                                            jPanel1.add(new JLabel(name));
                                        }
                                        jPanel1.add(new JLabel(", "));
                                    }
                                }
                                final int compCount = jPanel1.getComponentCount();
                                if (compCount > 0) {
                                    jPanel1.remove(compCount - 1);
                                } else {
                                    jPanel1.add(new JLabel("-"));
                                }
                            }
                        } catch (final Exception ex) {
                            LOG.error(ex, ex);
                            clear();
                            jPanel1.add(new JLabel("<html><i>[Fehler]"));
                        }
                        revalidate();
                        repaint();
                    }
                }.execute();
        }
    }
}
