/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
package de.cismet.cids.tools.metaobjectrenderer;

import com.vividsolutions.jts.geom.Geometry;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Graphics;

import javax.swing.JComponent;
import javax.swing.JPanel;

import de.cismet.tools.gui.CoolEditor;
import de.cismet.tools.gui.WrappedComponent;

/**
 * DOCUMENT ME!
 *
 * @author   dmeiers
 * @version  $Revision$, $Date$
 */
public class BlurredMapWrapper extends JPanel implements WrappedComponent {

    //~ Static fields/initializers ---------------------------------------------

    private static final org.apache.log4j.Logger log = org.apache.log4j.Logger.getLogger(CoolEditor.class);

    //~ Instance fields --------------------------------------------------------

    private JComponent originalComponent = null;
    // Variables declaration - do not modify
    private javax.swing.JPanel panEdit;
    private javax.swing.JPanel panFooter;
    private javax.swing.JPanel panTitleAndIcon;
    private JPanel panMap;
    private JPanel panContent;
    private de.cismet.cids.tools.metaobjectrenderer.BlurredMapCoolPanel pcpMain;
    // End of variables declaration

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates new form CoolEditor.
     */
    public BlurredMapWrapper() {
        super();
        initComponents();
        pcpMain.setPanContent(panEdit);
        pcpMain.setPanTitle(panTitleAndIcon);
        pcpMain.setPanMap(panMap);
        pcpMain.setPanInter(panFooter);
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">
    private void initComponents() {
        pcpMain = new de.cismet.cids.tools.metaobjectrenderer.BlurredMapCoolPanel();
        panEdit = new javax.swing.JPanel();
        panTitleAndIcon = new javax.swing.JPanel();
        panFooter = new javax.swing.JPanel();
        panMap = new JPanel();
        panContent = new JPanel();

        this.setLayout(new java.awt.BorderLayout());

        pcpMain.setLayout(new java.awt.BorderLayout());

        panEdit.setBorder(javax.swing.BorderFactory.createEmptyBorder(20, 20, 20, 20));
        panEdit.setOpaque(false);
        panEdit.setLayout(new java.awt.BorderLayout());
        pcpMain.add(panEdit, java.awt.BorderLayout.CENTER);

        panContent.setLayout(new BorderLayout());
        panContent.setOpaque(false);
        panEdit.add(panContent, BorderLayout.WEST);

        panMap.setLayout(new BorderLayout());
        panMap.setOpaque(false);
        panMap.setPreferredSize(new Dimension(100, 100));
        panEdit.add(panMap, BorderLayout.CENTER);

//        panTitleAndIcon.setBorder(javax.swing.BorderFactory.createEmptyBorder(20, 20, 20, 20));
        panTitleAndIcon.setOpaque(false);
        panTitleAndIcon.setLayout(new java.awt.BorderLayout());
        pcpMain.add(panTitleAndIcon, java.awt.BorderLayout.NORTH);

        panFooter.setBorder(javax.swing.BorderFactory.createEmptyBorder(20, 20, 20, 20));
        panFooter.setOpaque(false);
        panFooter.setLayout(new java.awt.BorderLayout());
        pcpMain.add(panFooter, java.awt.BorderLayout.SOUTH);

        add(pcpMain, java.awt.BorderLayout.CENTER);
    } // </editor-fold>

    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    public JPanel getPanEdit() {
        return panEdit;
    }

    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    public JPanel getPanFooter() {
        return panFooter;
    }

    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    public JPanel getPanTitleAndIcon() {
        return panTitleAndIcon;
    }

    @Override
    public JComponent getOriginalComponent() {
        return originalComponent;
    }

    /**
     * DOCUMENT ME!
     *
     * @param  originalComponent  DOCUMENT ME!
     */
    public void setOriginalComponent(final JComponent originalComponent) {
        this.originalComponent = originalComponent;
    }

    /**
     * DOCUMENT ME!
     *
     * @param  g  DOCUMENT ME!
     */
    public void setGeometry(final Geometry g) {
        pcpMain.setGeometry(g);
    }

    /**
     * DOCUMENT ME!
     *
     * @param  map  DOCUMENT ME!
     */
    public void setPanMap(final JComponent map) {
        pcpMain.setPanMap(panMap);
    }

    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    public JPanel getPanContent() {
        return panContent;
    }

    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    public JPanel getPanMap() {
        return panMap;
    }

    /**
     * DOCUMENT ME!
     *
     * @param  spinner  DOCUMENT ME!
     */
    public void setPanSpinner(final JComponent spinner) {
        pcpMain.setSpinner((JPanel)spinner);
    }

    @Override
    protected void paintComponent(final Graphics g) {
        super.paintComponent(g);
    }
}
