/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
package de.cismet.cids.utils.jasperreports;

import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.util.JRLoader;

import java.awt.Frame;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;

import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;

import de.cismet.cids.dynamics.CidsBean;

import de.cismet.tools.BrowserLauncher;

import de.cismet.tools.gui.StaticSwingTools;

/**
 * DOCUMENT ME!
 *
 * @version  $Revision$, $Date$
 */
public class ReportSwingWorker extends SwingWorker<Boolean, Object> {

    //~ Static fields/initializers ---------------------------------------------

    private static final org.apache.log4j.Logger LOG = org.apache.log4j.Logger.getLogger(ReportSwingWorker.class);
    private static final String FILE_EXTENSION = ".pdf";

    //~ Instance fields --------------------------------------------------------

// private Collection<CidsBean> cidsBeans;
// private String compiledReport;
    private final List<Collection<CidsBean>> cidsBeansList;
    private final List<String> compiledReportList;
    private final ReportSwingWorkerDialog dialog;
    private final boolean withDialog;
    private String directory;
    private HashMap parameters = new HashMap();
    private String filename = "report";

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates a new ReportSwingWorker object.
     *
     * @param  cidsBeansList       map DOCUMENT ME!
     * @param  compiledReportList  DOCUMENT ME!
     * @param  directory           DOCUMENT ME!
     */
    public ReportSwingWorker(final List<Collection<CidsBean>> cidsBeansList,
            final List<String> compiledReportList,
            final String directory) {
        this(cidsBeansList, compiledReportList, false, null, directory);
    }

    /**
     * Creates a new ReportSwingWorker object.
     *
     * @param  cidsBeans       DOCUMENT ME!
     * @param  compiledReport  DOCUMENT ME!
     * @param  directory       DOCUMENT ME!
     */
    public ReportSwingWorker(final Collection<CidsBean> cidsBeans,
            final String compiledReport,
            final String directory) {
        this(cidsBeans, compiledReport, false, null, directory);
    }

    /**
     * Creates a new ReportSwingWorker object.
     *
     * @param  cidsBeansList       DOCUMENT ME!
     * @param  compiledReportList  DOCUMENT ME!
     * @param  parent              DOCUMENT ME!
     * @param  directory           DOCUMENT ME!
     */
    public ReportSwingWorker(final List<Collection<CidsBean>> cidsBeansList,
            final List<String> compiledReportList,
            final Frame parent,
            final String directory) {
        this(cidsBeansList, compiledReportList, true, parent, directory);
    }

    /**
     * Creates a new ReportSwingWorker object.
     *
     * @param  cidsBeans       DOCUMENT ME!
     * @param  compiledReport  DOCUMENT ME!
     * @param  parent          DOCUMENT ME!
     * @param  directory       DOCUMENT ME!
     */
    public ReportSwingWorker(final Collection<CidsBean> cidsBeans,
            final String compiledReport,
            final Frame parent,
            final String directory) {
        this(cidsBeans, compiledReport, true, parent, directory);
    }

    /**
     * Creates a new ReportSwingWorker object.
     *
     * @param  cidsBeansList       DOCUMENT ME!
     * @param  compiledReportList  DOCUMENT ME!
     * @param  withDialog          DOCUMENT ME!
     * @param  parent              DOCUMENT ME!
     * @param  directory           DOCUMENT ME!
     */
    public ReportSwingWorker(final List<Collection<CidsBean>> cidsBeansList,
            final List<String> compiledReportList,
            final boolean withDialog,
            final Frame parent,
            final String directory) {
        this(cidsBeansList, compiledReportList, withDialog, parent, directory, new HashMap());
    }

    /**
     * Creates a new ReportSwingWorker object.
     *
     * @param  cidsBeans       DOCUMENT ME!
     * @param  compiledReport  DOCUMENT ME!
     * @param  withDialog      DOCUMENT ME!
     * @param  parent          DOCUMENT ME!
     * @param  directory       DOCUMENT ME!
     */
    public ReportSwingWorker(final Collection<CidsBean> cidsBeans,
            final String compiledReport,
            final boolean withDialog,
            final Frame parent,
            final String directory) {
        this(cidsBeans, compiledReport, withDialog, parent, directory, new HashMap());
    }

    /**
     * Creates a new ReportSwingWorker object.
     *
     * @param  cidsBeansList       DOCUMENT ME!
     * @param  compiledReportList  DOCUMENT ME!
     * @param  withDialog          DOCUMENT ME!
     * @param  parent              DOCUMENT ME!
     * @param  directory           DOCUMENT ME!
     * @param  parameters          DOCUMENT ME!
     */
    public ReportSwingWorker(final List<Collection<CidsBean>> cidsBeansList,
            final List<String> compiledReportList,
            final boolean withDialog,
            final Frame parent,
            final String directory,
            final HashMap parameters) {
        this(cidsBeansList, compiledReportList, withDialog, parent, directory, parameters, null);
    }

    /**
     * Creates a new ReportSwingWorker object.
     *
     * @param  cidsBeans       DOCUMENT ME!
     * @param  compiledReport  DOCUMENT ME!
     * @param  withDialog      DOCUMENT ME!
     * @param  parent          DOCUMENT ME!
     * @param  directory       DOCUMENT ME!
     * @param  parameters      DOCUMENT ME!
     */
    public ReportSwingWorker(final Collection<CidsBean> cidsBeans,
            final String compiledReport,
            final boolean withDialog,
            final Frame parent,
            final String directory,
            final HashMap parameters) {
        this(cidsBeans, compiledReport, withDialog, parent, directory, parameters, null);
    }

    /**
     * Creates a new ReportSwingWorker object.
     *
     * @param  cidsBeansList       DOCUMENT ME!
     * @param  compiledReportList  DOCUMENT ME!
     * @param  withDialog          DOCUMENT ME!
     * @param  parent              DOCUMENT ME!
     * @param  directory           DOCUMENT ME!
     * @param  parameters          DOCUMENT ME!
     * @param  reportName          The name of the report file without extension
     */
    public ReportSwingWorker(final List<Collection<CidsBean>> cidsBeansList,
            final List<String> compiledReportList,
            final boolean withDialog,
            final Frame parent,
            final String directory,
            final HashMap parameters,
            final String reportName) {
        this.cidsBeansList = cidsBeansList;
        this.compiledReportList = compiledReportList;
        this.withDialog = withDialog;
        this.directory = directory;
        this.parameters = parameters;
        if (withDialog) {
            dialog = new ReportSwingWorkerDialog(parent, true);
        } else {
            dialog = null;
        }
        if (reportName != null) {
            this.filename = reportName;
        }
    }

    /**
     * Creates a new ReportSwingWorker object.
     *
     * @param  cidsBeans       DOCUMENT ME!
     * @param  compiledReport  DOCUMENT ME!
     * @param  withDialog      DOCUMENT ME!
     * @param  parent          DOCUMENT ME!
     * @param  directory       DOCUMENT ME!
     * @param  parameters      DOCUMENT ME!
     * @param  reportName      The name of the report file without extension
     */
    public ReportSwingWorker(final Collection<CidsBean> cidsBeans,
            final String compiledReport,
            final boolean withDialog,
            final Frame parent,
            final String directory,
            final HashMap parameters,
            final String reportName) {
        this.cidsBeansList = new ArrayList<Collection<CidsBean>>();
        this.cidsBeansList.add(cidsBeans);
        this.compiledReportList = new ArrayList<String>();
        this.compiledReportList.add(compiledReport);
        this.withDialog = withDialog;
        this.directory = directory;
        this.parameters = parameters;
        if (withDialog) {
            dialog = new ReportSwingWorkerDialog(parent, true);
        } else {
            dialog = null;
        }

        if (reportName != null) {
            this.filename = reportName;
        }
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     *
     * @throws  Exception  DOCUMENT ME!
     */
    @Override
    protected Boolean doInBackground() throws Exception {
        if (withDialog) {
            SwingUtilities.invokeLater(new Runnable() {

                    @Override
                    public void run() {
                        StaticSwingTools.showDialog(dialog);
                    }
                });
        }
        final ByteArrayOutputStream out = new ByteArrayOutputStream();
        FileOutputStream fos = null;
        try {
            final List<InputStream> ins = new ArrayList<InputStream>();
            for (int index = 0; index < compiledReportList.size(); index++) {
                final String report = compiledReportList.get(index);
                final Collection<CidsBean> beans = cidsBeansList.get(index);

                // report holen
                final JasperReport jasperReport = (JasperReport)JRLoader.loadObject(ReportSwingWorker.class
                                .getResourceAsStream(report));
                // daten vorbereiten
                final JRDataSource dataSource = new CidsBeanDataSource(beans);
                // print aus report und daten erzeugen
                final JasperPrint jasperPrint = JasperFillManager.fillReport(jasperReport, parameters, dataSource);
                // quer- bzw hochformat übernehmen
                jasperPrint.setOrientation(jasperReport.getOrientationValue());

                // zum pdfStream exportieren und der streamliste hinzufügen
                final ByteArrayOutputStream outTmp = new ByteArrayOutputStream();
                JasperExportManager.exportReportToPdfStream(jasperPrint, outTmp);
                ins.add(new ByteArrayInputStream(outTmp.toByteArray()));
                outTmp.close();
            }
            // pdfStreams zu einem einzelnen pdfStream zusammenfügen
            ReportHelper.concatPDFs(ins, out, true);

            // zusammengefügten pdfStream in Datei schreiben
            File file = new File(directory, filename + FILE_EXTENSION);
            int index = 0;

            while (file.exists()) {
                file = new File(directory, filename + (++index) + FILE_EXTENSION);
            }

            file.getParentFile().mkdirs();
            fos = new FileOutputStream(file);
            fos.write(out.toByteArray());

            // Datei über Browser öffnen

            if (withDialog) {
                BrowserLauncher.openURL(file.toURI().toURL().toString());
            }
            return true;
        } catch (IOException ex) {
            LOG.error("Export to PDF-Stream failed.", ex);
        } catch (JRException ex) {
            LOG.error("Export to PDF-Stream failed.", ex);
        } finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (fos != null) {
                    fos.close();
                }
            } catch (IOException ex) {
                LOG.error("error while closing streams", ex);
            }
        }

        return false;
    }

    /**
     * DOCUMENT ME!
     */
    @Override
    protected void done() {
        boolean error = false;
        try {
            error = !get();
        } catch (InterruptedException ex) {
            // unterbrochen, nichts tun
        } catch (ExecutionException ex) {
            error = true;
            LOG.error("error while generating report", ex);
        }
        if (withDialog) {
            dialog.setVisible(false);
        }
        if (error && withDialog) {
            JOptionPane.showMessageDialog(
                dialog.getParent(),
                "Beim Generieren des Reports ist ein Fehler aufgetreten.",
                "Fehler!",
                JOptionPane.ERROR_MESSAGE);
        }
    }
}
