/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
/*
 *  Copyright (C) 2010 jruiz
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/*
 * DefaultReconnectorErrorPanel.java
 *
 * Created on 26.08.2010, 14:27:42
 */
package de.cismet.reconnector;

import java.awt.Container;

import java.io.PrintWriter;
import java.io.StringWriter;

import javax.swing.JDialog;
import javax.swing.UIManager;

/**
 * DOCUMENT ME!
 *
 * @author   jruiz
 * @version  $Revision$, $Date$
 */
public class DefaultReconnectorErrorPanel extends javax.swing.JPanel {

    //~ Static fields/initializers ---------------------------------------------

    private static final org.apache.log4j.Logger LOG = org.apache.log4j.Logger.getLogger(
            DefaultReconnectorErrorPanel.class);

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JToggleButton btnDetails;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JLabel labIco;
    private javax.swing.JLabel labMessage;
    private javax.swing.JScrollPane panDetails;
    private javax.swing.JTextArea txtDetails;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates new form DefaultReconnectorErrorPanel.
     *
     * @param  message    DOCUMENT ME!
     * @param  exception  DOCUMENT ME!
     */
    public DefaultReconnectorErrorPanel(final String message, final Throwable exception) {
        initComponents();

        final StringWriter exWriter = new StringWriter();
        exception.printStackTrace(new PrintWriter(exWriter));

        labMessage.setText(message);
        txtDetails.setText(exWriter.toString());
        panDetails.setVisible(false);
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        labIco = new javax.swing.JLabel();
        btnDetails = new javax.swing.JToggleButton();
        labMessage = new javax.swing.JLabel();
        panDetails = new javax.swing.JScrollPane();
        txtDetails = new javax.swing.JTextArea();
        jPanel1 = new javax.swing.JPanel();

        setLayout(new java.awt.GridBagLayout());

        labIco.setIcon(UIManager.getIcon("OptionPane.errorIcon"));
        labIco.setText(org.openide.util.NbBundle.getMessage(
                DefaultReconnectorErrorPanel.class,
                "DefaultReconnectorErrorPanel.labIco.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 0, 0);
        add(labIco, gridBagConstraints);

        btnDetails.setText(org.openide.util.NbBundle.getMessage(
                DefaultReconnectorErrorPanel.class,
                "DefaultReconnectorErrorPanel.btnDetails.text")); // NOI18N
        btnDetails.setPreferredSize(new java.awt.Dimension(75, 30));
        btnDetails.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    btnDetailsActionPerformed(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(6, 0, 0, 6);
        add(btnDetails, gridBagConstraints);

        labMessage.setText(org.openide.util.NbBundle.getMessage(
                DefaultReconnectorErrorPanel.class,
                "DefaultReconnectorErrorPanel.labMessage.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 0, 6);
        add(labMessage, gridBagConstraints);

        txtDetails.setColumns(20);
        txtDetails.setEditable(false);
        txtDetails.setRows(5);
        panDetails.setViewportView(txtDetails);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 6, 6);
        add(panDetails, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(6, 6, 0, 6);
        add(jPanel1, gridBagConstraints);
    } // </editor-fold>//GEN-END:initComponents

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void btnDetailsActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_btnDetailsActionPerformed
        panDetails.setVisible(btnDetails.isSelected());
        revalidate();
        Container parent = this;
        Container child = this;
        while (parent.getParent() != null) {
            child = parent;
            parent = parent.getParent();
        }
        if (child instanceof JDialog) {
            ((JDialog)child).pack();
        }
    }                                                                              //GEN-LAST:event_btnDetailsActionPerformed
}
