/*
 * Decompiled with CFR 0.152.
 */
package Sirius.navigator.plugin;

import Sirius.navigator.plugin.PluginDescriptor;
import Sirius.navigator.plugin.PluginRegistry;
import Sirius.navigator.plugin.interfaces.PluginSupport;
import Sirius.navigator.resource.PropertyManager;
import com.tngtech.java.junit.dataprovider.DataProvider;
import com.tngtech.java.junit.dataprovider.DataProviderRunner;
import com.tngtech.java.junit.dataprovider.UseDataProvider;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
@RunWith(value=DataProviderRunner.class)
public class PluginFactoryTest {
    private static final Logger LOGGER = Logger.getLogger(PluginFactoryTest.class);
    private static boolean propertyManagerInitialised = false;

    @BeforeClass
    public static void setUpClass() throws Exception {
        try {
            LOGGER.info((Object)"Configuring PropertyManager");
            PropertyManager.getManager().configure(PluginFactoryTest.class.getResource("/client/config/navigator.cfg").toString(), null, PluginFactoryTest.class.getResource("/client/plugins").toString(), PluginFactoryTest.class.getResource("/client/search").toString(), PluginFactoryTest.class.getResource("/client/profiles").toString());
            propertyManagerInitialised = true;
        }
        catch (Exception ex) {
            LOGGER.fatal((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
    }

    @AfterClass
    public static void tearDownClass() {
    }

    @Before
    public void setUp() throws Exception {
        Assert.assertTrue((String)"propertyManager initialised", (boolean)propertyManagerInitialised);
        if (!PluginRegistry.getRegistry().getPluginDescriptors().hasNext()) {
            try {
                LOGGER.info((Object)"preloading plugins!");
                PluginRegistry.getRegistry().preloadPlugins();
            }
            catch (Exception ex) {
                LOGGER.fatal((Object)ex.getMessage(), (Throwable)ex);
                throw ex;
            }
        }
    }

    @After
    public void tearDown() {
    }

    @Test
    public void test010printProperties() {
        LOGGER.info((Object)("BasePath: " + PropertyManager.getManager().getBasePath()));
        LOGGER.info((Object)("PluginPath: " + PropertyManager.getManager().getPluginPath()));
        LOGGER.info((Object)("ProfilesPath: " + PropertyManager.getManager().getProfilesPath()));
        LOGGER.info((Object)("SearchFormPath: " + PropertyManager.getManager().getSearchFormPath()));
        PropertyManager.getManager().print();
    }

    @Test
    public void test020printPluginPaths() {
        LOGGER.info((Object)("PluginListAvailable: " + PropertyManager.getManager().isPluginListAvailable()));
        Iterator pluginIterator = PropertyManager.getManager().getPluginList();
        while (pluginIterator.hasNext()) {
            LOGGER.info(pluginIterator.next());
        }
    }

    @Test
    public void test030printPluginDescriptors() throws Exception {
        Assert.assertTrue((boolean)PluginRegistry.getRegistry().getPluginDescriptors().hasNext());
        Iterator pluginDescriptorIterator = PluginRegistry.getRegistry().getPluginDescriptors();
        while (pluginDescriptorIterator.hasNext()) {
            PluginDescriptor pluginDescriptor = (PluginDescriptor)pluginDescriptorIterator.next();
            LOGGER.info((Object)(pluginDescriptor.getId() + ": " + pluginDescriptor.getName()));
            Assert.assertNotNull((Object)PluginRegistry.getRegistry().getPluginDescriptor(pluginDescriptor.getId()));
            Assert.assertEquals((Object)pluginDescriptor, (Object)PluginRegistry.getRegistry().getPluginDescriptor(pluginDescriptor.getId()));
        }
    }

    @Test
    @UseDataProvider(value="getPluginIds")
    @Ignore
    public void test040loadPlugin(String pluginId) throws Exception {
        try {
            LOGGER.info((Object)("loadPlugin: " + pluginId));
            Assert.assertNotNull((Object)PluginRegistry.getRegistry().getPluginDescriptor(pluginId));
            LOGGER.info((Object)("loading plugin '" + pluginId + "' from " + PluginRegistry.getRegistry().getPluginDescriptor(pluginId).getPluginPath()));
            PluginRegistry.getRegistry().loadPlugin(pluginId);
            PluginSupport plugin = PluginRegistry.getRegistry().getPlugin(pluginId);
            Assert.assertNotNull((Object)plugin);
        }
        catch (Exception ex) {
            LOGGER.fatal((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
    }

    @DataProvider
    public static final String[] getPluginIds() throws Exception {
        return new String[]{"cismap"};
    }
}

