/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.featurerenderer;

import Sirius.navigator.exception.ConnectionException;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import de.cismet.cids.annotations.CidsAttribute;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.featurerenderer.SubFeatureAwareFeatureRenderer;
import de.cismet.cids.tools.StaticCidsUtilities;
import de.cismet.cismap.commons.Refreshable;
import de.cismet.cismap.commons.gui.piccolo.FeatureAnnotationSymbol;
import de.cismet.cismap.navigatorplugin.CidsFeature;
import java.awt.Paint;
import java.awt.Stroke;
import java.lang.reflect.Field;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public abstract class CustomCidsFeatureRenderer
extends JPanel
implements SubFeatureAwareFeatureRenderer {
    protected MetaObject metaObject;
    protected MetaClass metaClass;
    protected Refreshable refreshable;
    protected CidsBean cidsBean;
    private final Logger log = Logger.getLogger(this.getClass());

    public void setMetaObject(MetaObject metaObject) throws ConnectionException {
        this.metaObject = metaObject;
        this.cidsBean = metaObject.getBean();
    }

    public abstract void assign();

    public String getAlternativeName() {
        return null;
    }

    public float getTransparency() {
        return -1.0f;
    }

    public FeatureAnnotationSymbol getPointSymbol() {
        return null;
    }

    public Stroke getLineStyle() {
        return null;
    }

    public Paint getLinePaint() {
        return null;
    }

    public JComponent getInfoComponent(Refreshable refresh) {
        this.refreshable = refresh;
        this.refreshValues();
        return this;
    }

    public Paint getFillingStyle() {
        return null;
    }

    public void refreshValues() {
        Class<?> customRenderer = this.getClass();
        try {
            Field[] fields;
            for (Field f : fields = customRenderer.getDeclaredFields()) {
                if (!f.isAnnotationPresent(CidsAttribute.class)) continue;
                try {
                    CidsAttribute ca = f.getAnnotation(CidsAttribute.class);
                    String attributeName = ca.value();
                    Object value = StaticCidsUtilities.getValueOfAttributeByString((String)attributeName, (MetaObject)this.metaObject);
                    f.set(this, value);
                }
                catch (Exception e) {
                    this.log.warn((Object)"Fehler beim Zuweisen im Renderer", (Throwable)e);
                }
            }
            this.assign();
        }
        catch (Throwable t) {
            this.log.fatal((Object)"Error in refrehhValues()", t);
        }
    }

    public float getInfoComponentTransparency() {
        return -1.0f;
    }

    public Refreshable getRefreshable() {
        return this.refreshable;
    }

    @Override
    public Paint getFillingStyle(CidsFeature subFeature) {
        return this.getFillingStyle();
    }

    @Override
    public JComponent getInfoComponent(Refreshable refresh, CidsFeature subFeature) {
        return this.getInfoComponent(refresh);
    }

    @Override
    public Paint getLinePaint(CidsFeature subFeature) {
        return this.getLinePaint();
    }

    @Override
    public Stroke getLineStyle(CidsFeature subFeature) {
        return this.getLineStyle();
    }

    @Override
    public FeatureAnnotationSymbol getPointSymbol(CidsFeature subFeature) {
        return this.getPointSymbol();
    }

    @Override
    public float getTransparency(CidsFeature subFeature) {
        return this.getTransparency();
    }
}

