/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.cids.geometryeditor;

import Sirius.navigator.types.treenode.DefaultMetaTreeNode;
import Sirius.navigator.ui.ComponentRegistry;
import Sirius.server.localserver.attribute.ObjectAttribute;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaClassStore;
import Sirius.server.middleware.types.MetaObject;
import Sirius.server.middleware.types.MetaObjectNode;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.client.tools.ConnectionContextUtils;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.dynamics.Disposable;
import de.cismet.cids.editors.Bindable;
import de.cismet.cismap.cids.geometryeditor.CismapGeometryComboModel;
import de.cismet.cismap.cids.geometryeditor.FeatureComboBoxRenderer;
import de.cismet.cismap.commons.BoundingBox;
import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.features.FeatureCollection;
import de.cismet.cismap.commons.features.FeatureCollectionListener;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.navigatorplugin.CidsFeature;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextProvider;
import de.cismet.tools.CurrentStackTrace;
import java.awt.Component;
import javax.swing.JComboBox;
import org.apache.log4j.Logger;
import org.jdesktop.beansbinding.Converter;
import org.jdesktop.beansbinding.Validator;

public class DefaultCismapGeometryComboBoxEditor
extends JComboBox
implements Bindable,
MetaClassStore,
Disposable,
ConnectionContextProvider {
    private static final String GEOM_FIELD = "geo_field";
    private static final String CISMAP_PLUGIN_ID = "cismap";
    private static final Logger LOG = Logger.getLogger(DefaultCismapGeometryComboBoxEditor.class);
    protected MetaObjectNode metaObjectNode;
    protected MetaClass metaClass;
    protected Feature selectedFeature = null;
    protected CidsFeature cidsFeature = null;
    protected CismapGeometryComboModel comboModel = new CismapGeometryComboModel(this, this.selectedFeature);
    protected MetaObject cidsMetaObject = null;
    protected String localRenderFeatureString;
    private CidsBean geometryBean;

    public DefaultCismapGeometryComboBoxEditor() {
        this(true);
    }

    public DefaultCismapGeometryComboBoxEditor(boolean editable) {
        this.setModel(this.comboModel);
        this.setRenderer(new FeatureComboBoxRenderer());
        if (editable) {
            try {
                DefaultMetaTreeNode dmtn = (DefaultMetaTreeNode)ComponentRegistry.getRegistry().getAttributeEditor().getTreeNode();
                if (dmtn != null) {
                    this.metaObjectNode = (MetaObjectNode)dmtn.getNode();
                }
                CismapBroker.getInstance().getMappingComponent().getFeatureCollection().addFeatureCollectionListener((FeatureCollectionListener)this.comboModel);
            }
            catch (Exception e) {
                LOG.error((Object)("Error during init of " + this.getClass()), (Throwable)e);
            }
        }
    }

    public void setAllowedGeometryTypes(Class[] allowedTypes) {
        this.comboModel.setAllowedGeometryTypes(allowedTypes);
        this.comboModel.refresh();
    }

    public void dispose() {
        try {
            CismapBroker.getInstance().getMappingComponent().getFeatureCollection().removeFeatureCollectionListener((FeatureCollectionListener)this.comboModel);
            if (this.selectedFeature != null) {
                CismapBroker.getInstance().getMappingComponent().getFeatureCollection().removeFeature(this.selectedFeature);
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Error during removeNotify of " + this.getClass()), (Throwable)e);
        }
    }

    public String getBindingProperty() {
        return "selectedItem";
    }

    public Object getNullSourceValue() {
        return null;
    }

    public Object getErrorSourceValue() {
        return null;
    }

    public Converter getConverter() {
        return new Converter<CidsBean, Feature>(){

            public Feature convertForward(CidsBean value) {
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"convertForward", (Throwable)new CurrentStackTrace());
                    }
                    DefaultCismapGeometryComboBoxEditor.this.geometryBean = value;
                    if (value != null) {
                        MetaObject cidsFeatureMetaObject = null;
                        if (DefaultCismapGeometryComboBoxEditor.this.cidsMetaObject != null) {
                            cidsFeatureMetaObject = DefaultCismapGeometryComboBoxEditor.this.cidsMetaObject;
                        } else if (DefaultCismapGeometryComboBoxEditor.this.metaObjectNode != null) {
                            cidsFeatureMetaObject = DefaultCismapGeometryComboBoxEditor.this.metaObjectNode.getObject();
                        }
                        ObjectAttribute oAttr = null;
                        if (DefaultCismapGeometryComboBoxEditor.this.localRenderFeatureString != null) {
                            oAttr = cidsFeatureMetaObject.getAttributeByFieldName(DefaultCismapGeometryComboBoxEditor.this.localRenderFeatureString);
                        }
                        DefaultCismapGeometryComboBoxEditor.this.cidsFeature = new CidsFeature(cidsFeatureMetaObject, oAttr){
                            private Geometry lastGeom;
                            {
                                this.lastGeom = DefaultCismapGeometryComboBoxEditor.this.geometryBean != null ? (Geometry)((Geometry)DefaultCismapGeometryComboBoxEditor.this.geometryBean.getProperty(DefaultCismapGeometryComboBoxEditor.GEOM_FIELD)).clone() : null;
                            }

                            @Override
                            public void setGeometry(Geometry geom) {
                                if (geom == null) {
                                    LOG.warn((Object)"ATTENTION geom=null");
                                }
                                Geometry oldValue = this.lastGeom;
                                super.setGeometry(geom);
                                try {
                                    if (oldValue == null && geom != null || oldValue != null && !oldValue.equalsExact(geom)) {
                                        DefaultCismapGeometryComboBoxEditor.this.geometryBean.setProperty(DefaultCismapGeometryComboBoxEditor.GEOM_FIELD, (Object)geom);
                                        this.lastGeom = geom != null ? (Geometry)geom.clone() : null;
                                    }
                                }
                                catch (Exception e) {
                                    LOG.error((Object)"Error when setting the geometry.", (Throwable)e);
                                }
                            }
                        };
                        DefaultCismapGeometryComboBoxEditor.this.selectedFeature = DefaultCismapGeometryComboBoxEditor.this.cidsFeature;
                        DefaultCismapGeometryComboBoxEditor.this.comboModel.setCurrentObjectFeature(DefaultCismapGeometryComboBoxEditor.this.selectedFeature);
                        FeatureCollection cismapFeatures = CismapBroker.getInstance().getMappingComponent().getFeatureCollection();
                        if (cismapFeatures.getAllFeatures().contains(DefaultCismapGeometryComboBoxEditor.this.selectedFeature)) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)"Feature already exists. Remove it from map.");
                            }
                            cismapFeatures.removeFeature(DefaultCismapGeometryComboBoxEditor.this.selectedFeature);
                        }
                        if (DefaultCismapGeometryComboBoxEditor.this.selectedFeature.getGeometry() == null) {
                            DefaultCismapGeometryComboBoxEditor.this.selectedFeature.setGeometry((Geometry)value.getProperty(DefaultCismapGeometryComboBoxEditor.GEOM_FIELD));
                        }
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Add selectedFeature '" + DefaultCismapGeometryComboBoxEditor.this.selectedFeature + "' with geometry '" + DefaultCismapGeometryComboBoxEditor.this.selectedFeature.getGeometry() + "' to feature collection."));
                        }
                        cismapFeatures.addFeature(DefaultCismapGeometryComboBoxEditor.this.selectedFeature);
                        DefaultCismapGeometryComboBoxEditor.this.selectedFeature.setEditable(true);
                        cismapFeatures.holdFeature(DefaultCismapGeometryComboBoxEditor.this.selectedFeature);
                        cismapFeatures.select(DefaultCismapGeometryComboBoxEditor.this.selectedFeature);
                        CismapBroker.getInstance().getMappingComponent().showHandles(true);
                        if (DefaultCismapGeometryComboBoxEditor.this.selectedFeature.getGeometry() != null) {
                            CismapBroker.getInstance().getMappingComponent().gotoBoundingBox((BoundingBox)new XBoundingBox(DefaultCismapGeometryComboBoxEditor.this.selectedFeature.getGeometry()), false, true, 0);
                        }
                        DefaultCismapGeometryComboBoxEditor.this.setSelectedItem(DefaultCismapGeometryComboBoxEditor.this.selectedFeature);
                    }
                    return DefaultCismapGeometryComboBoxEditor.this.selectedFeature;
                }
                catch (Exception e) {
                    LOG.error((Object)"Error in convertForward", (Throwable)e);
                    return null;
                }
            }

            public CidsBean convertReverse(Feature value) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("convertReverse: " + value));
                }
                if (value == null) {
                    return null;
                }
                try {
                    if (DefaultCismapGeometryComboBoxEditor.this.geometryBean == null) {
                        DefaultCismapGeometryComboBoxEditor.this.geometryBean = DefaultCismapGeometryComboBoxEditor.this.metaClass.getEmptyInstance(DefaultCismapGeometryComboBoxEditor.this.getConnectionContext()).getBean();
                    }
                    Geometry oldValue = (Geometry)DefaultCismapGeometryComboBoxEditor.this.geometryBean.getProperty(DefaultCismapGeometryComboBoxEditor.GEOM_FIELD);
                    Geometry geom = value.getGeometry();
                    if (oldValue == null && geom != null || oldValue != null && !oldValue.equalsExact(geom)) {
                        DefaultCismapGeometryComboBoxEditor.this.geometryBean.setProperty(DefaultCismapGeometryComboBoxEditor.GEOM_FIELD, (Object)value.getGeometry());
                    }
                }
                catch (Exception ex) {
                    LOG.error((Object)"Error during set geo_field", (Throwable)ex);
                }
                return DefaultCismapGeometryComboBoxEditor.this.geometryBean;
            }
        };
    }

    public Validator getValidator() {
        return null;
    }

    public MetaClass getMetaClass() {
        return this.metaClass;
    }

    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public void setCidsMetaObject(MetaObject cidsMetaObject) {
        this.cidsMetaObject = cidsMetaObject;
    }

    public void setLocalRenderFeatureString(String localRenderFeatureString) {
        this.localRenderFeatureString = localRenderFeatureString;
    }

    public String getLocalRenderFeatureString() {
        return this.localRenderFeatureString;
    }

    public void initForNewBinding() {
        CismapBroker.getInstance().getMappingComponent().getFeatureCollection().removeFeatureCollectionListener((FeatureCollectionListener)this.comboModel);
        this.geometryBean = null;
        this.selectedFeature = null;
        this.cidsFeature = null;
        this.comboModel = new CismapGeometryComboModel(this, this.selectedFeature);
        this.setModel(this.comboModel);
        CismapBroker.getInstance().getMappingComponent().getFeatureCollection().addFeatureCollectionListener((FeatureCollectionListener)this.comboModel);
    }

    public MetaObject getCidsMetaObject() {
        return this.cidsMetaObject;
    }

    public ConnectionContext getConnectionContext() {
        return ConnectionContextUtils.getFirstParentClientConnectionContext((Component)this);
    }
}

