/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.cids.geometryeditor;

import com.vividsolutions.jts.geom.Point;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.features.XStyledFeature;
import de.cismet.cismap.commons.gui.piccolo.PFeature;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.navigatorplugin.CidsFeature;
import java.awt.Color;
import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.UIManager;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class FeatureComboBoxRenderer
extends DefaultListCellRenderer {
    Color background = UIManager.getDefaults().getColor("ComboBox.background");
    Color selectedBackground = UIManager.getDefaults().getColor("ComboBox.selectionBackground");
    private final Logger log = Logger.getLogger(this.getClass());

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        try {
            if (value != null) {
                if (value instanceof CidsFeature && ((CidsFeature)value).getGeometry() != null) {
                    this.setText(NbBundle.getMessage(FeatureComboBoxRenderer.class, (String)"FeatureComboBoxRenderer.getListCellRendererComponent(JList,Object,int,booblean,boolean).text.assignedGeometry", (Object[])new Object[]{((CidsFeature)value).getGeometry().getGeometryType()}));
                } else if (value instanceof XStyledFeature && ((XStyledFeature)value).getGeometry() != null) {
                    this.setText(((XStyledFeature)value).getName());
                    this.setIcon(((XStyledFeature)value).getIconImage());
                    PFeature pf = (PFeature)CismapBroker.getInstance().getMappingComponent().getPFeatureHM().get(value);
                    PFeature clonePf = (PFeature)pf.clone();
                    if (clonePf.getFeature().getGeometry() instanceof Point) {
                        clonePf.getChild(0).removeAllChildren();
                    } else {
                        clonePf.removeAllChildren();
                    }
                    this.setToolTipText("@@@@" + this.getText());
                } else {
                    this.setText(value.getClass() + ":" + value.toString());
                    this.setIcon(null);
                }
            } else {
                this.setText(NbBundle.getMessage(FeatureComboBoxRenderer.class, (String)"FeatureComboBoxRenderer.getListCellRendererComponent(JList,Object,int,booblean,boolean).text.noAssignement"));
            }
        }
        catch (Throwable t) {
            this.log.error((Object)"Error in the renderer of the ComboBox", t);
            this.setText(NbBundle.getMessage(FeatureComboBoxRenderer.class, (String)"FeatureComboBoxRenderer.getListCellRendererComponent(JList,Object,int,booblean,boolean).text.value", (Object[])new Object[]{((Feature)value).getGeometry()}));
        }
        return this;
    }
}

