/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.cidslayer;

import Sirius.navigator.connection.SessionManager;
import Sirius.server.localserver.attribute.ClassAttribute;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.newuser.User;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.io.WKBReader;
import de.cismet.cids.server.cidslayer.CidsLayerInfo;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.cids.server.search.builtin.CidsLayerInitStatement;
import de.cismet.cids.server.search.builtin.CidsLayerSearchStatement;
import de.cismet.cids.tools.CidsLayerUtil;
import de.cismet.cismap.cidslayer.CidsLayer;
import de.cismet.cismap.cidslayer.CidsLayerFeature;
import de.cismet.cismap.commons.BoundingBox;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.featureservice.AbstractFeatureService;
import de.cismet.cismap.commons.featureservice.FeatureServiceAttribute;
import de.cismet.cismap.commons.featureservice.LayerProperties;
import de.cismet.cismap.commons.featureservice.factory.AbstractFeatureFactory;
import de.cismet.cismap.commons.featureservice.factory.FeatureFactory;
import de.cismet.cismap.commons.gui.attributetable.AttributeTableRuleSet;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.tools.FeatureTools;
import de.cismet.commons.cismap.io.converters.GeomFromWktConverter;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextProvider;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.SwingWorker;
import org.deegree.style.se.unevaluated.Style;

public class CidsFeatureFactory
extends AbstractFeatureFactory<CidsLayerFeature, String>
implements ConnectionContextProvider {
    private static int currentId = -1;
    protected List<FeatureServiceAttribute> featureServiceAttributes;
    GeomFromWktConverter converter = new GeomFromWktConverter();
    MetaClass metaClass;
    private Geometry envelope;
    private CidsLayerInfo layerInfo;
    private String geometryType = AbstractFeatureService.UNKNOWN;
    private Double maxArea = null;
    private Double maxScale = null;
    private Integer maxFeaturesPerPage = null;
    private final ConnectionContext connectionContext = ConnectionContext.createDummy();

    public CidsFeatureFactory(CidsFeatureFactory cff) {
        super((AbstractFeatureFactory)cff);
        this.metaClass = cff.metaClass;
        this.envelope = cff.envelope;
        this.featureServiceAttributes = cff.featureServiceAttributes;
        this.layerInfo = cff.layerInfo;
        this.geometryType = cff.geometryType;
        this.maxArea = cff.maxArea;
        this.maxScale = cff.maxScale;
        this.maxFeaturesPerPage = cff.maxFeaturesPerPage;
        this.layerProperties = cff.layerProperties;
    }

    public CidsFeatureFactory(MetaClass metaClass, LayerProperties layerProperties) {
        this.layerProperties = layerProperties;
        this.metaClass = metaClass;
        this.layerName = CidsLayer.determineLayerName(metaClass);
        this.initLayer();
    }

    public CidsFeatureFactory(MetaClass metaClass, LayerProperties layerProperties, Map<String, LinkedList<Style>> styles) {
        this.layerProperties = layerProperties;
        this.setSLDStyle(styles);
        this.metaClass = metaClass;
        this.layerName = CidsLayer.determineLayerName(metaClass);
        this.initLayer();
    }

    protected boolean isGenerateIds() {
        return false;
    }

    public CidsFeatureFactory clone() {
        return new CidsFeatureFactory(this);
    }

    public synchronized FeatureServiceFeature createNewFeature() {
        HashMap<String, Object> properties = new HashMap<String, Object>(this.featureServiceAttributes.size());
        for (int j = this.featureServiceAttributes.size() - 1; j >= 0; --j) {
            if (this.featureServiceAttributes.get(j).getName().equalsIgnoreCase("id")) {
                properties.put(this.featureServiceAttributes.get(j).getName(), this.getFreeId());
                continue;
            }
            properties.put(this.featureServiceAttributes.get(j).getName(), null);
        }
        CidsLayerFeature feature = new CidsLayerFeature(properties, this.metaClass, this.getLayerInfo(), this.layerProperties, this.getStyle(this.layerName));
        return feature;
    }

    private synchronized int getFreeId() {
        return currentId--;
    }

    public List<CidsLayerFeature> createFeatures(String query, BoundingBox boundingBox, SwingWorker workerThread) throws FeatureFactory.TooManyFeaturesException, Exception {
        if (this.maxArea != null && boundingBox != null) {
            Geometry bbox = boundingBox.getGeometry(CrsTransformer.extractSridFromCrs((String)CismapBroker.getInstance().getSrs().getCode()));
            if ((bbox = CrsTransformer.transformToMetricCrs((Geometry)bbox)).getArea() > this.maxArea) {
                return new ArrayList<CidsLayerFeature>();
            }
        }
        if (this.maxScale != null && boundingBox != null && CismapBroker.getInstance().getMappingComponent().getScaleDenominator() > this.maxScale) {
            return new ArrayList<CidsLayerFeature>();
        }
        return this.createFeaturesInternal(query, boundingBox, workerThread, 0, 0, null, true);
    }

    private void initLayer() {
        try {
            String[] additionalFields;
            ClassAttribute maxPageSizeAttr;
            CidsLayerInfo info = CidsLayerUtil.getCidsLayerInfo((MetaClass)this.metaClass, (User)SessionManager.getSession().getUser());
            this.setLayerInfo(info);
            ClassAttribute scaleAttr = this.metaClass.getClassAttribute("maxArea");
            if (scaleAttr != null && scaleAttr.getValue() != null) {
                try {
                    this.maxArea = Double.parseDouble(scaleAttr.getValue().toString());
                }
                catch (Exception e) {
                    this.logger.error((Object)("the max area attribute does not contain a valid number: " + scaleAttr.getValue().toString()), (Throwable)e);
                }
            }
            if ((scaleAttr = this.metaClass.getClassAttribute("maxScale")) != null && scaleAttr.getValue() != null) {
                try {
                    this.maxScale = Double.parseDouble(scaleAttr.getValue().toString());
                }
                catch (Exception e) {
                    this.logger.error((Object)("the max scale attribute does not contain a valid number: " + scaleAttr.getValue().toString()), (Throwable)e);
                }
            }
            if ((maxPageSizeAttr = this.metaClass.getClassAttribute("maxPageSize")) != null && maxPageSizeAttr.getValue() != null) {
                try {
                    this.maxFeaturesPerPage = Integer.parseInt(maxPageSizeAttr.getValue().toString());
                }
                catch (Exception e) {
                    this.logger.error((Object)("the max page size attribute does not contain a valid number: " + maxPageSizeAttr.getValue().toString()), (Throwable)e);
                }
            }
            ClassAttribute typeAttr = this.metaClass.getClassAttribute("geometryType");
            ClassAttribute boundingBoxAttr = this.metaClass.getClassAttribute("boundingBox");
            this.geometryType = AbstractFeatureService.UNKNOWN;
            String crs = CismapBroker.getInstance().getDefaultCrs();
            if (typeAttr == null || boundingBoxAttr == null) {
                CidsLayerInitStatement serverSearch = new CidsLayerInitStatement(this.metaClass, SessionManager.getSession().getUser());
                ArrayList resultArray = (ArrayList)SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)serverSearch, this.getConnectionContext());
                for (ArrayList row : resultArray) {
                    if (row.get(0) == null) continue;
                    this.envelope = this.converter.convertForward((String)row.get(0), new String[]{crs});
                    if (this.envelope instanceof Point) {
                        this.envelope = this.envelope.buffer(1.0);
                    }
                    if (row.size() != 2) continue;
                    this.geometryType = this.postgisToJtsGeometryType((String)row.get(1));
                }
            }
            if (typeAttr != null && typeAttr.getValue() != null) {
                this.geometryType = typeAttr.getValue().toString();
            }
            if (boundingBoxAttr != null && boundingBoxAttr.getValue() != null) {
                this.envelope = this.converter.convertForward(boundingBoxAttr.getValue().toString(), new String[]{crs});
            }
            this.featureServiceAttributes = new ArrayList<FeatureServiceAttribute>();
            String[] names = this.layerInfo.getColumnNames();
            String[] types = this.layerInfo.getPrimitiveColumnTypes();
            for (int i = 0; i < names.length; ++i) {
                String type = String.valueOf(this.getTypeByTypeName(types[i]));
                this.featureServiceAttributes.add(new FeatureServiceAttribute(names[i], type, true));
            }
            AttributeTableRuleSet ruleSet = this.layerProperties.getAttributeTableRuleSet();
            if (ruleSet != null && (additionalFields = ruleSet.getAdditionalFieldNames()) != null) {
                for (int index = 0; index < additionalFields.length; ++index) {
                    String name = additionalFields[index];
                    Class cl = ruleSet.getAdditionalFieldClass(index);
                    FeatureServiceAttribute fsa = new FeatureServiceAttribute(name, FeatureTools.getType((Class)cl), true);
                    int attributeIndex = ruleSet.getIndexOfAdditionalFieldName(name);
                    if (attributeIndex < 0) {
                        attributeIndex = this.featureServiceAttributes.size() + 1 + attributeIndex;
                    }
                    this.featureServiceAttributes.add(attributeIndex, fsa);
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Error while initialiseing the cids layer.", (Throwable)e);
        }
    }

    private String postgisToJtsGeometryType(String geometryType) {
        GeometryFactory factory = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), -1);
        if (geometryType.equalsIgnoreCase("ST_Point")) {
            return "Point";
        }
        if (geometryType.equalsIgnoreCase("ST_MultiPoint")) {
            return "MultiPoint";
        }
        if (geometryType.equalsIgnoreCase("ST_LineString")) {
            return "LineString";
        }
        if (geometryType.equalsIgnoreCase("ST_MultiLineString")) {
            return "MultiLineString";
        }
        if (geometryType.equalsIgnoreCase("ST_Polygon")) {
            return "Polygon";
        }
        if (geometryType.equalsIgnoreCase("ST_MultiPolygon")) {
            return "MultiPolygon";
        }
        return AbstractFeatureService.UNKNOWN;
    }

    public List<FeatureServiceAttribute> createAttributes(SwingWorker workerThread) throws FeatureFactory.TooManyFeaturesException, UnsupportedOperationException, Exception {
        if (this.featureServiceAttributes == null) {
            this.initLayer();
        }
        if (this.featureServiceAttributes == null) {
            this.logger.warn((Object)"FeatureServiceAttributes for cids feature factory not found");
        }
        return this.featureServiceAttributes;
    }

    private int getTypeByTypeName(String dataType) {
        String type = dataType;
        if (type.indexOf(".") != -1) {
            type = type.substring(type.lastIndexOf(".") + 1);
        }
        if (type.equalsIgnoreCase("string") || type.equalsIgnoreCase("text") || type.equalsIgnoreCase("varchar")) {
            return 12;
        }
        if (type.equalsIgnoreCase("double") || type.equalsIgnoreCase("double precision") || type.equalsIgnoreCase("float8")) {
            return 8;
        }
        if (type.equalsIgnoreCase("float")) {
            return 6;
        }
        if (type.equalsIgnoreCase("integer") || type.equalsIgnoreCase("int")) {
            return 4;
        }
        if (type.equalsIgnoreCase("long") || type.equalsIgnoreCase("int8")) {
            return -5;
        }
        if (type.toLowerCase().contains("timestamp")) {
            return 93;
        }
        if (type.toLowerCase().contains("time")) {
            return 92;
        }
        if (type.toLowerCase().contains("date")) {
            return 91;
        }
        if (type.toLowerCase().contains("bool")) {
            return 16;
        }
        if (type.toLowerCase().contains("geometry")) {
            return 10012;
        }
        if (type.equalsIgnoreCase("BigDecimal")) {
            return 2;
        }
        return 12;
    }

    public void initEnvelope(final String query) {
        Thread determineEnvelope = new Thread("determine envelope"){

            @Override
            public void run() {
                try {
                    CidsLayerInitStatement serverSearch = new CidsLayerInitStatement(CidsFeatureFactory.this.metaClass, SessionManager.getSession().getUser(), CidsFeatureFactory.this.adjustQuery(query));
                    ArrayList resultArray = (ArrayList)SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)serverSearch, CidsFeatureFactory.this.getConnectionContext());
                    String crs = CismapBroker.getInstance().getDefaultCrs();
                    if (resultArray != null) {
                        for (ArrayList row : resultArray) {
                            if (row.get(0) == null) continue;
                            CidsFeatureFactory.this.envelope = CidsFeatureFactory.this.converter.convertForward((String)row.get(0), new String[]{crs});
                            if (!(CidsFeatureFactory.this.envelope instanceof Point)) continue;
                            CidsFeatureFactory.this.envelope = CidsFeatureFactory.this.envelope.buffer(1.0);
                        }
                    }
                }
                catch (Exception e) {
                    CidsFeatureFactory.this.logger.error((Object)"Error while determine new extend", (Throwable)e);
                }
            }
        };
        determineEnvelope.start();
    }

    public List<CidsLayerFeature> createFeatures(String query, BoundingBox boundingBox, SwingWorker workerThread, int offset, int limit, FeatureServiceAttribute[] orderBy) throws FeatureFactory.TooManyFeaturesException, Exception {
        return this.createFeaturesInternal(query, boundingBox, workerThread, offset, limit, orderBy, false);
    }

    private List<CidsLayerFeature> createFeaturesInternal(String query, BoundingBox boundingBox, SwingWorker workerThread, int offset, int limit, FeatureServiceAttribute[] orderBy, boolean saveAsLastCreated) throws FeatureFactory.TooManyFeaturesException, Exception {
        Constructor featureConstructor;
        Class featureClass;
        boolean ignoreGeoLimitations;
        if (this.checkCancelled(workerThread, "creatureFeatures()")) {
            return null;
        }
        long startTime = System.currentTimeMillis();
        String crs = CismapBroker.getInstance().getDefaultCrs();
        int srid = CrsTransformer.extractSridFromCrs((String)CismapBroker.getInstance().getSrs().getCode());
        CrsTransformer transformer = new CrsTransformer(crs);
        BoundingBox boundingBoxIncurrentCrs = null;
        CidsLayerSearchStatement serverSearch = new CidsLayerSearchStatement(this.metaClass, SessionManager.getSession().getUser());
        if (boundingBox != null) {
            boundingBoxIncurrentCrs = transformer.transformBoundingBox(boundingBox, CismapBroker.getInstance().getSrs().getCode());
        }
        serverSearch.setExactSearch(true);
        serverSearch.setSrid(CismapBroker.getInstance().getDefaultCrsAlias());
        String[] orderByStrings = new String[]{};
        if (orderBy != null) {
            orderByStrings = new String[orderBy.length];
            for (int i = 0; i < orderBy.length; ++i) {
                orderByStrings[i] = CidsLayer.getSQLName(this.layerInfo, orderBy[i].getName()) + " " + (orderBy[i].isAscOrder() ? "asc" : "desc");
            }
        }
        boolean bl = boundingBoxIncurrentCrs == null ? true : (ignoreGeoLimitations = this.envelope == null || this.envelope.coveredBy(boundingBoxIncurrentCrs.getGeometry(srid)));
        if (!(boundingBoxIncurrentCrs == null || this.envelope != null && ignoreGeoLimitations)) {
            serverSearch.setX1(boundingBoxIncurrentCrs.getX1());
            serverSearch.setY1(boundingBoxIncurrentCrs.getY1());
            serverSearch.setX2(boundingBoxIncurrentCrs.getX2());
            serverSearch.setY2(boundingBoxIncurrentCrs.getY2());
        }
        serverSearch.setQuery(this.adjustQuery(query));
        if (limit != 0 || this.maxFeaturesPerPage == null) {
            serverSearch.setLimit(limit);
        }
        serverSearch.setOffset(offset);
        serverSearch.setOrderBy(orderByStrings);
        if (this.checkCancelled(workerThread, "PreQuery")) {
            return null;
        }
        boolean compressed = false;
        serverSearch.setCompressed(false);
        Collection resultCollection = SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)serverSearch, this.getConnectionContext());
        if (this.checkCancelled(workerThread, "PostQuery")) {
            return null;
        }
        ArrayList resultArray = (ArrayList)resultCollection;
        if (resultArray == null) {
            return new ArrayList<CidsLayerFeature>();
        }
        Vector<CidsLayerFeature> features = new Vector<CidsLayerFeature>();
        GeometryFactory geomFactory = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), CrsTransformer.extractSridFromCrs((String)crs));
        WKBReader wkbReader = new WKBReader(geomFactory);
        ArrayList<FeatureServiceAttribute> attributeListWithoutGenericAttributes = new ArrayList<FeatureServiceAttribute>();
        for (FeatureServiceAttribute attr : this.featureServiceAttributes) {
            if (this.layerProperties.getAttributeTableRuleSet() != null && this.layerProperties.getAttributeTableRuleSet().getIndexOfAdditionalFieldName(attr.getName()) != Integer.MIN_VALUE) continue;
            attributeListWithoutGenericAttributes.add(attr);
        }
        if (this.getLayerProperties() != null && this.getLayerProperties().getAttributeTableRuleSet() != null && this.getLayerProperties().getAttributeTableRuleSet().getFeatureClass() != null && CidsLayerFeature.class.isAssignableFrom(this.getLayerProperties().getAttributeTableRuleSet().getFeatureClass())) {
            featureClass = this.getLayerProperties().getAttributeTableRuleSet().getFeatureClass();
        } else {
            if (this.getLayerProperties() != null && this.getLayerProperties().getAttributeTableRuleSet() != null && this.getLayerProperties().getAttributeTableRuleSet().getFeatureClass() != null) {
                this.logger.warn((Object)"The custom feature class of the cids layer is not an instance of CidsLayerFeature. The class CidsLayerFeature will be used.");
            }
            featureClass = CidsLayerFeature.class;
        }
        try {
            featureConstructor = featureClass.getConstructor(Map.class, MetaClass.class, CidsLayerInfo.class, LayerProperties.class, List.class);
        }
        catch (Exception e) {
            this.logger.warn((Object)"The custom CidsLayerFeature class has no suitable constructor (Map, MetaClass, CidsLayerInfo, LayerProperties, List). The class CidsLayerFeature will be used.", (Throwable)e);
            featureClass = CidsLayerFeature.class;
            try {
                featureConstructor = featureClass.getConstructor(Map.class, MetaClass.class, CidsLayerInfo.class, LayerProperties.class, List.class);
            }
            catch (Exception ex) {
                this.logger.error((Object)"No suitable constructor found in class CidsLayerFeature. The cids layer cannot be used.", (Throwable)ex);
                return features;
            }
        }
        for (int i = 0; i < resultArray.size(); ++i) {
            HashMap<String, Object> properties = new HashMap<String, Object>(attributeListWithoutGenericAttributes.size());
            boolean abort = false;
            for (int j = ((ArrayList)resultArray.get(i)).size() - 1; j >= 0; --j) {
                if (((ArrayList)resultArray.get(i)).get(j) instanceof byte[]) {
                    try {
                        Geometry g = wkbReader.read((byte[])((ArrayList)resultArray.get(i)).get(j));
                        if (!(ignoreGeoLimitations || saveAsLastCreated || boundingBoxIncurrentCrs == null || g.intersects(boundingBoxIncurrentCrs.getGeometry(srid)))) {
                            abort = true;
                            break;
                        }
                        properties.put(((FeatureServiceAttribute)attributeListWithoutGenericAttributes.get(j)).getName(), g);
                    }
                    catch (Exception ex) {
                        properties.put(((FeatureServiceAttribute)attributeListWithoutGenericAttributes.get(j)).getName(), ((ArrayList)resultArray.get(i)).get(j));
                    }
                    continue;
                }
                properties.put(((FeatureServiceAttribute)attributeListWithoutGenericAttributes.get(j)).getName(), ((ArrayList)resultArray.get(i)).get(j));
            }
            if (abort) continue;
            CidsLayerFeature lastFeature = (CidsLayerFeature)((Object)featureConstructor.newInstance(properties, this.metaClass, this.getLayerInfo(), this.layerProperties, this.getStyle(this.layerName)));
            features.add(lastFeature);
            lastFeature = null;
        }
        if (this.checkCancelled(workerThread, "PreReturn()")) {
            return null;
        }
        if (saveAsLastCreated && boundingBoxIncurrentCrs != null) {
            this.updateLastCreatedFeatures(features, boundingBoxIncurrentCrs.getGeometry(CrsTransformer.extractSridFromCrs((String)crs)), query);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("time to receive features" + (System.currentTimeMillis() - startTime)));
        }
        return features;
    }

    public int getFeatureCount(String query, BoundingBox bb) {
        try {
            String crs = CismapBroker.getInstance().getDefaultCrs();
            CrsTransformer transformer = new CrsTransformer(crs);
            BoundingBox boundingBox2 = transformer.transformBoundingBox(bb, CismapBroker.getInstance().getSrs().getCode());
            CidsLayerSearchStatement serverSearch = new CidsLayerSearchStatement(this.metaClass, SessionManager.getSession().getUser());
            int srid = CrsTransformer.extractSridFromCrs((String)CismapBroker.getInstance().getSrs().getCode());
            serverSearch.setSrid(CismapBroker.getInstance().getDefaultCrsAlias());
            boolean ignoreGeoLimitations = this.envelope.coveredBy(boundingBox2.getGeometry(srid));
            if (!(boundingBox2 == null || this.envelope != null && ignoreGeoLimitations)) {
                serverSearch.setX1(boundingBox2.getX1());
                serverSearch.setY1(boundingBox2.getY1());
                serverSearch.setX2(boundingBox2.getX2());
                serverSearch.setY2(boundingBox2.getY2());
            }
            serverSearch.setCountOnly(true);
            serverSearch.setQuery(this.adjustQuery(query));
            Collection resultCollection = SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)serverSearch, this.getConnectionContext());
            ArrayList resultArray = (ArrayList)resultCollection;
            if (resultArray != null && resultArray.size() > 0 && ((ArrayList)resultArray.get(0)).size() > 0) {
                return ((Number)((ArrayList)resultArray.get(0)).get(0)).intValue();
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Cannot determine the feature count", (Throwable)e);
        }
        return 0;
    }

    public String adjustQuery(String query) {
        boolean inQuote = false;
        boolean inDoubleQuote = false;
        StringBuilder sb = new StringBuilder();
        StringBuilder result = new StringBuilder();
        if (query == null) {
            return null;
        }
        try {
            for (int i = 0; i < query.length(); ++i) {
                char c = query.charAt(i);
                if (c == '\'') {
                    result.append(this.replaceColonWhenRequired(sb.toString()));
                    result.append(c);
                    inQuote = !inQuote;
                    sb.delete(0, sb.length());
                    continue;
                }
                if (c == '\"') {
                    result.append(this.replaceColonWhenRequired(sb.toString()));
                    result.append(c);
                    sb.delete(0, sb.length());
                    inDoubleQuote = !inDoubleQuote;
                    continue;
                }
                if (c == ',' && !inQuote && !inDoubleQuote) {
                    sb.append(',');
                    continue;
                }
                if (Character.isAlphabetic(c) || Character.isDigit(c)) {
                    sb.append(c);
                    continue;
                }
                if (Character.isSpaceChar(c)) {
                    result.append(this.replaceColonWhenRequired(sb.toString()));
                    result.append(c);
                    sb.delete(0, sb.length());
                    continue;
                }
                result.append(this.replaceColonWhenRequired(sb.toString()));
                result.append(c);
                sb.delete(0, sb.length());
            }
            if (sb.length() > 0) {
                result.append(this.replaceColonWhenRequired(sb.toString()));
            }
            return result.toString();
        }
        catch (Throwable t) {
            this.logger.error((Object)("Cannot parse query: " + query), t);
            return query;
        }
    }

    private String replaceColonWhenRequired(String value) {
        if (value.contains(",") && value.indexOf(",") == value.lastIndexOf(",") && value.indexOf(",") != value.length() - 1) {
            try {
                Double.parseDouble(value.replace(',', '.'));
                return value.replace(',', '.');
            }
            catch (NumberFormatException e) {
                return value;
            }
        }
        return value;
    }

    public Geometry getEnvelope() {
        return this.envelope;
    }

    public CidsLayerInfo getLayerInfo() {
        return this.layerInfo;
    }

    public void setLayerInfo(CidsLayerInfo layerInfo) {
        this.layerInfo = layerInfo;
    }

    public String getGeometryType() {
        return this.geometryType;
    }

    public final ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }
}

