/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.cidslayer;

import Sirius.navigator.connection.SessionManager;
import Sirius.server.localserver.attribute.ClassAttribute;
import Sirius.server.middleware.types.MetaClass;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cids.server.cidslayer.CidsLayerInfo;
import de.cismet.cismap.cidslayer.CidsFeatureFactory;
import de.cismet.cismap.cidslayer.CidsLayerFeature;
import de.cismet.cismap.cidslayer.LineAndStationCreator;
import de.cismet.cismap.cidslayer.PointAndStationCreator;
import de.cismet.cismap.cidslayer.StationCreator;
import de.cismet.cismap.cidslayer.StationLineCreator;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.features.FeatureSimplifier;
import de.cismet.cismap.commons.featureservice.AbstractFeatureService;
import de.cismet.cismap.commons.featureservice.DefaultLayerProperties;
import de.cismet.cismap.commons.featureservice.LayerProperties;
import de.cismet.cismap.commons.featureservice.factory.FeatureFactory;
import de.cismet.cismap.commons.gui.attributetable.AttributeTableRuleSet;
import de.cismet.cismap.commons.gui.attributetable.DefaultAttributeTableRuleSet;
import de.cismet.cismap.commons.gui.attributetable.FeatureCreator;
import de.cismet.cismap.commons.gui.attributetable.creator.PrimitiveGeometryCreator;
import de.cismet.cismap.commons.gui.piccolo.FeatureAnnotationSymbol;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;

public class CidsLayer
extends AbstractFeatureService<CidsLayerFeature, String>
implements ConnectionContextProvider {
    private static final transient Logger LOG = Logger.getLogger(CidsLayer.class);
    public static final String CIDS_FEATURELAYER_TYPE = "cidsFeatureService";
    private static final Map<Integer, ImageIcon> ICON_MAP = new HashMap<Integer, ImageIcon>();
    private String query;
    private String tableName;
    private MetaClass metaClass;
    private String metaDocumentLink;
    private boolean downloadAllowed;
    private String geometryType = AbstractFeatureService.UNKNOWN;
    private Integer maxFeaturesPerPage = null;
    private Double maxArea = null;
    private Double maxScale = null;
    private final ConnectionContext connectionContext = ConnectionContext.createDummy();

    public CidsLayer(CidsLayer cl) {
        super((AbstractFeatureService)cl);
        this.tableName = cl.tableName;
        this.query = cl.getQuery();
        this.metaClass = cl.metaClass;
        this.metaDocumentLink = cl.metaDocumentLink;
        this.downloadAllowed = cl.downloadAllowed;
        this.maxFeaturesPerPage = cl.maxFeaturesPerPage;
        this.maxArea = cl.maxArea;
        this.maxScale = cl.maxScale;
        this.setRuleSetAndSimplifier();
    }

    public CidsLayer(Element e) throws Exception {
        super(e);
        this.additionalInitializationFromElement(e);
        this.evaluateClassAttributes();
    }

    public CidsLayer(MetaClass clazz) {
        this.name = CidsLayer.determineLayerName(clazz);
        this.tableName = clazz.getTableName();
        this.metaClass = clazz;
        this.setRuleSetAndSimplifier();
        this.evaluateClassAttributes();
    }

    private void evaluateClassAttributes() {
        ClassAttribute scaleAttr;
        ClassAttribute maxPageSizeAttr;
        ClassAttribute metaDocumentAttr = this.getMetaClass().getClassAttribute("metaDocument");
        if (metaDocumentAttr != null && metaDocumentAttr.getValue() != null) {
            this.metaDocumentLink = metaDocumentAttr.getValue().toString();
        }
        if ((maxPageSizeAttr = this.getMetaClass().getClassAttribute("maxPageSize")) != null && maxPageSizeAttr.getValue() != null) {
            try {
                this.maxFeaturesPerPage = Integer.parseInt(maxPageSizeAttr.getValue().toString());
            }
            catch (Exception e) {
                LOG.error((Object)("the max page size attribute does not contain a valid number: " + maxPageSizeAttr.getValue().toString()), (Throwable)e);
            }
        }
        try {
            String camalizedName = DefaultLayerProperties.camelize((String)this.getMetaClass().getName());
            camalizedName = String.valueOf(camalizedName.charAt(0)).toLowerCase() + camalizedName.substring(1);
            String downloadForbiddenName = camalizedName + "DownloadForbidden";
            boolean attrForbidden = SessionManager.getProxy().hasConfigAttr(SessionManager.getSession().getUser(), downloadForbiddenName, this.getConnectionContext());
            if (attrForbidden) {
                String downloadAllowedName = camalizedName + "DownloadAllowed";
                this.downloadAllowed = SessionManager.getProxy().hasConfigAttr(SessionManager.getSession().getUser(), downloadAllowedName, this.getConnectionContext());
            } else {
                this.downloadAllowed = true;
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error while checking the download permissions", (Throwable)e);
            this.downloadAllowed = false;
        }
        ClassAttribute areaAttr = this.metaClass.getClassAttribute("maxArea");
        if (areaAttr != null && areaAttr.getValue() != null) {
            try {
                this.maxArea = Double.parseDouble(areaAttr.getValue().toString());
            }
            catch (Exception e) {
                LOG.error((Object)("the max scale attribute does not contain a valid number: " + areaAttr.getValue().toString()), (Throwable)e);
            }
        }
        if ((scaleAttr = this.metaClass.getClassAttribute("maxScale")) != null && scaleAttr.getValue() != null) {
            try {
                this.maxScale = Double.parseDouble(scaleAttr.getValue().toString());
            }
            catch (Exception e) {
                LOG.error((Object)("the max scale attribute does not contain a valid number: " + scaleAttr.getValue().toString()), (Throwable)e);
            }
        }
    }

    protected LayerProperties createLayerProperties() {
        DefaultLayerProperties defaultLayerProperties = new DefaultLayerProperties();
        FeatureAnnotationSymbol symbol = new FeatureAnnotationSymbol(new ImageIcon(((Object)((Object)this)).getClass().getResource("/de/cismet/cismap/commons/gui/res/pushpin.png")).getImage());
        symbol.setSweetSpotX(0.46);
        symbol.setSweetSpotY(0.9);
        defaultLayerProperties.getStyle().setPointSymbol(symbol);
        defaultLayerProperties.setFeatureService((AbstractFeatureService)this);
        defaultLayerProperties.setIdExpression("id", 1);
        return defaultLayerProperties;
    }

    public static String determineLayerName(MetaClass clazz) {
        ClassAttribute titleAttribute = clazz.getClassAttribute("cidsLayerTitle");
        String name = titleAttribute != null && titleAttribute.getValue() != null ? titleAttribute.getValue().toString() : clazz.getName();
        return name;
    }

    private void setRuleSetAndSimplifier() {
        String ruleSetName = DefaultLayerProperties.camelize((String)this.metaClass.getName()) + "RuleSet";
        try {
            Class<?> ruleSetClass = Class.forName("de.cismet.cismap.custom.attributerule." + ruleSetName);
            Object o = ruleSetClass.newInstance();
            if (o instanceof DefaultAttributeTableRuleSet) {
                ((DefaultLayerProperties)this.getLayerProperties()).setAttributeTableRuleSet((AttributeTableRuleSet)((DefaultAttributeTableRuleSet)o));
            }
        }
        catch (Exception ruleSetClass) {
            // empty catch block
        }
        String simplifierName = DefaultLayerProperties.camelize((String)this.metaClass.getName()) + "FeatureSimplifier";
        try {
            Class<?> simplifierClass = Class.forName("de.cismet.cismap.custom.simplifier." + simplifierName);
            Object o = simplifierClass.newInstance();
            if (o instanceof FeatureSimplifier) {
                ((DefaultLayerProperties)this.getLayerProperties()).setFeatureSimplifier((FeatureSimplifier)o);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected FeatureFactory createFeatureFactory() throws Exception {
        Map styles = this.parseSLD(this.getSLDDefiniton());
        this.featureFactory = new CidsFeatureFactory(this.metaClass, this.getLayerProperties(), styles);
        this.geometryType = ((CidsFeatureFactory)this.featureFactory).getGeometryType();
        return this.featureFactory;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
        if (this.featureFactory != null) {
            ((CidsFeatureFactory)this.featureFactory).initEnvelope(query);
        }
    }

    protected void initConcreteInstance() throws Exception {
    }

    protected String getFeatureLayerType() {
        return CIDS_FEATURELAYER_TYPE;
    }

    public Icon getLayerIcon(int type) {
        return ICON_MAP.get(type);
    }

    public CidsLayer clone() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("cloning CidsLayer " + this.getName()));
        }
        return new CidsLayer(this);
    }

    public Element toElement() {
        Element parentElement = super.toElement();
        Element className = new Element("className");
        className.setText(this.tableName);
        parentElement.addContent((Content)className);
        if (this.query != null && !this.query.isEmpty()) {
            Element queryElement = new Element("currentQuery");
            queryElement.addContent(this.query);
            parentElement.addContent((Content)queryElement);
        }
        return parentElement;
    }

    public void additionalInitializationFromElement(Element element) throws Exception {
        this.tableName = element.getChildText("className").trim();
        this.metaClass = ClassCacheMultiple.getMetaClass((String)SessionManager.getSession().getUser().getDomain(), (String)this.tableName, (ConnectionContext)this.getConnectionContext());
        if (this.metaClass == null) {
            return;
        }
        this.setRuleSetAndSimplifier();
        String queryText = element.getChildText("currentQuery");
        if (queryText != null) {
            this.setQuery(queryText);
        }
    }

    public boolean isVisibleInBoundingBox(XBoundingBox box) {
        if ((this.getMaxArea() != null || this.getMaxScale() != null) && box != null) {
            Geometry bbox = box.getGeometry();
            bbox = CrsTransformer.transformToMetricCrs((Geometry)bbox);
            if (this.getMaxArea() != null && bbox.getArea() > this.getMaxArea() || this.getMaxScale() != null && CismapBroker.getInstance().getMappingComponent().getScaleDenominator() > this.getMaxScale()) {
                return false;
            }
        }
        return super.isVisibleInBoundingBox(box);
    }

    public boolean isEditable() {
        if (this.metaClass != null && this.metaClass.getPermissions() != null) {
            return this.metaClass.getPermissions().hasWritePermission(SessionManager.getSession().getUser());
        }
        return true;
    }

    public String decoratePropertyName(String name) {
        try {
            this.initAndWait();
            CidsLayerInfo info = ((CidsFeatureFactory)this.getFeatureFactory()).getLayerInfo();
            AttributeTableRuleSet ruleSet = this.getLayerProperties().getAttributeTableRuleSet();
            if (ruleSet != null && ruleSet.getAdditionalFieldFormula(name) != null) {
                return this.decorateQuery(ruleSet.getAdditionalFieldFormula(name));
            }
            return CidsLayer.getSQLName(info, name);
        }
        catch (Exception ex) {
            LOG.error((Object)"Error while decorating property name", (Throwable)ex);
            return name;
        }
    }

    public boolean decorateLater() {
        return true;
    }

    public String decorateQuery(String query) {
        int TEXT_DELIMITER = 39;
        StringBuilder decoratedQuery = new StringBuilder(query);
        boolean inDelimiter = false;
        StringBuilder lastWord = new StringBuilder();
        for (int i = 0; i < decoratedQuery.length(); ++i) {
            char currentCharacter = decoratedQuery.charAt(i);
            if (!inDelimiter && (Character.isAlphabetic(currentCharacter) || Character.isDigit(currentCharacter) || currentCharacter == '_')) {
                lastWord.append(currentCharacter);
            } else if (!inDelimiter && lastWord.length() > 0) {
                String decoratedName = this.decoratePropertyName(lastWord.toString());
                if (!lastWord.toString().equals(decoratedName) && currentCharacter != '(') {
                    decoratedQuery.replace(i - lastWord.length(), i, decoratedName);
                    i += decoratedName.length() - lastWord.length();
                }
                lastWord.setLength(0);
            } else {
                lastWord.setLength(0);
            }
            if (currentCharacter != '\'') continue;
            inDelimiter = !inDelimiter;
        }
        return decoratedQuery.toString();
    }

    public static String getSQLName(CidsLayerInfo info, String name) {
        String[] colNames = info.getColumnNames();
        for (int i = 0; i < colNames.length; ++i) {
            if (!colNames[i].equals(name)) continue;
            if (info.getSqlColumnNames()[i].indexOf(".") != -1 && info.getSqlColumnNames()[i].indexOf(".") < info.getSqlColumnNames()[i].length()) {
                String colName = info.getSqlColumnNames()[i].toLowerCase();
                return colName.substring(0, colName.lastIndexOf(".") + 1) + "\"" + colName.substring(colName.lastIndexOf(".") + 1) + "\"";
            }
            return info.getSqlColumnNames()[i];
        }
        return name;
    }

    public MetaClass getMetaClass() {
        return this.metaClass;
    }

    public String getId() {
        return ((Object)((Object)this)).getClass().getName() + this.tableName;
    }

    public String getGeometryType() {
        if ((this.geometryType == null || this.geometryType.equals(AbstractFeatureService.UNKNOWN)) && this.getLayerProperties() != null && this.getLayerProperties().getAttributeTableRuleSet() != null) {
            AttributeTableRuleSet set = this.getLayerProperties().getAttributeTableRuleSet();
            FeatureCreator creator = set.getFeatureCreator();
            if (creator instanceof PrimitiveGeometryCreator) {
                if (((PrimitiveGeometryCreator)creator).isMulti()) {
                    if (((PrimitiveGeometryCreator)creator).getMode().equals("LINESTRING")) {
                        return "MultiLineString";
                    }
                    if (((PrimitiveGeometryCreator)creator).getMode().equals("POINT")) {
                        return "MultiPoint";
                    }
                    if (((PrimitiveGeometryCreator)creator).getMode().equals("POLYGON")) {
                        return "MultiPolygon";
                    }
                } else {
                    if (((PrimitiveGeometryCreator)creator).getMode().equals("LINESTRING")) {
                        return "LineString";
                    }
                    if (((PrimitiveGeometryCreator)creator).getMode().equals("POINT")) {
                        return "Point";
                    }
                    if (((PrimitiveGeometryCreator)creator).getMode().equals("POLYGON")) {
                        return "Polygon";
                    }
                }
            } else {
                if (creator instanceof LineAndStationCreator || creator instanceof StationLineCreator) {
                    return "LineString";
                }
                if (creator instanceof PointAndStationCreator || creator instanceof StationCreator) {
                    return "Point";
                }
            }
        }
        return this.geometryType;
    }

    public String getMetaDocumentLink() {
        return this.metaDocumentLink;
    }

    public int getMaxFeaturesPerPage() {
        if (this.maxFeaturesPerPage == null) {
            return -1;
        }
        return this.maxFeaturesPerPage;
    }

    public String[] getCalculatedAttributes() {
        if (this.getLayerProperties() != null && this.getLayerProperties().getAttributeTableRuleSet() != null) {
            return this.getLayerProperties().getAttributeTableRuleSet().getAdditionalFieldNames();
        }
        return super.getCalculatedAttributes();
    }

    public Double getMaxArea() {
        return this.maxArea;
    }

    public Double getMaxScale() {
        return this.maxScale;
    }

    public boolean isDownloadAllowed() {
        return this.downloadAllowed;
    }

    public final ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    public boolean equals(Object obj) {
        if (obj instanceof CidsLayer) {
            return ((CidsLayer)((Object)obj)).getMetaClass().equals((Object)this.metaClass);
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + Objects.hashCode(this.metaClass);
        return hash;
    }

    static {
        ICON_MAP.put(0, new ImageIcon(CidsLayer.class.getResource("/de/cismet/cismap/cidslayer/featureSupporter.png")));
        ICON_MAP.put(2, new ImageIcon(CidsLayer.class.getResource("/de/cismet/cismap/cidslayer/featureSupporter.png")));
        ICON_MAP.put(1, new ImageIcon(CidsLayer.class.getResource("/de/cismet/cismap/cidslayer/featureSupporter.png")));
        ICON_MAP.put(3, new ImageIcon(CidsLayer.class.getResource("/de/cismet/cismap/cidslayer/featureSupporter.png")));
    }
}

