/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.cidslayer;

import de.cismet.cismap.cidslayer.CidsLayerFeature;
import de.cismet.cismap.cidslayer.CidsLayerFeatureFilter;
import de.cismet.cismap.cidslayer.DefaultCidsLayerBindableReferenceCombo;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.featureservice.FeatureServiceAttribute;
import de.cismet.cismap.commons.gui.attributetable.AttributeTable;
import de.cismet.cismap.commons.gui.featureinfopanel.FeatureInfoPanel;
import de.cismet.cismap.commons.tools.FeatureTools;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.util.HashSet;
import javax.swing.AbstractCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.table.TableCellEditor;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.autocomplete.AutoCompleteDecorator;
import org.jdesktop.swingx.autocomplete.ObjectToStringConverter;

public class CidsLayerReferencedComboEditor
extends AbstractCellEditor
implements TableCellEditor {
    private static final Logger LOG = Logger.getLogger(CidsLayerReferencedComboEditor.class);
    private DefaultCidsLayerBindableReferenceCombo combo = new DefaultCidsLayerBindableReferenceCombo();
    private CidsLayerFeatureFilter filter;
    private FeatureServiceAttribute attr;
    private boolean useAutoCompleteDecorator = true;
    private ListCellRenderer listRenderer = null;
    private boolean nullable = false;
    private HashSet<DefaultCidsLayerBindableReferenceCombo> configuredCombos = new HashSet();
    private String sortingColumn = null;

    public CidsLayerReferencedComboEditor(FeatureServiceAttribute attr) {
        this(attr, null);
    }

    public CidsLayerReferencedComboEditor(FeatureServiceAttribute attr, boolean useAutoCompleteDecorator) {
        this(attr, useAutoCompleteDecorator, null);
    }

    public CidsLayerReferencedComboEditor(FeatureServiceAttribute attr, CidsLayerFeatureFilter filter) {
        this(attr, true, filter);
    }

    public CidsLayerReferencedComboEditor(FeatureServiceAttribute attr, boolean useAutoCompleteDecorator, CidsLayerFeatureFilter filter) {
        this.filter = filter;
        this.useAutoCompleteDecorator = useAutoCompleteDecorator;
        this.attr = attr;
    }

    @Override
    public Object getCellEditorValue() {
        Object value = this.combo.getSelectedItem();
        if (value == null) {
            return "";
        }
        try {
            return FeatureTools.convertObjectToClass((Object)this.combo.getSelectedItem(), (Class)FeatureTools.getClass((FeatureServiceAttribute)this.attr));
        }
        catch (Exception e) {
            LOG.error((Object)"Cannot convert the given object.", (Throwable)e);
            return null;
        }
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        FeatureInfoPanel infoPanel;
        FeatureServiceFeature feature;
        Container o = table;
        while (o.getParent() != null && !(o.getParent() instanceof AttributeTable) && !(o.getParent() instanceof FeatureInfoPanel)) {
            o = o.getParent();
        }
        if (o.getParent() instanceof AttributeTable) {
            AttributeTable tab = (AttributeTable)o.getParent();
            FeatureServiceFeature feature2 = tab.getFeatureByRow(row);
            if (feature2 instanceof CidsLayerFeature) {
                CidsLayerFeature cidsFeature = (CidsLayerFeature)feature2;
                this.combo = cidsFeature.getCatalogueCombo(this.attr.getName());
            }
        } else if (o.getParent() instanceof FeatureInfoPanel && (feature = (infoPanel = (FeatureInfoPanel)o.getParent()).getSelectedFeature()) instanceof CidsLayerFeature) {
            CidsLayerFeature cidsFeature = (CidsLayerFeature)feature;
            this.combo = cidsFeature.getCatalogueCombo(this.attr.getName());
        }
        if (this.combo != null && !this.configuredCombos.contains(this.combo)) {
            this.combo.setNullable(this.nullable);
            this.combo.setBeanFilter(this.filter);
            if (this.sortingColumn != null) {
                this.combo.setSortingColumn(this.sortingColumn);
            }
            if (this.useAutoCompleteDecorator) {
                AutoCompleteDecorator.decorate((JComboBox)this.combo, (ObjectToStringConverter)new ObjectToStringConverter(){

                    public String getPreferredStringForItem(Object o) {
                        if (o == null) {
                            return "";
                        }
                        return o.toString();
                    }
                });
            }
            if (this.getListRenderer() != null) {
                this.combo.setRenderer(this.getListRenderer());
            }
            this.configuredCombos.add(this.combo);
        }
        EventQueue.invokeLater(new Thread("RequestFocus"){

            @Override
            public void run() {
                CidsLayerReferencedComboEditor.this.combo.requestFocusInWindow();
            }
        });
        return this.combo;
    }

    public ListCellRenderer getListRenderer() {
        return this.listRenderer;
    }

    public void setListRenderer(ListCellRenderer listRenderer) {
        this.listRenderer = listRenderer;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    public String getSortingColumn() {
        return this.sortingColumn;
    }

    public void setSortingColumn(String sortingColumn) {
        this.sortingColumn = sortingColumn;
    }
}

