/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.cidslayer;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.exception.ConnectionException;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import Sirius.server.newuser.User;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.server.cidslayer.CidsLayerInfo;
import de.cismet.cids.tools.CidsLayerUtil;
import de.cismet.cismap.cidslayer.CidsLayer;
import de.cismet.cismap.cidslayer.CidsLayerFeature;
import de.cismet.cismap.cidslayer.DefaultCidsLayerBindableReferenceCombo;
import de.cismet.cismap.commons.BoundingBox;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.RetrievalServiceLayer;
import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.features.DefaultFeatureServiceFeature;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.featureservice.AbstractFeatureService;
import de.cismet.cismap.commons.featureservice.FeatureServiceAttribute;
import de.cismet.cismap.commons.gui.attributetable.AttributeTable;
import de.cismet.cismap.commons.gui.layerwidget.ZoomToLayerWorker;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.interaction.DefaultQueryButtonAction;
import de.cismet.cismap.commons.tools.FeatureTools;
import de.cismet.cismap.commons.util.SelectionManager;
import de.cismet.commons.cismap.io.converters.GeomFromWktConverter;
import de.cismet.commons.converter.ConversionException;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextProvider;
import de.cismet.tools.BrowserLauncher;
import de.cismet.tools.gui.StaticSwingTools;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.swing.Box;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;
import org.deegree.model.spatialschema.GeometryException;
import org.deegree.model.spatialschema.JTSAdapter;
import org.jdesktop.swingx.JXBusyLabel;
import org.openide.util.NbBundle;

public class FieldCalculatorDialog
extends JDialog
implements ConnectionContextProvider {
    private static final org.apache.log4j.Logger LOG = org.apache.log4j.Logger.getLogger(FieldCalculatorDialog.class);
    public static final List<DefaultQueryButtonAction> SQL_QUERY_BUTTONS = new ArrayList<DefaultQueryButtonAction>();
    private static final GeomFromWktConverter converter = new GeomFromWktConverter();
    private static final String RECEIVE_CATALOGUE_QUERY = "SELECT DISTINCT %1$s, %2$s FROM %3$s;";
    private static final DecimalFormat formatter = new DecimalFormat();
    private ExecutorService threadPool = Executors.newCachedThreadPool();
    private List<? extends Object> attributes;
    private AbstractFeatureService service;
    private FeatureServiceAttribute currentlyExpandedAttribute;
    private List<Object> values;
    private FeatureServiceAttribute attribute;
    private List<FeatureServiceFeature> featureList;
    private AttributeTable table;
    private boolean calculationStarted = false;
    private HashMap<String, TreeSet> foreignTablesMap = new HashMap();
    private List<FeatureServiceFeature> allFeaturesFromService = null;
    private final ConnectionContext connectionContext;
    private JPanel HintPanel;
    private JButton btnSearchCancel;
    private JList jAttributesLi;
    private JLabel jCommandLb;
    private JButton jGetValuesBn;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanelTasten;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JList jValuesLi;
    private JLabel jlShowIndividualValues;
    private JLabel labMathLink;
    private JLabel labStringLink;
    private JXBusyLabel lblBusyIcon;
    private JXBusyLabel lblBusyValueIcon;
    private JPanel panCommand;
    private Box.Filler strGap;
    private JTextArea taQuery;

    public FieldCalculatorDialog(AttributeTable table, boolean modal, AbstractFeatureService service, FeatureServiceAttribute attribute, List<FeatureServiceFeature> featureList, ConnectionContext connectionContext) {
        super(StaticSwingTools.getParentFrame((Component)table), modal);
        this.service = service;
        this.attribute = attribute;
        this.featureList = featureList;
        this.table = table;
        this.connectionContext = connectionContext;
        this.initComponents();
        this.jAttributesLi.setSelectionMode(0);
        this.jAttributesLi.addMouseListener(new MouseAdapterImpl());
        this.jValuesLi.setSelectionMode(0);
        this.jValuesLi.addMouseListener(new MouseAdapterImpl());
        this.jAttributesLi.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                String text = value.toString();
                if (value instanceof FeatureServiceAttribute) {
                    text = ((FeatureServiceAttribute)value).getName();
                }
                return super.getListCellRendererComponent(list, text, index, isSelected, cellHasFocus);
            }
        });
        this.jAttributesLi.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                if (FieldCalculatorDialog.this.attributes != null && FieldCalculatorDialog.this.jAttributesLi.getSelectedIndex() != -1) {
                    FieldCalculatorDialog.this.jGetValuesBn.setEnabled(true);
                } else {
                    FieldCalculatorDialog.this.jGetValuesBn.setEnabled(false);
                }
            }
        });
        this.jValuesLi.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component c = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value instanceof MetaObject && c instanceof JLabel) {
                    MetaObject mo = (MetaObject)value;
                    ((JLabel)c).setText(mo.getID() + " - " + mo.toString());
                } else {
                    ((JLabel)c).setText(FieldCalculatorDialog.this.featureValueToString(value));
                }
                return c;
            }
        });
        this.init();
    }

    public void setAllFeaturesFromService(List<FeatureServiceFeature> allFeaturesFromService) {
        this.allFeaturesFromService = allFeaturesFromService;
    }

    public final ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    private String featureValueToString(Object value) {
        if (value instanceof Float || value instanceof Double) {
            Number valueNumber = (Number)value;
            return FeatureTools.FORMATTER.format(valueNumber);
        }
        return value == null ? "" : String.valueOf(value);
    }

    private void init() {
        AbstractFeatureService afs = this.service;
        Map newAttribMap = afs.getFeatureServiceAttributes();
        ArrayList<? extends Object> newAttributes = new ArrayList<Object>();
        for (String attr : afs.getOrderedFeatureServiceAttributes()) {
            FeatureServiceAttribute fsa = (FeatureServiceAttribute)newAttribMap.get(attr);
            if (attr == null) continue;
            newAttributes.add(fsa);
        }
        List<? extends Object> old = this.attributes;
        this.attributes = newAttributes;
        if (this.attributes != old) {
            this.firePropertyChange("attributes", old, this.attributes);
            DefaultListModel model = (DefaultListModel)this.jAttributesLi.getModel();
            model.clear();
            for (Object object : this.attributes) {
                model.addElement(object);
            }
        }
        this.jlShowIndividualValues.setText("");
        old = this.values;
        this.values = new LinkedList<Object>();
        this.firePropertyChange("values", old, this.values);
        this.fillButtonPanel();
    }

    private void fillButtonPanel() {
        int x = 0;
        int y = 0;
        List<DefaultQueryButtonAction> queryButtons = SQL_QUERY_BUTTONS;
        for (DefaultQueryButtonAction buttonAction : queryButtons) {
            JButton button = new JButton(buttonAction.getText());
            button.addActionListener((ActionListener)buttonAction);
            GridBagConstraints constraint = new GridBagConstraints(x, y, buttonAction.getWidth(), 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0);
            this.jPanelTasten.add((Component)button, constraint);
            buttonAction.setQueryTextArea(this.taQuery);
            if ((x += buttonAction.getWidth()) <= 6) continue;
            x = 0;
            ++y;
        }
        GridBagConstraints constraint = new GridBagConstraints(x, y, 7, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0);
        this.jPanelTasten.add((Component)this.HintPanel, constraint);
        this.jPanelTasten.invalidate();
        this.jPanelTasten.revalidate();
        this.jPanelTasten.repaint();
    }

    private void AppendString(String str) {
        if (this.taQuery.getText() != null && !this.taQuery.getText().isEmpty()) {
            try {
                if (!this.taQuery.getText(this.taQuery.getCaretPosition() - 1, 1).contains("(")) {
                    str = " " + str;
                }
            }
            catch (BadLocationException ex) {
                LOG.error((Object)"Error while appending string", (Throwable)ex);
                str = " " + str;
            }
        }
        this.taQuery.insert(str, this.taQuery.getCaretPosition());
    }

    private List<FeatureServiceFeature> getAllFeaturesFromService() {
        List allFeatures;
        if (this.allFeaturesFromService != null) {
            return this.allFeaturesFromService;
        }
        try {
            Geometry g = ZoomToLayerWorker.getServiceBounds((RetrievalServiceLayer)this.service);
            XBoundingBox bounds = null;
            if (g != null) {
                bounds = new XBoundingBox(g);
                String crs = CismapBroker.getInstance().getSrs().getCode();
                CrsTransformer trans = new CrsTransformer(crs);
                bounds = trans.transformBoundingBox(bounds);
            }
            allFeatures = this.service.getFeatureFactory().createFeatures(this.service.getQuery(), (BoundingBox)bounds, null, 0, 0, null);
        }
        catch (Exception e) {
            LOG.error((Object)"Cannot retrieve all features", (Throwable)e);
            allFeatures = this.service.getFeatureFactory().getLastCreatedFeatures();
        }
        return allFeatures;
    }

    private void initComponents() {
        this.HintPanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.labMathLink = new JLabel();
        this.labStringLink = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jAttributesLi = new JList();
        this.jScrollPane2 = new JScrollPane();
        this.jValuesLi = new JList();
        this.jPanelTasten = new JPanel();
        this.jPanel3 = new JPanel();
        this.jScrollPane3 = new JScrollPane();
        this.taQuery = new JTextArea();
        this.jCommandLb = new JLabel();
        this.jGetValuesBn = new JButton();
        this.panCommand = new JPanel();
        this.jPanel2 = new JPanel();
        this.lblBusyIcon = new JXBusyLabel(new Dimension(20, 20));
        this.strGap = new Box.Filler(new Dimension(5, 0), new Dimension(5, 25), new Dimension(5, Short.MAX_VALUE));
        this.btnSearchCancel = new JButton();
        this.jPanel1 = new JPanel();
        this.lblBusyValueIcon = new JXBusyLabel(new Dimension(20, 20));
        this.jlShowIndividualValues = new JLabel();
        this.HintPanel.setLayout(new GridBagLayout());
        this.jLabel1.setText(NbBundle.getMessage(FieldCalculatorDialog.class, (String)"FieldCalculatorDialog.jLabel1.text", (Object[])new Object[0]));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        this.HintPanel.add((Component)this.jLabel1, gridBagConstraints);
        this.labMathLink.setForeground(new Color(64, 64, 255));
        this.labMathLink.setText(NbBundle.getMessage(FieldCalculatorDialog.class, (String)"FieldCalculatorDialog.labMathLink.text", (Object[])new Object[0]));
        this.labMathLink.setCursor(new Cursor(12));
        this.labMathLink.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                FieldCalculatorDialog.this.labMathLinkMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.HintPanel.add((Component)this.labMathLink, gridBagConstraints);
        this.labStringLink.setForeground(new Color(64, 64, 255));
        this.labStringLink.setText(NbBundle.getMessage(FieldCalculatorDialog.class, (String)"FieldCalculatorDialog.labStringLink.text", (Object[])new Object[0]));
        this.labStringLink.setCursor(new Cursor(12));
        this.labStringLink.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                FieldCalculatorDialog.this.labStringLinkMouseClicked(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.HintPanel.add((Component)this.labStringLink, gridBagConstraints);
        this.setDefaultCloseOperation(2);
        this.setTitle(NbBundle.getMessage(FieldCalculatorDialog.class, (String)"FieldCalculatorDialog.title", (Object[])new Object[]{this.attribute.getAlias() != null && !this.attribute.getAlias().equals("") ? this.attribute.getAlias() : this.attribute.getName()}));
        this.getContentPane().setLayout(new GridBagLayout());
        this.jScrollPane1.setMinimumSize(new Dimension(258, 40));
        this.jAttributesLi.setModel(new DefaultListModel());
        this.jAttributesLi.setVisibleRowCount(0);
        this.jScrollPane1.setViewportView(this.jAttributesLi);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.jScrollPane1, gridBagConstraints);
        this.jScrollPane2.setMinimumSize(new Dimension(240, 40));
        this.jScrollPane2.setPreferredSize(new Dimension(240, 40));
        this.jValuesLi.setModel(new DefaultListModel());
        this.jValuesLi.setVisibleRowCount(0);
        this.jScrollPane2.setViewportView(this.jValuesLi);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.jScrollPane2, gridBagConstraints);
        this.jPanelTasten.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 20;
        gridBagConstraints.weighty = 1.0;
        this.jPanelTasten.add((Component)this.jPanel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.jPanelTasten, gridBagConstraints);
        this.jScrollPane3.setMinimumSize(new Dimension(262, 87));
        this.taQuery.setColumns(20);
        this.taQuery.setRows(5);
        this.jScrollPane3.setViewportView(this.taQuery);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.jScrollPane3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 21;
        this.getContentPane().add((Component)this.jCommandLb, gridBagConstraints);
        this.jGetValuesBn.setText(NbBundle.getMessage(FieldCalculatorDialog.class, (String)"FieldCalculatorDialog.jGetValuesBn.text"));
        this.jGetValuesBn.setEnabled(false);
        this.jGetValuesBn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FieldCalculatorDialog.this.jGetValuesBnActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jGetValuesBn, gridBagConstraints);
        this.panCommand.setLayout(new FlowLayout(2));
        this.jPanel2.setMinimumSize(new Dimension(125, 25));
        this.jPanel2.setPreferredSize(new Dimension(185, 30));
        this.jPanel2.setLayout(new FlowLayout(4, 0, 0));
        this.lblBusyIcon.setEnabled(false);
        this.jPanel2.add((Component)this.lblBusyIcon);
        this.jPanel2.add(this.strGap);
        this.btnSearchCancel.setText(NbBundle.getMessage(FieldCalculatorDialog.class, (String)"FieldCalculatorDialog.btnSearchCancel.text"));
        this.btnSearchCancel.setToolTipText(NbBundle.getMessage(FieldCalculatorDialog.class, (String)"FieldCalculatorDialog.btnSearchCancel.toolTipText"));
        this.btnSearchCancel.setMaximumSize(new Dimension(100, 25));
        this.btnSearchCancel.setMinimumSize(new Dimension(100, 25));
        this.btnSearchCancel.setPreferredSize(new Dimension(100, 25));
        this.btnSearchCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FieldCalculatorDialog.this.btnSearchCancelActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.btnSearchCancel);
        this.panCommand.add(this.jPanel2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.getContentPane().add((Component)this.panCommand, gridBagConstraints);
        this.jPanel1.setLayout(new FlowLayout(0));
        this.lblBusyValueIcon.setEnabled(false);
        this.jPanel1.add((Component)this.lblBusyValueIcon);
        this.jPanel1.add(this.jlShowIndividualValues);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.pack();
    }

    private void jGetValuesBnActionPerformed(ActionEvent evt) {
        if (this.jAttributesLi.getSelectedValue() == null) {
            return;
        }
        Object attributeObject = this.attributes.get(this.jAttributesLi.getSelectedIndex());
        this.lblBusyValueIcon.setEnabled(true);
        this.lblBusyValueIcon.setBusy(true);
        final FeatureServiceAttribute attributeInfo = (FeatureServiceAttribute)attributeObject;
        this.jGetValuesBn.setEnabled(false);
        this.threadPool.submit(new Runnable(){

            @Override
            public void run() {
                TreeSet set = new TreeSet();
                boolean setAlreadyFilled = false;
                if (FieldCalculatorDialog.this.service instanceof CidsLayer) {
                    try {
                        FeatureServiceFeature firstFeature = (FeatureServiceFeature)FieldCalculatorDialog.this.featureList.get(0);
                        CidsLayer cidsLayer = (CidsLayer)FieldCalculatorDialog.this.service;
                        CidsLayerInfo layerInfo = CidsLayerUtil.getCidsLayerInfo((MetaClass)cidsLayer.getMetaClass(), (User)SessionManager.getSession().getUser());
                        if (layerInfo.isCatalogue(attributeInfo.getName())) {
                            CidsLayerFeature cf = (CidsLayerFeature)firstFeature;
                            TreeSet cachedData = (TreeSet)FieldCalculatorDialog.this.foreignTablesMap.get(attributeInfo.getName());
                            if (cachedData != null) {
                                set = cachedData;
                            } else if (cf.getCatalogueCombo(attributeInfo.getName()) != null) {
                                FieldCalculatorDialog.this.waitForModel(cf.getCatalogueCombo(attributeInfo.getName()));
                                ComboBoxModel model = cf.getCatalogueCombo(attributeInfo.getName()).getModel();
                                for (int i = 0; i < model.getSize(); ++i) {
                                    if (model.getElementAt(i) == null) continue;
                                    set.add(model.getElementAt(i).toString());
                                }
                                FieldCalculatorDialog.this.foreignTablesMap.put(attributeInfo.getName(), set);
                            } else {
                                int referencedForeignClassId = layerInfo.getCatalogueClass(attributeInfo.getName());
                                MetaClass foreignClass = FieldCalculatorDialog.this.getMetaClass(referencedForeignClassId, cf.getBean().getMetaObject().getMetaClass());
                                DefaultCidsLayerBindableReferenceCombo catalogueEditor = new DefaultCidsLayerBindableReferenceCombo(foreignClass, true);
                                FieldCalculatorDialog.this.waitForModel(catalogueEditor);
                                ComboBoxModel model = catalogueEditor.getModel();
                                for (int i = 0; i < model.getSize(); ++i) {
                                    if (model.getElementAt(i) == null) continue;
                                    set.add(model.getElementAt(i).toString());
                                }
                                FieldCalculatorDialog.this.foreignTablesMap.put(attributeInfo.getName(), set);
                            }
                            setAlreadyFilled = true;
                        }
                    }
                    catch (Exception e) {
                        LOG.error((Object)"Cannot load features", (Throwable)e);
                    }
                }
                if (!setAlreadyFilled) {
                    List allFeatures = FieldCalculatorDialog.this.getAllFeaturesFromService();
                    for (Object tmp : allFeatures) {
                        FeatureServiceFeature tmpFeature = (FeatureServiceFeature)tmp;
                        Object attrValue = tmpFeature.getProperty(attributeInfo.getName());
                        if (attrValue == null) continue;
                        set.add(attrValue);
                    }
                }
                final TreeSet finalSet = set;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        List old = FieldCalculatorDialog.this.values;
                        FieldCalculatorDialog.this.values = new ArrayList(finalSet);
                        FieldCalculatorDialog.this.lblBusyValueIcon.setEnabled(false);
                        FieldCalculatorDialog.this.lblBusyValueIcon.setBusy(false);
                        FieldCalculatorDialog.this.jGetValuesBn.setEnabled(true);
                        FieldCalculatorDialog.this.jPanel1.repaint();
                        FieldCalculatorDialog.this.jScrollPane1.repaint();
                        FieldCalculatorDialog.this.jValuesLi.repaint();
                        FieldCalculatorDialog.this.doLayout();
                        FieldCalculatorDialog.this.repaint();
                        DefaultListModel model = (DefaultListModel)FieldCalculatorDialog.this.jValuesLi.getModel();
                        model.clear();
                        for (Object tmp : FieldCalculatorDialog.this.values) {
                            model.addElement(tmp);
                        }
                        FieldCalculatorDialog.this.firePropertyChange("values", old, FieldCalculatorDialog.this.values);
                    }
                });
            }
        });
        this.currentlyExpandedAttribute = attributeInfo;
        this.jlShowIndividualValues.setText(NbBundle.getMessage(FieldCalculatorDialog.class, (String)"FieldCalculatorDialog.jGetValuesBnActionPerformed().jlShowIndividualValues.text", (Object)this.currentlyExpandedAttribute.getName()));
    }

    private void btnSearchCancelActionPerformed(ActionEvent evt) {
        this.lblBusyIcon.setEnabled(true);
        this.lblBusyIcon.setBusy(true);
        this.threadPool.submit(new Runnable(){

            @Override
            public void run() {
                ScriptEngineManager manager = new ScriptEngineManager();
                ScriptEngine engine = manager.getEngineByName("js");
                HashMap<FeatureServiceFeature, Object> temporaryObjectMap = new HashMap<FeatureServiceFeature, Object>(FieldCalculatorDialog.this.featureList.size());
                try {
                    CidsLayerInfo layerInfo;
                    FeatureServiceFeature firstFeature = (FeatureServiceFeature)FieldCalculatorDialog.this.featureList.get(0);
                    ArrayList catElements = null;
                    if (firstFeature instanceof CidsLayerFeature && (layerInfo = ((CidsLayerFeature)firstFeature).getLayerInfo()).isCatalogue(FieldCalculatorDialog.this.attribute.getName())) {
                        CidsLayerFeature cf = (CidsLayerFeature)firstFeature;
                        catElements = new ArrayList();
                        if (cf.getCatalogueCombo(FieldCalculatorDialog.this.attribute.getName()) != null) {
                            FieldCalculatorDialog.this.waitForModel(cf.getCatalogueCombo(FieldCalculatorDialog.this.attribute.getName()));
                            ComboBoxModel model = cf.getCatalogueCombo(FieldCalculatorDialog.this.attribute.getName()).getModel();
                            for (int i = 0; i < model.getSize(); ++i) {
                                catElements.add(model.getElementAt(i));
                            }
                        } else {
                            int referencedForeignClassId = layerInfo.getCatalogueClass(FieldCalculatorDialog.this.attribute.getName());
                            MetaClass foreignClass = FieldCalculatorDialog.this.getMetaClass(referencedForeignClassId, cf.getBean().getMetaObject().getMetaClass());
                            DefaultCidsLayerBindableReferenceCombo catalogueEditor = new DefaultCidsLayerBindableReferenceCombo(foreignClass, true);
                            catElements = new ArrayList();
                            FieldCalculatorDialog.this.waitForModel(catalogueEditor);
                            ComboBoxModel model = catalogueEditor.getModel();
                            for (int i = 0; i < model.getSize(); ++i) {
                                catElements.add(model.getElementAt(i));
                            }
                        }
                    }
                    boolean invalidElementMessageShown = false;
                    for (FeatureServiceFeature feature : FieldCalculatorDialog.this.featureList) {
                        String dataDefinition = FieldCalculatorDialog.this.toVariableString(feature);
                        String code = FieldCalculatorDialog.this.taQuery.getText();
                        code = FieldCalculatorDialog.this.substituteLength(code, feature);
                        code = FieldCalculatorDialog.this.substituteArea(code, feature);
                        code = FieldCalculatorDialog.this.substituteX(code, feature);
                        code = FieldCalculatorDialog.this.substituteY(code, feature);
                        code = FieldCalculatorDialog.this.substituteLeft(code, feature);
                        code = FieldCalculatorDialog.this.substituteRight(code, feature);
                        code = dataDefinition + "\n " + code;
                        Object result = engine.eval(code);
                        if (catElements != null) {
                            if (result instanceof Double) {
                                result = formatter.format(result);
                            }
                            boolean catElementFound = false;
                            for (Object element : catElements) {
                                if ((element == null || result == null || !element.toString().equals(result.toString())) && (element != null || result != null)) continue;
                                temporaryObjectMap.put(feature, element);
                                catElementFound = true;
                            }
                            if (catElementFound || invalidElementMessageShown) continue;
                            invalidElementMessageShown = true;
                            JOptionPane.showMessageDialog(FieldCalculatorDialog.this, NbBundle.getMessage(FieldCalculatorDialog.class, (String)"FieldCalculatorDialog.btnSearchCancelActionPerformed().notFound.message", (Object)result), NbBundle.getMessage(FieldCalculatorDialog.class, (String)"FieldCalculatorDialog.btnSearchCancelActionPerformed().notFound.title"), 2);
                            continue;
                        }
                        temporaryObjectMap.put(feature, FeatureTools.convertObjectToClass((Object)result, (Class)FeatureTools.getClass((FeatureServiceAttribute)FieldCalculatorDialog.this.attribute)));
                    }
                    for (FeatureServiceFeature feature : temporaryObjectMap.keySet()) {
                        if (temporaryObjectMap.get(feature) instanceof CidsLayerFeature && feature instanceof CidsLayerFeature && ((CidsLayerFeature)feature).getCatalogueCombo(FieldCalculatorDialog.this.attribute.getName()) != null) {
                            ((CidsLayerFeature)feature).getCatalogueCombo(FieldCalculatorDialog.this.attribute.getName()).setSelectedItem(temporaryObjectMap.get(feature));
                        }
                        feature.setProperty(FieldCalculatorDialog.this.attribute.getName(), temporaryObjectMap.get(feature));
                        FieldCalculatorDialog.this.table.addModifiedFeature((DefaultFeatureServiceFeature)feature);
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)("invalid fromula: " + FieldCalculatorDialog.this.taQuery.getText()), (Throwable)e);
                    JOptionPane.showMessageDialog(FieldCalculatorDialog.this, e.getMessage(), NbBundle.getMessage(FieldCalculatorDialog.class, (String)"FieldCalculatorDialog.btnSearchCancelActionPerformed().error.title"), 0, null);
                }
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        FieldCalculatorDialog.this.calculationStarted = true;
                        List selectedFeatures = FieldCalculatorDialog.this.table.getSelectedFeatures();
                        FieldCalculatorDialog.this.table.refresh();
                        if (selectedFeatures != null && !selectedFeatures.isEmpty()) {
                            FieldCalculatorDialog.this.table.applySelection((Object)this, selectedFeatures, false);
                        }
                        SelectionManager.getInstance().addSelectedFeatures(FieldCalculatorDialog.this.featureList);
                        FieldCalculatorDialog.this.lblBusyIcon.setEnabled(false);
                        FieldCalculatorDialog.this.lblBusyIcon.setBusy(false);
                    }
                });
            }
        });
    }

    private void labMathLinkMouseClicked(MouseEvent evt) {
        try {
            BrowserLauncher.openURL((String)"https://wiki.selfhtml.org/wiki/JavaScript/Objekte/Math");
        }
        catch (Exception ex) {
            LOG.error((Object)"Error while trying to open a link", (Throwable)ex);
        }
    }

    private void labStringLinkMouseClicked(MouseEvent evt) {
        try {
            BrowserLauncher.openURL((String)"https://wiki.selfhtml.org/wiki/JavaScript/Objekte/String");
        }
        catch (Exception ex) {
            LOG.error((Object)"Error while trying to open a link", (Throwable)ex);
        }
    }

    private void waitForModel(DefaultCidsLayerBindableReferenceCombo combo) {
        String s = NbBundle.getMessage(DefaultCidsLayerBindableReferenceCombo.class, (String)"DefaultCidsLayerBindableReferenceCombo.loading");
        while (combo.getModel().getSize() == 1 && combo.getModel().getElementAt(0).equals(s)) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private MetaClass getMetaClass(int classId, MetaClass metaClass) throws ConnectionException {
        return SessionManager.getConnection().getMetaClass(SessionManager.getSession().getUser(), classId, metaClass.getDomain(), this.getConnectionContext());
    }

    private String substituteLength(String code, FeatureServiceFeature feature) {
        return this.preEvalProperty(code, feature, "geoLength", SubstitutionFunctions.LENGTH);
    }

    private String substituteArea(String code, FeatureServiceFeature feature) {
        return this.preEvalProperty(code, feature, "area", SubstitutionFunctions.AREA);
    }

    private String substituteX(String code, FeatureServiceFeature feature) {
        return this.preEvalProperty(code, feature, "x", SubstitutionFunctions.X);
    }

    private String substituteY(String code, FeatureServiceFeature feature) {
        return this.preEvalProperty(code, feature, "y", SubstitutionFunctions.Y);
    }

    private String substituteLeft(String code, FeatureServiceFeature feature) {
        return this.preEvalMethod(code, feature, "left", true);
    }

    private String substituteRight(String code, FeatureServiceFeature feature) {
        return this.preEvalMethod(code, feature, "right", false);
    }

    private String preEvalMethod(String code, FeatureServiceFeature feature, String methodName, boolean left) {
        Pattern p = Pattern.compile("([^\\s]+\\." + methodName + "\\([^\\)]+\\))");
        Matcher matcher = p.matcher(code);
        StringBuilder c = new StringBuilder(code);
        int offset = 0;
        while (matcher.find()) {
            String lengthString = matcher.group(0);
            String object = lengthString.substring(0, lengthString.lastIndexOf("."));
            String parameter = lengthString.substring(lengthString.lastIndexOf("(") + 1, lengthString.length() - 1);
            object = left ? object + ".slice(0, " + parameter + ")" : object + ".slice(" + object + ".length - " + parameter + ", " + object + ".length)";
            c.replace(matcher.start(0) + offset, matcher.end(0) + offset, object);
            offset += object.length() - (matcher.end(0) - matcher.start(0));
        }
        return c.toString();
    }

    private String preEvalProperty(String code, FeatureServiceFeature feature, String propertyName, SubstitutionFunctions function) {
        Pattern p = Pattern.compile("([^\\s]+\\." + propertyName + ")");
        Matcher matcher = p.matcher(code);
        StringBuilder c = new StringBuilder(code);
        int offset = 0;
        while (matcher.find()) {
            String object;
            block20: {
                String lengthString = matcher.group(0);
                object = lengthString.substring(0, lengthString.lastIndexOf("."));
                if (object.startsWith("'") && object.endsWith("'") || object.startsWith("\"") && object.endsWith("\"")) {
                    String geometryString = object.substring(1, object.length() - 1);
                    try {
                        Geometry geom = converter.convertForward(geometryString, new String[]{CismapBroker.getInstance().getSrs().getCode()});
                        if (function == SubstitutionFunctions.LENGTH) {
                            object = FeatureTools.FORMATTER.format(this.round(geom.getLength(), 2));
                            break block20;
                        }
                        if (function == SubstitutionFunctions.AREA) {
                            object = FeatureTools.FORMATTER.format(this.round(geom.getArea(), 2));
                            break block20;
                        }
                        if (function == SubstitutionFunctions.X) {
                            object = geom.getGeometryType().equalsIgnoreCase("Point") ? FeatureTools.FORMATTER.format(geom.getCoordinate().x) : FeatureTools.FORMATTER.format(geom.getCentroid().getCoordinate().x);
                            break block20;
                        }
                        if (function != SubstitutionFunctions.Y) break block20;
                        if (geom.getGeometryType().equalsIgnoreCase("Point")) {
                            object = FeatureTools.FORMATTER.format(geom.getCoordinate().y);
                            break block20;
                        }
                        object = FeatureTools.FORMATTER.format(geom.getCentroid().getCoordinate().y);
                    }
                    catch (ConversionException e) {
                        JOptionPane.showMessageDialog(this, object + " ist keine Geometrie", "Ung\u00fcltige Geometrie", 0);
                        object = "";
                    }
                } else {
                    Object geometryObject = feature.getProperty(object);
                    if (geometryObject instanceof org.deegree.model.spatialschema.Geometry) {
                        try {
                            geometryObject = JTSAdapter.export((org.deegree.model.spatialschema.Geometry)((org.deegree.model.spatialschema.Geometry)geometryObject));
                        }
                        catch (GeometryException ex) {
                            LOG.error((Object)"Error while converting deegree geometry to jts geometry", (Throwable)ex);
                        }
                    }
                    if (geometryObject instanceof Geometry) {
                        Geometry geometry = (Geometry)geometryObject;
                        if (function == SubstitutionFunctions.LENGTH) {
                            object = FeatureTools.FORMATTER.format(this.round(geometry.getLength(), 2));
                        } else if (function == SubstitutionFunctions.AREA) {
                            object = FeatureTools.FORMATTER.format(this.round(geometry.getArea(), 2));
                        } else if (function == SubstitutionFunctions.X) {
                            object = geometry.getGeometryType().equalsIgnoreCase("Point") ? FeatureTools.FORMATTER.format(geometry.getCoordinate().x) : FeatureTools.FORMATTER.format(geometry.getCentroid().getCoordinate().x);
                        } else if (function == SubstitutionFunctions.Y) {
                            object = geometry.getGeometryType().equalsIgnoreCase("Point") ? FeatureTools.FORMATTER.format(geometry.getCoordinate().y) : FeatureTools.FORMATTER.format(geometry.getCentroid().getCoordinate().y);
                        }
                    }
                }
            }
            c.replace(matcher.start(0) + offset, matcher.end(0) + offset, object);
            offset += object.length() - (matcher.end(0) - matcher.start(0));
        }
        return c.toString();
    }

    private double round(double value, int digits) {
        BigDecimal tmpValue = new BigDecimal(value);
        return tmpValue.setScale(digits, RoundingMode.HALF_UP).doubleValue();
    }

    private String toVariableString(FeatureServiceFeature feature) {
        StringBuilder vars = new StringBuilder("");
        HashMap props = feature.getProperties();
        for (String propName : props.keySet()) {
            FeatureServiceAttribute attr = (FeatureServiceAttribute)feature.getLayerProperties().getFeatureService().getFeatureServiceAttributes().get(propName);
            Class cl = FeatureTools.getClass((FeatureServiceAttribute)attr);
            Object value = props.get(propName);
            if (value instanceof org.deegree.model.spatialschema.Geometry) {
                try {
                    value = JTSAdapter.export((org.deegree.model.spatialschema.Geometry)((org.deegree.model.spatialschema.Geometry)value));
                }
                catch (GeometryException ex) {
                    LOG.error((Object)"Error while converting deegree geometry to jts geometry", (Throwable)ex);
                }
            }
            if (vars.length() > 0) {
                vars.append(";\n");
            }
            vars.append(propName.replace("app:", "")).append("=");
            if (value != null && (cl.equals(String.class) || cl.equals(Date.class))) {
                if (cl.equals(String.class)) {
                    vars.append("\"").append(String.valueOf(value).replace("\\", "\\\\").replace("\"", "\\\"")).append("\"");
                    continue;
                }
                vars.append("\"").append(value).append("\"");
                continue;
            }
            vars.append(String.valueOf(value));
        }
        vars.append(";\n");
        return vars.toString();
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(FieldCalculatorDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(FieldCalculatorDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(FieldCalculatorDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(FieldCalculatorDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public boolean isCalculationStarted() {
        return this.calculationStarted;
    }

    static {
        formatter.setGroupingUsed(false);
        SQL_QUERY_BUTTONS.add(new DefaultQueryButtonAction(".x", "x"){
            {
                this.startWithSpace = false;
            }
        });
        SQL_QUERY_BUTTONS.add(new DefaultQueryButtonAction("+", "++"));
        SQL_QUERY_BUTTONS.add(new DefaultQueryButtonAction("+"));
        SQL_QUERY_BUTTONS.add(new DefaultQueryButtonAction("="));
        SQL_QUERY_BUTTONS.add(new DefaultQueryButtonAction(".y", "y"){
            {
                this.startWithSpace = false;
            }
        });
        SQL_QUERY_BUTTONS.add(new MethodQueryButtonAction(".left", "left()"));
        SQL_QUERY_BUTTONS.add(new DefaultQueryButtonAction("-"));
        SQL_QUERY_BUTTONS.add(new DefaultQueryButtonAction("()"){
            {
                this.posCorrection = -1;
            }

            public void actionPerformed(ActionEvent e) {
                if (this.queryTextArea.getSelectionEnd() == 0) {
                    super.actionPerformed(e);
                } else {
                    int start = this.queryTextArea.getSelectionStart();
                    int end = this.queryTextArea.getSelectionEnd();
                    this.queryTextArea.insert("(", start);
                    this.queryTextArea.insert(")", end + 1);
                    if (start == end) {
                        this.CorrectCarret(this.posCorrection);
                    } else {
                        this.CorrectCarret(2);
                    }
                }
            }
        });
        SQL_QUERY_BUTTONS.add(new DefaultQueryButtonAction(".geoLength", "length"){
            {
                this.startWithSpace = false;
            }
        });
        SQL_QUERY_BUTTONS.add(new MethodQueryButtonAction(".right", "right()"));
        SQL_QUERY_BUTTONS.add(new DefaultQueryButtonAction("*"));
        SQL_QUERY_BUTTONS.add(new MethodQueryButtonAction("Math.round", "round"));
        SQL_QUERY_BUTTONS.add(new DefaultQueryButtonAction(".area", "area"){
            {
                this.startWithSpace = false;
            }
        });
        SQL_QUERY_BUTTONS.add(new DefaultQueryButtonAction(".length", "count"){
            {
                this.startWithSpace = false;
            }
        });
        SQL_QUERY_BUTTONS.add(new DefaultQueryButtonAction("/"));
        SQL_QUERY_BUTTONS.add(new MethodQueryButtonAction("parseInt", "integer"));
        SQL_QUERY_BUTTONS.add(new DefaultQueryButtonAction("null", "null"));
    }

    private static class MethodQueryButtonAction
    extends DefaultQueryButtonAction {
        private final String queryTextWithOutBraces;

        public MethodQueryButtonAction(String queryText, String text) {
            super(queryText + "()", text);
            this.posCorrection = -1;
            this.queryTextWithOutBraces = queryText;
        }

        public void actionPerformed(ActionEvent e) {
            if (this.queryTextArea.getSelectionEnd() == 0) {
                super.actionPerformed(e);
            } else {
                int start = this.queryTextArea.getSelectionStart();
                int end = this.queryTextArea.getSelectionEnd();
                this.queryTextArea.insert(this.queryTextWithOutBraces + "(", start);
                this.queryTextArea.insert(")", end + (this.queryTextWithOutBraces + "(").length());
                if (start == end) {
                    this.CorrectCarret(this.posCorrection);
                } else {
                    this.CorrectCarret(2);
                }
            }
        }
    }

    private class MouseAdapterImpl
    extends MouseAdapter {
        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                Class cl;
                String v;
                JList source = (JList)e.getSource();
                Object selectedObject = source.getSelectedValue();
                if (e.getSource() == FieldCalculatorDialog.this.jAttributesLi) {
                    selectedObject = FieldCalculatorDialog.this.attributes.get(FieldCalculatorDialog.this.jAttributesLi.getSelectedIndex());
                }
                String value = source == FieldCalculatorDialog.this.jAttributesLi ? (v = ((FeatureServiceAttribute)selectedObject).getName()) : ((cl = FeatureTools.getClass((FeatureServiceAttribute)FieldCalculatorDialog.this.currentlyExpandedAttribute)).equals(String.class) || cl.equals(Date.class) ? "\"" + selectedObject.toString() + "\"" : (selectedObject instanceof Float || selectedObject instanceof Double ? FeatureTools.FORMATTER.format(selectedObject) : String.valueOf(selectedObject)));
                FieldCalculatorDialog.this.AppendString(value);
            }
        }
    }

    private static enum SubstitutionFunctions {
        LENGTH,
        AREA,
        X,
        Y;

    }
}

