/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.cidslayer;

import Sirius.navigator.connection.SessionManager;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.operation.distance.DistanceOp;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cismap.commons.features.DefaultFeatureServiceFeature;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.featureservice.AbstractFeatureService;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.attributetable.FeatureCreatedEvent;
import de.cismet.cismap.commons.gui.attributetable.FeatureCreatedListener;
import de.cismet.cismap.commons.gui.attributetable.creator.AbstractFeatureCreator;
import de.cismet.cismap.commons.gui.attributetable.creator.CreaterGeometryListener;
import de.cismet.cismap.commons.gui.attributetable.creator.GeometryFinishedListener;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.CreateNewGeometryListener;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.LinearReferencedPointFeature;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.linearreferencing.LinearReferencingHelper;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextProvider;
import de.cismet.tools.gui.WaitingDialogThread;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class LineAndStationCreator
extends AbstractFeatureCreator
implements ConnectionContextProvider {
    private static final Logger LOG = Logger.getLogger(LineAndStationCreator.class);
    private static final String SUITABLE_ROUTE_QUERY = "select %1$s, %3$s.%2$s from %3$s join geom on (geom = geom.id) order by st_distance(geo_field, '%4$s') asc limit 1;";
    protected List<FeatureCreatedListener> listener = new ArrayList<FeatureCreatedListener>();
    private final String mode = "LINESTRING";
    private final String stationProperty;
    private final MetaClass routeClass;
    private final LinearReferencingHelper helper;
    private float minDistance = 0.0f;
    private float maxDistance = Float.MAX_VALUE;
    private AbstractFeatureService service = null;
    private final ConnectionContext connectionContext = ConnectionContext.createDummy();

    public LineAndStationCreator(String stationProperty, Map<String, Object> properties, MetaClass routeClass, LinearReferencingHelper helper) {
        this.properties = properties;
        this.routeClass = routeClass;
        this.helper = helper;
        this.stationProperty = stationProperty;
    }

    public String getStationProperty() {
        return this.stationProperty;
    }

    public MetaClass getRouteClass() {
        return this.routeClass;
    }

    public void createFeature(final MappingComponent mc, final FeatureServiceFeature feature) {
        if (feature != null && feature.getLayerProperties() != null) {
            this.service = feature.getLayerProperties().getFeatureService();
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                CreaterGeometryListener listener = new CreaterGeometryListener(mc, new GeometryFinishedListener(){

                    public void geometryFinished(final Geometry g) {
                        feature.setGeometry(g);
                        if (feature instanceof DefaultFeatureServiceFeature) {
                            try {
                                LineAndStationCreator.fillFeatureWithDefaultValues((DefaultFeatureServiceFeature)((DefaultFeatureServiceFeature)feature), (Map)LineAndStationCreator.this.properties);
                                WaitingDialogThread<Void> dia = new WaitingDialogThread<Void>(null, true, NbBundle.getMessage(LineAndStationCreator.class, (String)"LineAndStationCreator.createFeature()"), null, 100){

                                    protected Void doInBackground() throws Exception {
                                        Geometry firstPoint = this.createPointFromCoords(g.getCoordinates()[0], g.getFactory());
                                        Geometry lastPoint = this.createPointFromCoords(g.getCoordinates()[g.getNumPoints() - 1], g.getFactory());
                                        String query = String.format(LineAndStationCreator.SUITABLE_ROUTE_QUERY, LineAndStationCreator.this.getRouteClass().getID(), LineAndStationCreator.this.getRouteClass().getPrimaryKey(), LineAndStationCreator.this.getRouteClass().getTableName(), firstPoint.toText());
                                        MetaObject[] mo = SessionManager.getProxy().getMetaObjectByQuery(SessionManager.getSession().getUser(), query, LineAndStationCreator.this.getConnectionContext());
                                        if (mo != null && mo.length == 1) {
                                            CidsBean routeBean = mo[0].getBean();
                                            CidsBean firstStation = this.createStationFromRoute(routeBean, firstPoint);
                                            CidsBean lastStation = this.createStationFromRoute(routeBean, lastPoint);
                                            CidsBean lineBean = LineAndStationCreator.this.helper.createLineBeanFromRouteBean(routeBean);
                                            Double firstVal = (Double)firstStation.getProperty(LineAndStationCreator.this.helper.getValueProperty(firstStation));
                                            Double lastVal = (Double)lastStation.getProperty(LineAndStationCreator.this.helper.getValueProperty(lastStation));
                                            LineAndStationCreator.this.helper.setLinearValueToStationBean(firstVal, LineAndStationCreator.this.helper.getStationBeanFromLineBean(lineBean, true));
                                            LineAndStationCreator.this.helper.setLinearValueToStationBean(lastVal, LineAndStationCreator.this.helper.getStationBeanFromLineBean(lineBean, false));
                                            feature.setProperty(LineAndStationCreator.this.getStationProperty(), (Object)lineBean);
                                        }
                                        ((DefaultFeatureServiceFeature)feature).saveChanges();
                                        return null;
                                    }

                                    protected void done() {
                                        try {
                                            this.get();
                                            for (FeatureCreatedListener featureCreatedListener : LineAndStationCreator.this.listener) {
                                                featureCreatedListener.featureCreated(new FeatureCreatedEvent((Object)LineAndStationCreator.this, feature));
                                            }
                                        }
                                        catch (Exception e) {
                                            LOG.error((Object)"Cannot save new feature", (Throwable)e);
                                        }
                                    }
                                };
                                dia.start();
                            }
                            catch (Exception e) {
                                LOG.error((Object)"Cannot save new feature", (Throwable)e);
                            }
                        }
                    }

                    private CidsBean createStationFromRoute(CidsBean routeBean, Geometry point) {
                        Coordinate[] firstCoords = DistanceOp.nearestPoints((Geometry)LineAndStationCreator.this.helper.getGeometryFromRoute(routeBean), (Geometry)point);
                        double firstPosition = LinearReferencedPointFeature.getPositionOnLine((Coordinate)firstCoords[0], (Geometry)LineAndStationCreator.this.helper.getGeometryFromRoute(routeBean));
                        CidsBean station = LineAndStationCreator.this.helper.createStationBeanFromRouteBean(routeBean, firstPosition);
                        return station;
                    }

                    private Geometry createPointFromCoords(Coordinate coord, GeometryFactory factory) {
                        return factory.createPoint(coord);
                    }
                });
                mc.addInputListener("SimpleGeometryCreater", (PBasicInputEventHandler)listener);
                mc.putCursor("SimpleGeometryCreater", new Cursor(1));
                listener.setMode("LINESTRING");
                if (CismapBroker.getInstance() != null && CismapBroker.getInstance().getMappingComponent() != null) {
                    CreateNewGeometryListener result = (CreateNewGeometryListener)CismapBroker.getInstance().getMappingComponent().getInputListener("NEW_POLYGON");
                    listener.setShowCurrentLength(result.isShowCurrentLength());
                }
                mc.setInteractionMode("SimpleGeometryCreater");
            }
        });
    }

    public void addFeatureCreatedListener(FeatureCreatedListener listener) {
        this.listener.add(listener);
    }

    public String getTypeName() {
        return NbBundle.getMessage(LineAndStationCreator.class, (String)"PointAndStationCreator.getTypeName()");
    }

    public void cancel() {
    }

    public void resume() {
        CismapBroker.getInstance().getMappingComponent().setInteractionMode("SimpleGeometryCreater");
    }

    public AbstractFeatureService getService() {
        return this.service;
    }

    public final ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }
}

