/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.cidslayer;

import Sirius.server.middleware.types.MetaClass;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cismap.cidslayer.StationCreationCheck;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.features.DefaultFeatureServiceFeature;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.featureservice.AbstractFeatureService;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.attributetable.FeatureCreatedEvent;
import de.cismet.cismap.commons.gui.attributetable.FeatureCreatedListener;
import de.cismet.cismap.commons.gui.attributetable.creator.AbstractFeatureCreator;
import de.cismet.cismap.commons.gui.piccolo.PFeature;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.linearreferencing.CreateLinearReferencedLineListener;
import de.cismet.cismap.linearreferencing.CreateStationLineListener;
import de.cismet.cismap.linearreferencing.LinearReferencingHelper;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class StationLineCreator
extends AbstractFeatureCreator {
    private static final Logger LOG = Logger.getLogger(StationLineCreator.class);
    protected List<FeatureCreatedListener> listener = new ArrayList<FeatureCreatedListener>();
    private String property;
    private MetaClass routeClass;
    private LinearReferencingHelper helper;
    private float minDistance = 0.004f;
    private float maxDistance = Float.MAX_VALUE;
    private String routeName;
    private StationCreationCheck check;
    private AbstractFeatureService service = null;
    private CreateLinearReferencedLineListener lastListener = null;

    public StationLineCreator(String property, MetaClass routeClass, String routeName, LinearReferencingHelper helper) {
        this(property, routeClass, routeName, helper, 0.0f);
    }

    public StationLineCreator(String property, MetaClass routeClass, String routeName, LinearReferencingHelper helper, float minDistance) {
        this(property, routeClass, routeName, helper, minDistance, Float.MAX_VALUE);
    }

    public StationLineCreator(String property, MetaClass routeClass, String routeName, LinearReferencingHelper helper, float minDistance, float maxDistance) {
        this.property = property;
        this.routeClass = routeClass;
        this.helper = helper;
        this.minDistance = minDistance;
        this.maxDistance = maxDistance;
        this.routeName = routeName;
    }

    public StationCreationCheck getCheck() {
        return this.check;
    }

    public void setCheck(StationCreationCheck check) {
        this.check = check;
    }

    public void createFeature(final MappingComponent mc, final FeatureServiceFeature feature) {
        if (feature != null && feature.getLayerProperties() != null) {
            this.service = feature.getLayerProperties().getFeatureService();
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                CreateLinearReferencedLineListener listener = new CreateLinearReferencedLineListener(mc, new CreateStationLineListener(){

                    @Override
                    public void lineFinished(CidsBean route, Geometry lineGeom, Geometry startGeom, Geometry endGeom, double start, double end) {
                        if (route == null || StationLineCreator.this.check != null && !StationLineCreator.this.check.isStationValid(route, start, end)) {
                            return;
                        }
                        lineGeom = CrsTransformer.transformToDefaultCrs((Geometry)lineGeom);
                        lineGeom.setSRID(CismapBroker.getInstance().getDefaultCrsAlias());
                        CidsBean line = StationLineCreator.this.helper.createLineBeanFromRouteBean(route);
                        CidsBean startStation = StationLineCreator.this.helper.createStationBeanFromRouteBean(route, start);
                        CidsBean endStation = StationLineCreator.this.helper.createStationBeanFromRouteBean(route, end);
                        try {
                            StationLineCreator.this.helper.setGeometryToLineBean(lineGeom, line);
                            line.setProperty("von", (Object)startStation);
                            line.setProperty("bis", (Object)endStation);
                        }
                        catch (Exception ex) {
                            LOG.error((Object)"Error while creating new line feature", (Throwable)ex);
                        }
                        feature.setProperty(StationLineCreator.this.property, (Object)line);
                        feature.setGeometry(lineGeom);
                        if (feature instanceof DefaultFeatureServiceFeature) {
                            try {
                                StationLineCreator.fillFeatureWithDefaultValues((DefaultFeatureServiceFeature)((DefaultFeatureServiceFeature)feature), (Map)StationLineCreator.this.properties);
                                ((DefaultFeatureServiceFeature)feature).saveChanges();
                                for (FeatureCreatedListener featureCreatedListener : StationLineCreator.this.listener) {
                                    featureCreatedListener.featureCreated(new FeatureCreatedEvent((Object)StationLineCreator.this, feature));
                                }
                            }
                            catch (Exception e) {
                                LOG.error((Object)"Cannot save new feature", (Throwable)e);
                            }
                        }
                    }
                }, StationLineCreator.this.routeClass, StationLineCreator.this.routeName, StationLineCreator.this.minDistance, StationLineCreator.this.maxDistance, StationLineCreator.this.check);
                listener.setIdenticalPositionDelta(StationLineCreator.this.minDistance);
                mc.addInputListener("CREATE_NEW_STATION_LINE", (PBasicInputEventHandler)listener);
                mc.setInteractionMode("CREATE_NEW_STATION_LINE");
                StationLineCreator.this.lastListener = listener;
            }
        });
    }

    public void addFeatureCreatedListener(FeatureCreatedListener listener) {
        this.listener.add(listener);
    }

    public String getTypeName() {
        return "stationierte Linie";
    }

    public void cancel() {
    }

    public void resume() {
        CismapBroker.getInstance().getMappingComponent().setInteractionMode("CREATE_NEW_STATION_LINE");
        if (this.lastListener != null) {
            this.lastListener.resumed();
        }
    }

    public AbstractFeatureService getService() {
        return this.service;
    }

    public boolean isCreationAllowed(MappingComponent mc) {
        PFeature line = CreateLinearReferencedLineListener.getSelectedLinePFeature(mc, this.routeClass);
        if (this.check == null) {
            return true;
        }
        return line == null || this.check != null && this.check.isRouteValid(line);
    }
}

